/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.agiledataquery.filter;

import com.digiwin.athena.agiledataquery.utils.ThreadLocalCleanupUtil;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@WebFilter(urlPatterns={"/*"})
@Order(value=0x7FFFFFFF)
public class ThreadLocalCleanupFilter
implements Filter {
    private static final Logger logger = LoggerFactory.getLogger(ThreadLocalCleanupFilter.class);

    public void init(FilterConfig filterConfig) throws ServletException {
        logger.info("ThreadLocalCleanupFilter initialized");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        try {
            chain.doFilter(request, response);
        }
        finally {
            try {
                ThreadLocalCleanupUtil.cleanupAllThreadLocals();
                logger.debug("ThreadLocal cleanup completed in filter");
            }
            catch (Exception e) {
                logger.error("Failed to cleanup ThreadLocal in filter", (Throwable)e);
            }
        }
    }

    public void destroy() {
        logger.info("ThreadLocalCleanupFilter destroyed");
    }
}

