/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.agiledataquery.interceptor;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.agiledataquery.config.IamConfig;
import com.digiwin.athena.agiledataquery.context.DWServiceContext;
import com.digiwin.athena.agiledataquery.model.DapResponse;
import com.digiwin.athena.agiledataquery.synonym.domain.AthenaUser;
import com.digiwin.athena.agiledataquery.synonym.domain.AthenaUserLocal;
import com.digiwin.athena.agiledataquery.utils.ThreadLocalCleanupUtil;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.servlet.DispatcherType;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.servlet.HandlerInterceptor;

@Component
public class UserLoginInterceptor
implements HandlerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(UserLoginInterceptor.class);
    private static final String ERR_MESSAGE = "\u7528\u6237token\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55\u6216\u8054\u7cfb\u5ba2\u670d\u4e13\u5458";
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private IamConfig iamConfig;
    @Autowired
    StringRedisTemplate stringRedisTemplate;
    @Value(value="${tokenExpireTime:7200}")
    private Long tokenExpireTime;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if (request.getDispatcherType() != DispatcherType.REQUEST) {
            return true;
        }
        String requestURI = request.getRequestURI();
        String userToken = request.getHeader("token");
        if (StringUtils.isEmpty((CharSequence)userToken) && StringUtils.isEmpty((CharSequence)(userToken = request.getHeader("Digi-Middleware-Auth-User")))) {
            userToken = request.getHeader("digi-middleware-auth-user");
        }
        log.info("\u5904\u7406\u65f6\u95f4: {},\u8bf7\u6c42\u8def\u5f84: {},\u8bf7\u6c42\u5934\u4fe1\u606f: {},\u8bf7\u6c42\u53c2\u6570: {},\u67e5\u8be2\u5b57\u7b26\u4e32: {}", new Object[]{new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").format(new Date()), requestURI, this.getRequestHeadersInfo(request), this.getRequestParamsInfo(request), request.getQueryString()});
        String cacheKey = "agiledataquery:SYSTEM:" + userToken + ":tenantToken";
        try {
            String profile = (String)this.stringRedisTemplate.opsForValue().get((Object)cacheKey);
            if (StringUtils.isNotEmpty((CharSequence)profile)) {
                DWServiceContext.getContext().setProfile((Map)JSONObject.parseObject((String)profile));
                JSONObject profileJson = JSONObject.parseObject((String)profile);
                AthenaUser athenaUser = (AthenaUser)JSONObject.parseObject((String)profile, AthenaUser.class);
                athenaUser.setToken(userToken);
                athenaUser.setLocale(request.getHeader("locale"));
                athenaUser.setUserId(profileJson.getString("id"));
                AthenaUserLocal.setUser((AthenaUser)athenaUser);
                return true;
            }
            HttpHeaders headers = new HttpHeaders();
            headers.add("Content-Type", "application/json");
            headers.add("digi-middleware-auth-app", this.iamConfig.getAppToken());
            headers.add("digi-middleware-auth-user", userToken);
            HttpEntity httpEntity = new HttpEntity((Object)new JSONObject(), (MultiValueMap)headers);
            ResponseEntity responseEntity = this.restTemplate.postForEntity(this.iamConfig.getAnalyzeAddr(), (Object)httpEntity, JSONObject.class, new Object[0]);
            if (!responseEntity.getStatusCode().is2xxSuccessful()) {
                log.warn("IAM\u670d\u52a1\u8fd4\u56de\u975e\u6210\u529f\u72b6\u6001\u7801: {}", (Object)responseEntity.getStatusCode());
                this.returnTokenCheckJson(response, Optional.ofNullable(responseEntity.getBody()).map(e -> e.getString("errorMessage")).orElse(ERR_MESSAGE));
                return false;
            }
            JSONObject contentProfile = (JSONObject)responseEntity.getBody();
            DWServiceContext.ContextData context = DWServiceContext.getContext();
            context.setProfile((Map)contentProfile);
            this.stringRedisTemplate.opsForValue().set((Object)cacheKey, (Object)JSON.toJSONString((Object)contentProfile), this.tokenExpireTime.longValue(), TimeUnit.SECONDS);
            AthenaUser athenaUser = (AthenaUser)JSONObject.parseObject((String)JSON.toJSONString((Object)contentProfile), AthenaUser.class);
            athenaUser.setToken(userToken);
            athenaUser.setLocale(request.getHeader("locale"));
            if (Objects.nonNull(contentProfile)) {
                athenaUser.setUserId(contentProfile.getString("id"));
            }
            AthenaUserLocal.setUser((AthenaUser)athenaUser);
        }
        catch (Exception e2) {
            log.error("=== Token\u9a8c\u8bc1\u5931\u8d25\u8be6\u7ec6\u4fe1\u606f ===,\u8bf7\u6c42\u8def\u5f84: {},\u9519\u8bef\u4fe1\u606f: {}", (Object)requestURI, (Object)e2);
            this.returnTokenCheckJson(response, ERR_MESSAGE);
            return false;
        }
        return true;
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        ThreadLocalCleanupUtil.cleanupAllThreadLocals();
    }

    private void returnTokenCheckJson(HttpServletResponse response, String returnMsg) {
        response.setCharacterEncoding("utf-8");
        response.setContentType("application/json; charset=utf-8");
        response.setStatus(HttpStatus.UNAUTHORIZED.value());
        try {
            DapResponse dapResponse = DapResponse.builder().status(Integer.valueOf(HttpStatus.UNAUTHORIZED.value())).statusDescription(returnMsg).build();
            response.getWriter().print(JSON.toJSONString((Object)dapResponse));
        }
        catch (IOException e) {
            log.warn("****** \u8bf7\u6c42token\u8bb8\u53ef\u62e6\u622a\u5668\u8fd4\u56de\u7ed3\u679c\u5f02\u5e38\uff1a{} ******", (Object)e.getMessage());
        }
    }

    private String getClientIpAddress(HttpServletRequest request) {
        String ip = request.getHeader("X-Forwarded-For");
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_CLIENT_IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_X_FORWARDED_FOR");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        return ip;
    }

    private String getRequestHeadersInfo(HttpServletRequest request) {
        StringBuilder headersInfo = new StringBuilder();
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String headerName = (String)headerNames.nextElement();
            headersInfo.append(headerName).append("=").append(request.getHeader(headerName)).append(", ");
        }
        if (headersInfo.length() > 0) {
            headersInfo.delete(headersInfo.length() - 2, headersInfo.length());
        }
        return headersInfo.toString();
    }

    private String getRequestParamsInfo(HttpServletRequest request) {
        StringBuilder paramsInfo = new StringBuilder();
        Enumeration paramNames = request.getParameterNames();
        while (paramNames.hasMoreElements()) {
            String paramName = (String)paramNames.nextElement();
            CharSequence[] paramValues = request.getParameterValues(paramName);
            if (paramValues == null || paramValues.length <= 0) continue;
            paramsInfo.append(paramName).append("=");
            if (paramValues.length == 1) {
                paramsInfo.append(paramValues[0]);
            } else {
                paramsInfo.append("[").append(String.join((CharSequence)",", paramValues)).append("]");
            }
            paramsInfo.append(", ");
        }
        if (paramsInfo.length() > 0) {
            paramsInfo.delete(paramsInfo.length() - 2, paramsInfo.length());
        }
        return paramsInfo.toString();
    }
}

