/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.agiledataquery.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.digiwin.athena.agiledataquery.clients.IamService;
import com.digiwin.athena.agiledataquery.clients.KgService;
import com.digiwin.athena.agiledataquery.context.DWServiceContext;
import com.digiwin.athena.agiledataquery.dao.MongoEntityBaseDAO;
import com.digiwin.athena.agiledataquery.domain.activity.Activity;
import com.digiwin.athena.agiledataquery.domain.app.Application;
import com.digiwin.athena.agiledataquery.domain.app.ApplicationRelation;
import com.digiwin.athena.agiledataquery.domain.app.FunctionCtrl;
import com.digiwin.athena.agiledataquery.domain.application.ApplicationMechanism;
import com.digiwin.athena.agiledataquery.domain.common.BaseEntity;
import com.digiwin.athena.agiledataquery.domain.common.HierarchicalEntity;
import com.digiwin.athena.agiledataquery.domain.definition.FieldDescription;
import com.digiwin.athena.agiledataquery.domain.definition.OpenWindowDefinition;
import com.digiwin.athena.agiledataquery.domain.digitalstaff.DigitalStaff;
import com.digiwin.athena.agiledataquery.domain.task.TaskMonitorRule;
import com.digiwin.athena.agiledataquery.dto.ApplicationRelationByTypeAndCodeDTO;
import com.digiwin.athena.agiledataquery.dto.ApplicationRelationQueryDTO;
import com.digiwin.athena.agiledataquery.dto.QueryApplicationsByCodesDTO;
import com.digiwin.athena.agiledataquery.dto.QueryApplicationsNameByCodeListDTO;
import com.digiwin.athena.agiledataquery.dto.QueryDigitalStaffByCodeDTO;
import com.digiwin.athena.agiledataquery.manager.LicenseKeyManager;
import com.digiwin.athena.agiledataquery.po.AppRelationBatchPo;
import com.digiwin.athena.agiledataquery.po.ApplicationCustomizedConfig;
import com.digiwin.athena.agiledataquery.service.IApplicationService;
import com.digiwin.athena.agiledataquery.service.IMechanismService;
import com.digiwin.athena.agiledataquery.service.ITenantService;
import com.digiwin.athena.agiledataquery.service.inner.DataPickService;
import com.digiwin.athena.agiledataquery.service.inner.KgInnerService;
import com.digiwin.athena.agiledataquery.utils.AthenaUtils;
import com.digiwin.athena.agiledataquery.utils.DWBusinessException;
import com.digiwin.athena.agiledataquery.utils.I18nUtils;
import com.digiwin.athena.agiledataquery.utils.TranslateUtils;
import com.google.common.collect.Lists;
import com.mongodb.bulk.BulkWriteResult;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.BulkOperations;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.util.Pair;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StopWatch;
import org.springframework.util.StringUtils;

@Service
public class ApplicationServiceImpl
implements IApplicationService {
    private static final Logger log = LoggerFactory.getLogger(ApplicationServiceImpl.class);
    @Autowired
    private DataPickService dataPickService;
    @Autowired
    private MongoEntityBaseDAO mongoEntityBaseDAO;
    @Autowired
    private KgService kgService;
    @Autowired
    private LicenseKeyManager licenseKeyManager;
    @Autowired
    private IamService iamService;
    @Autowired
    private KgInnerService kgInnerService;
    @Autowired
    @Qualifier(value="mongoTemplate")
    private MongoTemplate mongoTemplateSystem;
    @Autowired
    private ITenantService tenantService;
    @Autowired
    private IMechanismService iMechanismService;
    @Autowired
    TranslateUtils translateUtils;

    public ApplicationRelation getApplicationByTypeAndCode(String type, String code) {
        Criteria criteria = new Criteria();
        criteria.and("code").is((Object)code).and("type").is((Object)type);
        return (ApplicationRelation)this.dataPickService.findOneByCondition(criteria, ApplicationRelation.class, "applicationRelation");
    }

    public ApplicationRelation getApplicationByTypeAndCode(String type, String code, String lang) throws DWBusinessException {
        ApplicationRelation applicationRelation = this.getApplicationByTypeAndCode(type, code);
        Application application = null;
        try {
            application = this.getApplicationByCode(applicationRelation.getAppCode());
        }
        catch (Exception e) {
            log.warn("\u83b7\u53d6\u5e94\u7528\u5f02\u5e38 for type:{},code:{}", (Object)type, (Object)code);
        }
        if (application != null && application.getLang() != null) {
            Map nameLangMap = (Map)application.getLang().get("name");
            String language = null == nameLangMap.get(lang) ? application.getName() : (String)nameLangMap.get(lang);
            applicationRelation.setAppName(StringUtils.isEmpty((Object)language) ? applicationRelation.getAppName() : language);
        }
        return applicationRelation;
    }

    public List<ApplicationRelation> getApplicationByTypeAndCode(String type, List<String> codeList) throws DWBusinessException {
        return this.getApplicationByTypeAndCode(type, null, codeList);
    }

    public List<ApplicationRelation> getApplicationByTypeAndCode(String type, String subType, List<String> codeList) throws DWBusinessException {
        Criteria criteria = Criteria.where((String)"type").is((Object)type).and("code").in(codeList);
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)subType)) {
            criteria.and("subType").is((Object)subType);
        }
        return this.dataPickService.find(criteria, ApplicationRelation.class, "applicationRelation");
    }

    public Map<String, List<ApplicationRelation>> getApplicationsMapByTypeAndCodes(String type, Set<String> codes, Map<String, Activity> activityMap) {
        HashMap<String, String> keyConditions = new HashMap<String, String>();
        keyConditions.put("type", type);
        if (CollectionUtils.isEmpty(activityMap)) {
            activityMap = new HashMap<String, Activity>();
        }
        Map applicationRelationsMap = this.mongoEntityBaseDAO.find(keyConditions, "code", codes, ApplicationRelation.class, activityMap);
        return applicationRelationsMap;
    }

    public List<ApplicationRelation> getApplicationsByTypeAndCode(String type, String code) {
        return this.getApplicationByTypeAndCode(type, null, Collections.singletonList(code));
    }

    public List<Application> getApplicationsByCodes(List<String> codes) {
        Criteria criteria = Criteria.where((String)"code").in(codes);
        return this.dataPickService.find(criteria, Application.class, "application");
    }

    public Application getApplicationByCode(String code) throws DWBusinessException {
        String tenantId = AthenaUtils.getTenantId();
        return this.getApplicationByCode(code, tenantId);
    }

    public Application getApplicationByCode(String code, String tenantId) throws DWBusinessException {
        Criteria criteria = new Criteria();
        criteria.and("code").is((Object)code);
        return (Application)this.dataPickService.findOneByCondition(criteria, tenantId, Application.class, "application");
    }

    public Object getApplicationFunctionCtrlByBizCode(String code) {
        Application application = this.getApplicationByCode(code);
        if (null == application) {
            throw new DWBusinessException("app not found");
        }
        return application.getFunctionCtrl();
    }

    public Object getApplicationFunctionCtrlByAppCode(String code) {
        FunctionCtrl functionCtrl = new FunctionCtrl();
        functionCtrl.setProjectCardCustomizeFlag(true);
        functionCtrl.setTaskCardCustomizeFlag(true);
        functionCtrl.setTaskCardMergeCustomizeFlag(true);
        return functionCtrl;
    }

    public Object getApplicationRecommendations() {
        return this.kgService.doForwardToKg(new HashMap());
    }

    public Map<String, List<ApplicationRelation>> getApplicationRelationsMapByTypeAndCodesAndLang(String type, Set<String> codes, String lang) {
        Map applicationRelationsMap = this.getApplicationsMapByTypeAndCodes(type, codes, new HashMap());
        HashSet applicationsCodes = new HashSet();
        applicationRelationsMap.values().forEach(item -> {
            if (!CollectionUtils.isEmpty((Collection)item)) {
                item.forEach(itemI -> applicationsCodes.add(itemI.getAppCode()));
            }
        });
        ArrayList codeList = new ArrayList(applicationsCodes);
        List applications = this.getApplicationsByCodes(codeList);
        Map applicationMap = applications.stream().collect(Collectors.toMap(BaseEntity::getCode, Function.identity()));
        applicationRelationsMap.forEach((k, v) -> v.forEach(applicationRelation -> {
            Application application = (Application)applicationMap.get(applicationRelation.getAppCode());
            if (application != null && application.getLang() != null) {
                Map nameLangMap = (Map)application.getLang().get("name");
                String language = null == nameLangMap.get(lang) ? application.getName() : (String)nameLangMap.get(lang);
                applicationRelation.setAppName(StringUtils.isEmpty((Object)language) ? applicationRelation.getAppName() : language);
            }
        }));
        return applicationRelationsMap;
    }

    public List<ApplicationRelation> getApplicationRelationsByTypeAndCodeAndLang(String type, String code, String lang) {
        List applicationRelations = this.getApplicationsByTypeAndCode(type, code);
        if (CollectionUtils.isEmpty((Collection)applicationRelations)) {
            return new LinkedList<ApplicationRelation>();
        }
        applicationRelations.forEach(applicationRelation -> {
            Application application = null;
            try {
                application = this.getApplicationByCode(applicationRelation.getAppCode());
            }
            catch (DWBusinessException e) {
                log.warn("\u83b7\u53d6\u5e94\u7528\u5f02\u5e38", (Throwable)e);
            }
            if (application != null && application.getLang() != null) {
                Map nameLangMap = (Map)application.getLang().get("name");
                String language = null == nameLangMap.get(lang) ? application.getName() : (String)nameLangMap.get(lang);
                applicationRelation.setAppName(StringUtils.isEmpty((Object)language) ? applicationRelation.getAppName() : language);
            }
        });
        return applicationRelations;
    }

    public ApplicationRelation getApplicationByTypeAndCodeAndLang(String type, String code, String lang) {
        ApplicationRelation applicationRelation = this.getApplicationByTypeAndCode(type, code);
        if (null != applicationRelation) {
            Application application = this.getApplicationByCode(applicationRelation.getAppCode());
            if (application == null || application.getLang() == null) {
                return applicationRelation;
            }
            Map nameLangMap = (Map)application.getLang().get("name");
            String language = null == nameLangMap.get(lang) ? application.getName() : (String)nameLangMap.get(lang);
            applicationRelation.setAppName(StringUtils.isEmpty((Object)language) ? applicationRelation.getAppName() : language);
        }
        return applicationRelation;
    }

    public Map<String, ApplicationRelation> getApplicationRelationsMapByApplicationAndLang(List<String> codes, String localeStr) {
        HashMap<String, ApplicationRelation> applicationRelations = new HashMap<String, ApplicationRelation>();
        List applications = this.getApplicationsByCodes(codes);
        for (Application item : applications) {
            if (!codes.contains(item.getCode()) || item.getLang() == null) {
                throw new DWBusinessException(I18nUtils.getValue((String)"knowledgegraph.appNotFound") + item.getCode());
            }
            Map nameLangMap = (Map)item.getLang().get("name");
            String language = null == nameLangMap.get(localeStr) ? item.getName() : (String)nameLangMap.get(localeStr);
            ApplicationRelation applicationRelation = new ApplicationRelation();
            applicationRelation.setAppName(StringUtils.isEmpty((Object)language) ? applicationRelation.getAppName() : language);
            applicationRelation.setAppCode(item.getCode());
            applicationRelations.put(applicationRelation.getCode(), applicationRelation);
        }
        return applicationRelations;
    }

    public ApplicationRelation getApplicationRelationByApplicationAndLang(String code, String localeStr) {
        ApplicationRelation applicationRelation = new ApplicationRelation();
        Application application = this.getApplicationByCode(code);
        if (application == null || application.getLang() == null) {
            throw new DWBusinessException(I18nUtils.getValue((String)"knowledgegraph.appNotFound") + code);
        }
        Map nameLangMap = (Map)application.getLang().get("name");
        String language = null == nameLangMap.get(localeStr) ? application.getName() : (String)nameLangMap.get(localeStr);
        applicationRelation.setAppName(StringUtils.isEmpty((Object)language) ? applicationRelation.getAppName() : language);
        applicationRelation.setAppCode(code);
        return applicationRelation;
    }

    public Object getLicenseKey(String tenantId) throws Exception {
        return this.licenseKeyManager.getLicenseKey(tenantId);
    }

    public Object getLicenseKey(String tenantId, String requestFrom, String key, long timestamp) throws Exception {
        return this.licenseKeyManager.getLicenseKey(tenantId, requestFrom, key, timestamp);
    }

    public Object postSetLicenseKey() {
        String athenaLicenceKey = this.iamService.getAthenaLicenceKey();
        String tenantId = AthenaUtils.getTenantId();
        this.licenseKeyManager.setLicenseKey(tenantId, athenaLicenceKey);
        return "success";
    }

    public Object postSetLicenseKey(String tenantId) throws Exception {
        String athenaLicenceKey = this.iamService.getAthenaLicenceKey(tenantId);
        log.info("SetLicenseKeyTenantId:{},athenaLicenceKey:{}", (Object)tenantId, (Object)athenaLicenceKey);
        this.licenseKeyManager.setLicenseKey(tenantId, athenaLicenceKey);
        return "success";
    }

    public Object get(String code) {
        HashMap<String, String> req = new HashMap<String, String>();
        req.put("code", code);
        return this.kgService.doForwardToKg(req);
    }

    public Map<String, Map<String, OpenWindowDefinition>> postOpenWinInfo(Map<String, Map<String, String>> openWin) throws DWBusinessException {
        HashMap<String, Map<String, OpenWindowDefinition>> result = new HashMap<String, Map<String, OpenWindowDefinition>>();
        for (Map.Entry<String, Map<String, String>> entry0 : openWin.entrySet()) {
            HashMap<String, OpenWindowDefinition> openWindowInfo = new HashMap<String, OpenWindowDefinition>();
            if (entry0.getValue() != null) {
                for (Map.Entry<String, String> entry1 : entry0.getValue().entrySet()) {
                    OpenWindowDefinition openWindowDefinition = (OpenWindowDefinition)this.dataPickService.findOneByCondition(Criteria.where((String)"key").is((Object)entry1.getValue()), OpenWindowDefinition.class, "openWindowDefinition");
                    openWindowInfo.put(entry1.getKey(), openWindowDefinition);
                }
            }
            result.put(entry0.getKey(), openWindowInfo);
        }
        return result;
    }

    public List<String> getVariableCode(String appCode) throws DWBusinessException {
        ArrayList<String> re = new ArrayList<String>();
        List appCodes = this.tenantService.getAppCodes(AthenaUtils.getTenantId());
        if (!appCodes.contains(appCode)) {
            return re;
        }
        List relations = this.dataPickService.applicationRelations(appCode, "variable", null, null, null);
        relations.forEach(r -> re.add(r.getCode()));
        return re;
    }

    public List<String> getMonitorRuleCode(String appCode) throws DWBusinessException {
        return this.getMonitorRuleCode(appCode, null);
    }

    public List<String> getMonitorRuleCode(String appCode, String tenantId) throws DWBusinessException {
        tenantId = org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)tenantId) ? AthenaUtils.getTenantId() : tenantId;
        ArrayList<String> codes = new ArrayList<String>();
        List appCodes = this.tenantService.getAppCodes(tenantId);
        if (!appCodes.contains(appCode)) {
            return codes;
        }
        List relations = this.dataPickService.applicationRelations(appCode, "monitorRule", null, null, null);
        relations.forEach(r -> codes.add(r.getCode()));
        Application application = this.getApplicationByCode(appCode, tenantId);
        if (application == null || application.getParamDescription() == null) {
            return codes;
        }
        for (FieldDescription fieldDescription : application.getParamDescription()) {
            if (!org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)"period", (CharSequence)fieldDescription.getCategory()) || !org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)fieldDescription.getExtendData()) || codes.contains(fieldDescription.getExtendData())) continue;
            codes.add(fieldDescription.getExtendData());
        }
        return codes;
    }

    public Object getList(Set<String> applicationCodeList) {
        HashMap<String, Set<String>> req = new HashMap<String, Set<String>>();
        req.put("applicationCodeList", applicationCodeList);
        return this.kgService.doForwardToKg(req);
    }

    public Object getByNameAndTags(String applicationName, List<String> tags) {
        String tenantId = AthenaUtils.getTenantId();
        String tenantVersion = this.kgInnerService.getTenantVersion(tenantId);
        Query query = new Query();
        Criteria criteria = null;
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)applicationName)) {
            criteria = Criteria.where((String)"name").regex(".*?\\" + applicationName + ".*");
        }
        if (!CollectionUtils.isEmpty(tags)) {
            criteria = criteria != null ? criteria.and("tags.key").in(tags) : Criteria.where((String)"tags.key").in(tags);
        }
        if (criteria != null) {
            criteria = criteria.and("version").is((Object)tenantVersion);
            query.addCriteria((CriteriaDefinition)criteria);
        } else {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"version").is((Object)tenantVersion));
        }
        query.with(Sort.by((Sort.Order[])new Sort.Order[]{Sort.Order.desc((String)"editDate")}));
        List applications = this.mongoTemplateSystem.find(query, Application.class);
        return this.dataPickService.excludeWithSameCode(applications);
    }

    public Object getApplicationMechanismByApplicationCode(String applicationCode) {
        Query query = new Query();
        Criteria criteria = Criteria.where((String)"applicationCode").is((Object)applicationCode);
        query.addCriteria((CriteriaDefinition)criteria);
        List applicationMechanisms = this.mongoTemplateSystem.find(query, ApplicationMechanism.class);
        return applicationMechanisms;
    }

    public Object postApplicationMechanismByApplicationCodes(List<String> applicationCodes) {
        List appCodes = this.tenantService.getAppCodes(AthenaUtils.getTenantId());
        ArrayList<String> finalAppCodes = new ArrayList<String>(applicationCodes);
        finalAppCodes.retainAll(appCodes);
        StopWatch relationTime = new StopWatch();
        relationTime.start();
        List relations = this.dataPickService.applicationRelations(finalAppCodes, "mechanism", null, null, null);
        relationTime.stop();
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)relations)) {
            return null;
        }
        List codeList = relations.stream().map(BaseEntity::getCode).collect(Collectors.toList());
        return this.iMechanismService.postQueryMechanismByCode(codeList, null, Boolean.valueOf(false));
    }

    public Object getApplicationMechanismByMechanismCode(String mechanismCode) {
        Query query = new Query();
        Criteria criteria = Criteria.where((String)"mechanismCode").is((Object)mechanismCode);
        query.addCriteria((CriteriaDefinition)criteria);
        List applicationMechanisms = this.mongoTemplateSystem.find(query, ApplicationMechanism.class);
        return applicationMechanisms;
    }

    public Application getApplicationInfo(String code) {
        Application application = (Application)this.dataPickService.findOneByCondition(Criteria.where((String)"code").is((Object)code), Application.class, "application");
        if (application != null) {
            String localeStr = AthenaUtils.getCurrentLocale();
            if (application.getLang() != null && !application.getLang().isEmpty()) {
                for (Map.Entry i : application.getLang().entrySet()) {
                    Map lang = (Map)i.getValue();
                    if (lang == null || lang.isEmpty() || !lang.containsKey(localeStr)) continue;
                    try {
                        Field field = Application.class.getDeclaredField((String)i.getKey());
                        field.setAccessible(true);
                        field.set(application, lang.get(localeStr));
                    }
                    catch (NoSuchFieldException field) {
                    }
                    catch (IllegalAccessException field) {
                    }
                    catch (Exception ex) {
                        throw ex;
                    }
                }
            }
        }
        return application;
    }

    public List<String> getTaskCode(String appCode) {
        ArrayList<String> codes = new ArrayList<String>();
        List appCodes = this.tenantService.getAppCodes(AthenaUtils.getTenantId());
        if (!appCodes.contains(appCode)) {
            return codes;
        }
        List relations = this.dataPickService.applicationRelations(appCode, "task", null, null, null);
        relations.forEach(r -> codes.add(r.getCode()));
        return codes;
    }

    public List<String> getMechanismCode(String appCode) {
        ArrayList<String> codes = new ArrayList<String>();
        List appCodes = this.tenantService.getAppCodes(AthenaUtils.getTenantId());
        if (!appCodes.contains(appCode)) {
            return codes;
        }
        List relations = this.dataPickService.applicationRelations(appCode, "mechanism", null, null, null);
        relations.forEach(r -> codes.add(r.getCode()));
        return codes;
    }

    public List<ApplicationRelation> postApplicationRelationsByCodesAndType(ApplicationRelationQueryDTO applicationRelationQueryDTO) {
        String tenantId = AthenaUtils.getTenantId();
        String tenantVersion = this.kgInnerService.getTenantVersion(tenantId);
        List appCodes = this.tenantService.getAppCodes(AthenaUtils.getTenantId());
        if (appCodes.isEmpty()) {
            return new ArrayList<ApplicationRelation>();
        }
        Criteria criteria = Criteria.where((String)"type").is((Object)applicationRelationQueryDTO.getType()).and("code").in((Collection)applicationRelationQueryDTO.getCodes()).and("version").is((Object)tenantVersion);
        return this.dataPickService.find(criteria, ApplicationRelation.class, "applicationRelation");
    }

    public List<ApplicationRelation> getAppCodeByTaskCode(String code) {
        List appCodes = this.tenantService.getAppCodes(AthenaUtils.getTenantId());
        if (appCodes.isEmpty()) {
            return new ArrayList<ApplicationRelation>();
        }
        Criteria criteria = Criteria.where((String)"type").is((Object)"task").and("code").is((Object)code).and("appCode").in((Collection)appCodes);
        List relations = this.dataPickService.find(criteria, ApplicationRelation.class, "applicationRelation");
        this.proccessAppNameLanguage(relations);
        return relations;
    }

    public List<ApplicationRelation> getAppCodeByMechanismCode(String code) {
        List appCodes = this.tenantService.getAppCodes(AthenaUtils.getTenantId());
        if (appCodes.isEmpty()) {
            return new ArrayList<ApplicationRelation>();
        }
        Criteria criteria = Criteria.where((String)"type").is((Object)"mechanism").and("code").is((Object)code).and("appCode").in((Collection)appCodes);
        List relations = this.dataPickService.find(criteria, ApplicationRelation.class, "applicationRelation");
        this.proccessAppNameLanguage(relations);
        return relations;
    }

    public List<ApplicationRelation> getAppCodeByMonitorRuleCode(String code) {
        String tenantId = AthenaUtils.getTenantId();
        List appCodes = this.tenantService.getAppCodes(AthenaUtils.getTenantId());
        if (appCodes.isEmpty()) {
            return new ArrayList<ApplicationRelation>();
        }
        Criteria criteria1 = Criteria.where((String)"type").is((Object)"monitorRule").and("code").is((Object)code).and("appCode").in((Collection)appCodes);
        List relations = this.dataPickService.find(criteria1, ApplicationRelation.class, "applicationRelation");
        if (CollectionUtils.isEmpty((Collection)relations)) {
            Criteria criteria = Criteria.where((String)"paramDescription.extendData").is((Object)code);
            List applications = this.dataPickService.find(criteria, Application.class, "application");
            for (Application application : applications) {
                ApplicationRelation applicationRelation = new ApplicationRelation();
                applicationRelation.setAppCode(application.getCode());
                applicationRelation.setAppName(application.getName());
                applicationRelation.setCode(code);
                applicationRelation.setType("monitorRule");
                relations.add(applicationRelation);
            }
        }
        this.proccessAppNameLanguage(relations);
        return relations;
    }

    public List<ApplicationRelation> getApplicationRelation(List<String> codes, String tenantVersion) {
        Criteria criteria = Criteria.where((String)"code").in(codes);
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)tenantVersion)) {
            criteria.and("version").is((Object)tenantVersion);
        }
        return this.dataPickService.find(criteria, ApplicationRelation.class, "applicationRelation");
    }

    public List<ApplicationRelation> getApplicationRelation(List<String> appCodes, List<String> codes, String type, String subType) throws DWBusinessException {
        Criteria criteria = Criteria.where((String)"code").in(codes).and("appCode").in(appCodes);
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)type)) {
            criteria.and("type").is((Object)type);
        }
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)subType)) {
            criteria.and("subType").is((Object)subType);
        }
        return this.dataPickService.find(criteria, ApplicationRelation.class, "applicationRelation");
    }

    public List<ApplicationRelation> postApplicationRelation(List<String> appCodes) {
        return this.dataPickService.applicationRelations(appCodes, null, null, null, null);
    }

    public List<String> getFlowCode(String appCode) {
        ArrayList<String> codes = new ArrayList<String>();
        List relations = this.dataPickService.applicationRelations(appCode, "flow", null, null, null);
        relations.forEach(r -> codes.add(r.getCode()));
        return codes;
    }

    public List<ApplicationRelation> getAppCodeByFlowCode(String code) {
        Criteria criteria = Criteria.where((String)"type").is((Object)"flow").and("code").is((Object)code);
        return this.dataPickService.find(criteria, ApplicationRelation.class, "applicationRelation");
    }

    public List<String> getNotCommonAppCode() {
        Query query = new Query();
        query.fields().include("code");
        List app = this.mongoTemplateSystem.find(query, Application.class);
        List<String> collect = app.stream().filter(item -> null == item.getCommonApp() || false == item.getCommonApp()).map(BaseEntity::getCode).distinct().collect(Collectors.toList());
        return collect;
    }

    public List<String> getMonitorRulesRelatedToTask(String appCode) throws DWBusinessException {
        String tenantId = AthenaUtils.getTenantId();
        String tenantVersion = this.kgInnerService.getTenantVersion(tenantId);
        ArrayList<String> result = new ArrayList<String>();
        List taskCodList = this.getTaskCode(appCode);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)taskCodList)) {
            for (String taskCode : taskCodList) {
                Query query = new Query();
                Criteria criteria = Criteria.where((String)"taskCode").is((Object)taskCode).and("version").is((Object)tenantVersion);
                query.addCriteria((CriteriaDefinition)criteria);
                List taskMechanism = this.mongoTemplateSystem.find(query, TaskMonitorRule.class, "taskMonitorRule");
                if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)taskMechanism)) continue;
                List collect = taskMechanism.stream().map(TaskMonitorRule::getMonitorRuleCode).collect(Collectors.toList());
                result.addAll(collect);
            }
        }
        return result;
    }

    public Map<String, List> postQueryDigitalStaffByCode(QueryDigitalStaffByCodeDTO dto) {
        Set codeList = dto.getCodeList();
        Set enhanceCodeList = dto.getEnhanceCodeList();
        String tenantId = AthenaUtils.getTenantId();
        String tenantVersion = this.kgInnerService.getTenantVersion(tenantId);
        HashMap<String, List> re = new HashMap<String, List>();
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)codeList)) {
            return re;
        }
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)enhanceCodeList)) {
            return re;
        }
        Criteria criteria = Criteria.where((String)"code").in((Collection)enhanceCodeList).and("extendType").is((Object)"digitalStaff");
        List enhanceApp = this.dataPickService.find(criteria, Application.class, "application");
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)enhanceApp)) {
            return re;
        }
        HashMap<String, String> enhanceStaff = new HashMap<String, String>();
        HashMap<String, String> enhanceName = new HashMap<String, String>();
        ArrayList<String> staffCodeList = new ArrayList<String>();
        for (Application i : enhanceApp) {
            enhanceStaff.put(i.getCode(), i.getExtendData());
            enhanceName.put(i.getCode(), i.getName());
            if (staffCodeList.contains(i.getExtendData())) continue;
            staffCodeList.add(i.getExtendData());
        }
        Query query = new Query();
        query.fields().include("code");
        query.fields().include("name");
        criteria = Criteria.where((String)"code").in(staffCodeList).and("version").is((Object)tenantVersion);
        query.addCriteria((CriteriaDefinition)criteria);
        List digitalStaffs = this.mongoTemplateSystem.find(query, DigitalStaff.class);
        HashMap<String, String> staffName = new HashMap<String, String>();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)digitalStaffs)) {
            for (DigitalStaff digitalStaff : digitalStaffs) {
                staffName.put(digitalStaff.getCode(), digitalStaff.getName());
            }
        }
        for (Map.Entry entry : enhanceStaff.entrySet()) {
            enhanceStaff.put((String)entry.getKey(), (String)staffName.get(entry.getValue()));
        }
        List relations = this.dataPickService.applicationRelations(new ArrayList(codeList), "enhance", null, null, null);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)relations)) {
            for (ApplicationRelation i : relations) {
                if (!enhanceCodeList.contains(i.getCode())) continue;
                if (re.containsKey(i.getAppCode())) {
                    HashMap tmp = new HashMap();
                    tmp.put("staff", enhanceStaff.get(i.getCode()));
                    tmp.put("job", enhanceName.get(i.getCode()));
                    ((List)re.get(i.getAppCode())).add(tmp);
                    continue;
                }
                ArrayList lst = new ArrayList();
                HashMap tmp = new HashMap();
                tmp.put("staff", enhanceStaff.get(i.getCode()));
                tmp.put("job", enhanceName.get(i.getCode()));
                lst.add(tmp);
                re.put(i.getAppCode(), lst);
            }
        }
        return re;
    }

    public List<ApplicationRelation> getAppCodeByTypeAndCode(String type, String code) {
        List applicationRelationList = this.getApplicationByTypeAndCode(type, null, Collections.singletonList(code));
        if (CollectionUtils.isEmpty((Collection)applicationRelationList)) {
            return applicationRelationList;
        }
        List all = this.mongoTemplateSystem.findAll(Application.class);
        Map collect = this.dataPickService.excludeWithSameCode(all).stream().collect(Collectors.toMap(BaseEntity::getCode, Function.identity(), (a, b) -> a));
        applicationRelationList.forEach(e -> {
            Application application = (Application)collect.get(e.getAppCode());
            if (application != null && application.getLang() != null && application.getLang().containsKey("name")) {
                e.setAppName(application.getName());
                HashMap lang = e.getLang();
                if (lang == null) {
                    lang = new HashMap();
                    e.setLang(lang);
                }
                lang.put("appName", application.getLang().get("name"));
            }
        });
        return applicationRelationList;
    }

    public List<ApplicationRelation> getParadigmByTypeAndAppCode(String type, String appCode) {
        List applicationRelationList = this.dataPickService.applicationRelations(appCode, type, null, null, null);
        return CollectionUtils.isEmpty((Collection)applicationRelationList) ? new ArrayList() : applicationRelationList;
    }

    public String getAppCodeByApplication(String application) {
        List applicationRelationList = this.dataPickService.applicationRelations(Collections.singletonList(application), null, null, null, null);
        return CollectionUtils.isEmpty((Collection)applicationRelationList) ? null : ((ApplicationRelation)applicationRelationList.get(0)).getAppCode();
    }

    public List<ApplicationRelation> getApplicationRelationByTypeAndAppCodeAndVersion(String type, String appCode, String version) {
        List applicationRelationList = this.dataPickService.applicationRelations(appCode, type, null, null, null);
        return org.apache.commons.collections.CollectionUtils.isEmpty((Collection)applicationRelationList) ? new ArrayList() : applicationRelationList;
    }

    public List<ApplicationRelation> getApplicationRelationByTypeAndAppCode(String type, String appCode) {
        List applicationRelationList = this.dataPickService.applicationRelations(appCode, type, null, null, null);
        return CollectionUtils.isEmpty((Collection)applicationRelationList) ? new ArrayList() : applicationRelationList;
    }

    public List<ApplicationRelation> getApplicationRelationByTypeAndAppCode(String type, List<String> appCodes) {
        List applicationRelationList = this.dataPickService.applicationRelations(appCodes, type, null, null, null);
        return CollectionUtils.isEmpty((Collection)applicationRelationList) ? new ArrayList() : applicationRelationList;
    }

    public List<ApplicationRelation> getApplicationRelationByTypeAndAppCode(String tenantId, String type, String appCode) {
        List applicationRelationList = this.dataPickService.applicationRelations(appCode, type, null, tenantId, null);
        return CollectionUtils.isEmpty((Collection)applicationRelationList) ? new ArrayList() : applicationRelationList;
    }

    public Object postAppRelationUpdate(AppRelationBatchPo request) {
        if (Boolean.TRUE.equals(request.getCleanDuplicate())) {
            HashMap<String, Serializable> map = new HashMap<String, Serializable>();
            List applicationRelations = this.mongoTemplateSystem.findAll(ApplicationRelation.class);
            applicationRelations = this.dataPickService.filterApplicationRelations(applicationRelations);
            HashSet cleaned = new HashSet();
            ArrayList newList = new ArrayList();
            applicationRelations.forEach(app -> {
                if (newList.contains(app)) {
                    cleaned.add(app.getCode());
                    this.mongoTemplateSystem.remove(app);
                } else {
                    newList.add(app);
                }
            });
            map.put("codes", cleaned);
            map.put("count", Integer.valueOf(cleaned.size()));
            return map;
        }
        List relations = request.getList();
        if (null == relations) {
            return null;
        }
        ArrayList updateList = new ArrayList();
        relations.forEach(data -> {
            Query query = new Query((CriteriaDefinition)new Criteria("code").is((Object)data.getCode()).and("type").is((Object)data.getType()).and("appCode").is((Object)data.getAppCode()));
            Update update = new Update();
            update.set("code", (Object)data.getCode());
            update.set("type", (Object)data.getType());
            update.set("application", (Object)data.getApplication());
            update.set("appName", (Object)data.getAppName());
            update.set("appCode", (Object)data.getAppCode());
            update.set("source", (Object)data.getSource());
            update.set("version", (Object)data.getVersion());
            update.set("name", (Object)data.getName());
            update.set("tenantId", (Object)data.getTenantId());
            update.set("sourceLevel", (Object)data.getSourceLevel());
            Pair updatePair = Pair.of((Object)query, (Object)update);
            updateList.add(updatePair);
        });
        BulkWriteResult result = this.mongoTemplateSystem.bulkOps(BulkOperations.BulkMode.UNORDERED, ApplicationRelation.class).upsert(updateList).execute();
        int count = result.getDeletedCount() + result.getModifiedCount();
        return count;
    }

    public List<ApplicationRelation> getApplicationRelationByType(String type) {
        Criteria criteria = Criteria.where((String)"type").is((Object)type);
        List applicationRelationList = this.dataPickService.find(criteria, ApplicationRelation.class, "applicationRelation");
        return org.apache.commons.collections.CollectionUtils.isEmpty((Collection)applicationRelationList) ? new ArrayList() : this.dataPickService.filterApplicationRelations(applicationRelationList);
    }

    public List<ApplicationCustomizedConfig> postConfigByApplicationCustomized() {
        String version = this.kgInnerService.currentTenantVersion();
        Query query = new Query();
        Criteria criteria = Criteria.where((String)"version").is((Object)version);
        query.addCriteria((CriteriaDefinition)criteria);
        List configList = this.mongoTemplateSystem.find(query, ApplicationCustomizedConfig.class);
        return CollectionUtils.isEmpty((Collection)configList) ? Collections.emptyList() : this.dataPickService.excludeWithSameCode(configList);
    }

    public List<ApplicationCustomizedConfig> postConfigByGroupApplicationCustomized() {
        String version = this.kgInnerService.currentTenantVersion();
        Query query = new Query();
        Criteria criteria = Criteria.where((String)"version").is((Object)version);
        query.addCriteria((CriteriaDefinition)criteria);
        List configList = this.mongoTemplateSystem.find(query, ApplicationCustomizedConfig.class);
        configList = this.dataPickService.excludeWithSameCode(configList);
        Map nameTenantIdAppIdListMap = configList.stream().filter(o -> org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)o.getName()) && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)o.getTenantId())).collect(Collectors.groupingBy(BaseEntity::getName, Collectors.groupingBy(HierarchicalEntity::getTenantId, Collectors.mapping(ApplicationCustomizedConfig::getAppId, Collectors.toList()))));
        LinkedHashMap nameMap = configList.stream().filter(o -> org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)o.getName()) && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)o.getTenantId())).collect(Collectors.toMap(o -> o.getName() + o.getTenantId(), Function.identity(), (existingValue, newValue) -> existingValue, LinkedHashMap::new));
        nameMap.forEach((name, config) -> config.setRelationAppIds((List)nameTenantIdAppIdListMap.getOrDefault(config.getName(), Collections.emptyMap()).get(config.getTenantId())));
        return Lists.newArrayList(nameMap.values());
    }

    public List<Application> postAllApplications() {
        Query query = new Query();
        Criteria criteria = Criteria.where((String)"version").is((Object)"2.0");
        query.addCriteria((CriteriaDefinition)criteria);
        query.fields().include("code");
        query.fields().include("name");
        query.fields().include("description");
        query.fields().include("lang");
        List applicationList = this.mongoTemplateSystem.find(query, Application.class);
        return CollectionUtils.isEmpty((Collection)applicationList) ? Collections.emptyList() : this.dataPickService.excludeWithSameCode(applicationList);
    }

    public Object postApplicationRelationByTypeAndCode(ApplicationRelationByTypeAndCodeDTO dto) {
        String code = dto.getCode();
        String tenantId = dto.getTenantId();
        String type = dto.getType();
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("code", code);
        data.put("appCode", "");
        HashMap<String, String> convertType = new HashMap<String, String>();
        convertType.put("project", "task");
        convertType.put("task", "activity");
        convertType.put("monitorRule", "monitorRule");
        String codeType = (String)convertType.get(type);
        try {
            if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)codeType) && (Objects.equals("action", type) || Objects.equals("monitorRule", type))) {
                Map map = (Map)JSON.parseObject((String)JSON.toJSONString((Object)dto), Map.class);
                return this.kgService.doForwardToKg(map);
            }
            Set<String> codes = Collections.singleton(code);
            HashMap<String, String> profile = new HashMap<String, String>();
            profile.put("tenantId", tenantId);
            DWServiceContext.getContext().setProfile(profile);
            profile.put("tenantId", tenantId);
            Map relationsMap = this.getApplicationRelationsMapByTypeAndCodesAndLang(codeType, codes, AthenaUtils.getCurrentLocale());
            Optional relations = relationsMap.entrySet().stream().map(Map.Entry::getValue).filter(list -> !CollectionUtils.isEmpty((Collection)list)).flatMap(Collection::stream).findFirst();
            if (relations.isPresent()) {
                data.put("appCode", ((ApplicationRelation)relations.get()).getAppCode());
            }
        }
        catch (Exception e) {
            log.error("postApplicationRelationByTypeAndCode error:{}", (Throwable)e);
        }
        return data;
    }

    public Object postApplicationRelationByDDSM(AppRelationBatchPo request) {
        String version = this.kgInnerService.currentTenantVersion();
        List applicationRelations = request.getList();
        String applicationRelationStr = this.translateUtils.translateContent((Object)applicationRelations);
        if (!CollectionUtils.isEmpty((Collection)(applicationRelations = JSONArray.parseArray((String)applicationRelationStr, ApplicationRelation.class)))) {
            for (ApplicationRelation applicationRelation : applicationRelations) {
                Query query = new Query();
                Criteria criteria = Criteria.where((String)"type").is((Object)applicationRelation.getType()).and("code").is((Object)applicationRelation.getCode()).and("appCode").is((Object)applicationRelation.getAppCode()).and("version").is((Object)version);
                query.addCriteria((CriteriaDefinition)criteria);
                List applicationRelationList = this.mongoTemplateSystem.find(query, ApplicationRelation.class);
                if (!CollectionUtils.isEmpty((Collection)applicationRelationList)) {
                    this.mongoTemplateSystem.remove(query, ApplicationRelation.class);
                }
                this.mongoTemplateSystem.save((Object)applicationRelation);
            }
        }
        return "success";
    }

    public List<Map<String, String>> postQueryApplicationsNameByCodeList(QueryApplicationsNameByCodeListDTO request) {
        Criteria criteria = new Criteria();
        criteria.and("code").in((Collection)request.getCodes()).and("appType").is((Object)request.getAppType());
        List applications = this.mongoTemplateSystem.find(new Query((CriteriaDefinition)criteria), Application.class);
        ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>();
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)applications)) {
            return result;
        }
        applications.forEach(app -> {
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("code", app.getCode());
            data.put("name", app.getName());
            data.put("version", app.getVersion());
            result.add(data);
        });
        return result;
    }

    public Application getAppByMechanismCode(String mechanismCode) {
        String tenantId = AthenaUtils.getTenantId();
        String tenantVersion = this.kgInnerService.getTenantVersion(tenantId);
        List appCodes = this.tenantService.getAppCodes(tenantId);
        if (appCodes.isEmpty()) {
            throw new DWBusinessException(String.format("authorizations Application is empty, mechanismCode: %s, tenantId: %s", mechanismCode, tenantId));
        }
        ApplicationRelation relation = (ApplicationRelation)this.dataPickService.findOneByCondition(Criteria.where((String)"type").is((Object)"mechanism").and("code").is((Object)mechanismCode).and("appCode").in((Collection)appCodes).and("version").is((Object)tenantVersion), ApplicationRelation.class, "applicationRelation");
        if (relation == null) {
            throw new DWBusinessException("applicationRelation is empty, mechanismCode: " + mechanismCode);
        }
        Criteria criteria = Criteria.where((String)"code").is((Object)relation.getAppCode()).and("version").is((Object)tenantVersion);
        Application application = (Application)this.dataPickService.findOneByCondition(criteria, Application.class, "application");
        if (application == null) {
            throw new DWBusinessException("application is empty, code: " + relation.getAppCode());
        }
        return application;
    }

    public Application getAppByActivityId(String activityId) {
        ApplicationRelation relation = (ApplicationRelation)this.dataPickService.findOneByCondition(Criteria.where((String)"code").is((Object)activityId), ApplicationRelation.class, "applicationRelation");
        if (relation == null) {
            throw new DWBusinessException("applicationRelation is empty, activityId: " + activityId);
        }
        Criteria criteria = Criteria.where((String)"code").is((Object)relation.getAppCode());
        Application application = (Application)this.dataPickService.findOneByCondition(criteria, Application.class, "application");
        if (application == null) {
            throw new DWBusinessException("application is empty, code: " + relation.getAppCode());
        }
        return application;
    }

    public Object postQueryApplicationsByCodes(QueryApplicationsByCodesDTO request) {
        String tenantVersion = this.kgInnerService.currentTenantVersion();
        List applications = this.mongoTemplateSystem.find(Query.query((CriteriaDefinition)Criteria.where((String)"version").is((Object)tenantVersion).and("code").in((Collection)request.getCodes())), Map.class, "application");
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)applications)) {
            return Collections.emptyMap();
        }
        return applications.stream().collect(Collectors.toMap(app -> (String)app.get("code"), app -> app));
    }

    private void proccessAppNameLanguage(List<ApplicationRelation> relations) throws DWBusinessException {
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(relations)) {
            for (ApplicationRelation i : relations) {
                Application app = this.getApplicationInfo(i.getAppCode());
                if (app == null) continue;
                i.setAppName(app.getName());
                Map appLang = app.getLang();
                if (appLang == null) continue;
                if (i.getLang() != null) {
                    i.getLang().put("appName", appLang.get("name"));
                    continue;
                }
                HashMap lang = new HashMap();
                lang.put("appName", appLang.get("name"));
                i.setLang(lang);
            }
        }
    }
}

