/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.agiledataquery.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.digiwin.athena.agiledataquery.clients.KgService;
import com.digiwin.athena.agiledataquery.dto.ReportSceneDTOs;
import com.digiwin.athena.agiledataquery.model.dataCollect.DataCollectConfig;
import com.digiwin.athena.agiledataquery.model.dataCollect.DataCollectQuestions;
import com.digiwin.athena.agiledataquery.model.dataCollect.QueryCollectDTO;
import com.digiwin.athena.agiledataquery.model.dataCollect.QueryConfigDTO;
import com.digiwin.athena.agiledataquery.model.dataCollectGroup.DataCollectGroupConfig;
import com.digiwin.athena.agiledataquery.service.IDataCollectGroupService;
import com.digiwin.athena.agiledataquery.service.IDataCollectService;
import com.digiwin.athena.agiledataquery.service.ISceneService;
import com.digiwin.athena.agiledataquery.service.inner.KgInnerService;
import com.digiwin.athena.agiledataquery.utils.AthenaUtils;
import com.digiwin.athena.agiledataquery.utils.DWBusinessException;
import com.digiwin.athena.agiledataquery.utils.JsonUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.core.query.UpdateDefinition;
import org.springframework.http.HttpMethod;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class DataCollectServiceImpl
implements IDataCollectService {
    private static final Logger log = LoggerFactory.getLogger(DataCollectServiceImpl.class);
    @Autowired
    @Qualifier(value="mongoTemplateTenant")
    MongoTemplate mongoTemplateUser;
    @Autowired
    ISceneService sceneService;
    @Autowired
    KgInnerService kgInnerService;
    @Autowired
    IDataCollectGroupService dataCollectGroupService;
    @Autowired
    KgService kgService;
    public static final String FAIL_MSG = "fail";
    public static final String SUCCESS_MSG = "success";
    private static final int MAX_SAVED_QUESTIONS = 8;

    public String postAddDataCollectConfig(DataCollectConfig config) throws Exception {
        if (StringUtils.isEmpty((CharSequence)config.getTenantId()) || StringUtils.isEmpty((CharSequence)config.getUserId()) || CollectionUtils.isEmpty((Collection)config.getDataCollectQuestions()) || Objects.isNull(config.getDataCollectQuestions().get(0))) {
            return FAIL_MSG;
        }
        String tenantVersion = this.kgInnerService.currentTenantVersion();
        DataCollectQuestions collectQuestion = (DataCollectQuestions)config.getDataCollectQuestions().get(0);
        List metricIdList = CollectionUtils.isEmpty((Collection)collectQuestion.getMetricIdList()) ? new ArrayList() : collectQuestion.getMetricIdList();
        metricIdList.addAll(CollectionUtils.isEmpty((Collection)collectQuestion.getDatasetIdList()) ? new ArrayList() : collectQuestion.getDatasetIdList());
        List sceneCodes = CollectionUtils.isEmpty(metricIdList) ? Collections.singletonList(collectQuestion.getSceneCode()) : metricIdList;
        HashMap params = new HashMap();
        params.put("code", sceneCodes.get(0));
        Object queryData = this.kgService.doForwardToKg("/restful/service/knowledgegraph/scene/querySceneMaps", HttpMethod.POST, params);
        if (ObjectUtils.isEmpty((Object)queryData)) {
            return FAIL_MSG;
        }
        ReportSceneDTOs sceneMapsData = (ReportSceneDTOs)JSON.parseObject((String)JSON.toJSONString((Object)queryData), ReportSceneDTOs.class);
        collectQuestion.setAppCode(sceneMapsData.getAppCode());
        List dataCollectConfigs = StringUtils.isNotEmpty((CharSequence)config.getAsaCode()) ? this.getQueryDataCollectConfig(config.getAsaCode()) : this.getQueryDataCollectConfig();
        if (StringUtils.isEmpty((CharSequence)collectQuestion.getGroupId()) && StringUtils.isNotEmpty((CharSequence)collectQuestion.getGroupValue())) {
            this.assignGroupIdToCollectQuestion(config, collectQuestion);
        }
        if (CollectionUtils.isEmpty((Collection)dataCollectConfigs)) {
            config.setBoardId("board_" + UUID.randomUUID().toString().replace("-", ""));
            collectQuestion.setQuestionId("question_" + UUID.randomUUID().toString().replace("-", ""));
            config.setDataCollectQuestions(Collections.singletonList(collectQuestion));
            this.mongoTemplateUser.save((Object)config);
        } else {
            List dataCollectQuestions = ((DataCollectConfig)dataCollectConfigs.get(0)).getDataCollectQuestions();
            this.processDataCollectQuestions(config, dataCollectQuestions);
            Object dBDataObject = this.sceneService.getTranslateContent((Object)dataCollectQuestions);
            List dBDataList = (List)JSONObject.parseObject((String)JsonUtil.toJsonString((Object)dBDataObject), (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (Feature[])new Feature[0]);
            Object requestObject = this.sceneService.getTranslateContent((Object)collectQuestion);
            DataCollectQuestions requestQuestion = (DataCollectQuestions)JsonUtil.toObject((String)JsonUtil.toJsonString((Object)requestObject), DataCollectQuestions.class);
            if (requestQuestion != null && CollectionUtils.isNotEmpty((Collection)requestQuestion.getDatasetIdList())) {
                String questionId = requestQuestion.getQuestionId();
                if (StringUtils.isEmpty((CharSequence)questionId)) {
                    requestQuestion.setQuestionId("question_" + UUID.randomUUID().toString().replace("-", ""));
                    dBDataList.add(0, requestQuestion);
                    this.updateDataCollectConfig(((DataCollectConfig)dataCollectConfigs.get(0)).getBoardId(), config, dBDataList);
                } else {
                    for (DataCollectQuestions dBDataQuestion : dBDataList) {
                        if (!Objects.equals(dBDataQuestion.getQuestionId(), questionId)) continue;
                        dBDataQuestion.setGroupId(StringUtils.isEmpty((CharSequence)requestQuestion.getGroupId()) ? dBDataQuestion.getGroupId() : requestQuestion.getGroupId());
                        dBDataQuestion.setGroupValue(StringUtils.isEmpty((CharSequence)requestQuestion.getGroupValue()) ? dBDataQuestion.getGroupValue() : requestQuestion.getGroupValue());
                        dBDataQuestion.setGroupType(StringUtils.isEmpty((CharSequence)requestQuestion.getGroupType()) ? dBDataQuestion.getGroupType() : requestQuestion.getGroupType());
                        if (!Objects.nonNull(requestQuestion.getSolutionStep())) continue;
                        dBDataQuestion.setSolutionStep(requestQuestion.getSolutionStep());
                        break;
                    }
                    this.updateDataCollectConfig(((DataCollectConfig)dataCollectConfigs.get(0)).getBoardId(), config, dBDataList);
                }
            } else if (dBDataList.contains(requestQuestion)) {
                dBDataList.removeIf(data -> Objects.equals(data.getSceneCode(), requestQuestion.getSceneCode()) && Objects.equals(data.getMetricIdList(), requestQuestion.getMetricIdList()) && Objects.equals(data.getQuestion(), requestQuestion.getQuestion()) && Objects.equals(data.getAppCode(), requestQuestion.getAppCode()));
                if (requestQuestion != null && StringUtils.isEmpty((CharSequence)requestQuestion.getQuestionId())) {
                    requestQuestion.setQuestionId("question_" + UUID.randomUUID().toString().replace("-", ""));
                }
                dBDataList.add(0, requestQuestion);
                this.updateDataCollectConfig(((DataCollectConfig)dataCollectConfigs.get(0)).getBoardId(), config, dBDataList);
            } else if (!dataCollectQuestions.contains(collectQuestion)) {
                if (StringUtils.isEmpty((CharSequence)collectQuestion.getQuestionId())) {
                    collectQuestion.setQuestionId("question_" + UUID.randomUUID().toString().replace("-", ""));
                }
                dataCollectQuestions.add(0, collectQuestion);
                this.updateDataCollectConfig(((DataCollectConfig)dataCollectConfigs.get(0)).getBoardId(), config, dataCollectQuestions);
            }
        }
        return SUCCESS_MSG;
    }

    private DataCollectGroupConfig getDataCollectGroupConfig(DataCollectConfig config, DataCollectQuestions collectQuestion) {
        DataCollectGroupConfig groupConfig = new DataCollectGroupConfig();
        groupConfig.setTenantId(config.getTenantId());
        groupConfig.setUserId(config.getUserId());
        groupConfig.setUserName(config.getUserName());
        groupConfig.setGroupValue("");
        groupConfig.setType(collectQuestion.getGroupType());
        groupConfig.setAsaCode(config.getAsaCode());
        return groupConfig;
    }

    public List<DataCollectConfig> getQueryDataCollectConfig() throws Exception {
        String userId = AthenaUtils.getUserId();
        String tenantId = AthenaUtils.getTenantId();
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"tenantId").is((Object)tenantId).and("userId").is((Object)userId).orOperator(new Criteria[]{Criteria.where((String)"asaCode").is(null), Criteria.where((String)"asaCode").is((Object)"")}));
        return this.mongoTemplateUser.find(query, DataCollectConfig.class);
    }

    public List<DataCollectConfig> getQueryDataCollectConfig(String asaCode) throws Exception {
        String userId = AthenaUtils.getUserId();
        String tenantId = AthenaUtils.getTenantId();
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"tenantId").is((Object)tenantId).and("userId").is((Object)userId).and("asaCode").is((Object)asaCode));
        return this.mongoTemplateUser.find(query, DataCollectConfig.class);
    }

    public Object postQueryDataCollectConfig(QueryConfigDTO queryConfig) throws Exception {
        List dataCollectConfigs;
        String asaCode = queryConfig.getAsaCode();
        List list = dataCollectConfigs = StringUtils.isNotEmpty((CharSequence)asaCode) ? this.getQueryDataCollectConfig(asaCode) : this.getQueryDataCollectConfig();
        if (StringUtils.isEmpty((CharSequence)queryConfig.getGroupId()) || null == dataCollectConfigs || dataCollectConfigs.isEmpty()) {
            return dataCollectConfigs;
        }
        List collectConfigs = ((DataCollectConfig)dataCollectConfigs.get(0)).getDataCollectQuestions();
        if (null != collectConfigs) {
            List filteredList = collectConfigs.stream().filter(collectConfig -> Objects.equals(queryConfig.getGroupId(), collectConfig.getGroupId())).collect(Collectors.toList());
            ((DataCollectConfig)dataCollectConfigs.get(0)).setDataCollectQuestions(filteredList);
        }
        return this.sceneService.getTranslateContent((Object)dataCollectConfigs);
    }

    public String postRemoveDataCollectConfig(DataCollectConfig config) throws Exception {
        List questions;
        DataCollectConfig configs;
        List dataCollectQuestion = config.getDataCollectQuestions();
        if (CollectionUtils.isEmpty((Collection)dataCollectQuestion)) {
            return SUCCESS_MSG;
        }
        String questionId = ((DataCollectQuestions)dataCollectQuestion.get(0)).getQuestionId();
        if (!StringUtils.isEmpty((CharSequence)questionId) && Objects.nonNull(configs = (DataCollectConfig)this.mongoTemplateUser.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"dataCollectQuestions.questionId").is((Object)questionId)), DataCollectConfig.class)) && !CollectionUtils.isEmpty((Collection)(questions = configs.getDataCollectQuestions()))) {
            questions.removeIf(dataCollectQues -> Objects.equals(questionId, dataCollectQues.getQuestionId()));
            this.updateDataCollectConfig(configs.getBoardId(), config, questions);
            return SUCCESS_MSG;
        }
        List dataCollectConfigs = StringUtils.isEmpty((CharSequence)config.getAsaCode()) ? this.getQueryDataCollectConfig() : this.getQueryDataCollectConfig(config.getAsaCode());
        if (CollectionUtils.isEmpty((Collection)dataCollectConfigs)) {
            return FAIL_MSG;
        }
        List dataCollectQuestions = ((DataCollectConfig)dataCollectConfigs.get(0)).getDataCollectQuestions();
        if (CollectionUtils.isNotEmpty((Collection)dataCollectQuestions)) {
            dataCollectQuestions.removeAll(config.getDataCollectQuestions());
        }
        this.updateDataCollectConfig(((DataCollectConfig)dataCollectConfigs.get(0)).getBoardId(), config, dataCollectQuestions);
        return SUCCESS_MSG;
    }

    private void processDataCollectQuestions(DataCollectConfig config, List<DataCollectQuestions> dataCollectQuestions) throws Exception {
        String currentLocale = AthenaUtils.getCurrentLocale();
        DataCollectQuestions collectQuestion = (DataCollectQuestions)config.getDataCollectQuestions().get(0);
        if (CollectionUtils.isEmpty((Collection)collectQuestion.getDatasetIdList()) && CollectionUtils.isNotEmpty(dataCollectQuestions) && dataCollectQuestions.contains(collectQuestion)) {
            int index = dataCollectQuestions.indexOf(collectQuestion);
            if (StringUtils.isNotEmpty((CharSequence)collectQuestion.getGroupId()) && !Objects.equals(collectQuestion.getGroupId(), dataCollectQuestions.get(index).getGroupId())) {
                collectQuestion.setSolutionStep(ObjectUtils.isEmpty((Object)collectQuestion.getSolutionStep()) ? dataCollectQuestions.get(index).getSolutionStep() : collectQuestion.getSolutionStep());
                dataCollectQuestions.set(index, collectQuestion);
            } else {
                if (Objects.equals("zh_TW", currentLocale)) {
                    throw new DWBusinessException("P.KG.500.99990", "\u5df2\u6536\u85cf\uff0c\u8acb\u52ff\u91cd\u8907\u6dfb\u52a0");
                }
                throw new DWBusinessException("P.KG.500.99990", "\u5df2\u6536\u85cf\uff0c\u8bf7\u52ff\u91cd\u590d\u6dfb\u52a0");
            }
        }
        HashMap<String, Integer> groupCountMap = new HashMap<String, Integer>();
        for (DataCollectQuestions dataCollectQuestion1 : dataCollectQuestions) {
            if (!StringUtils.isNotBlank((CharSequence)dataCollectQuestion1.getGroupId())) continue;
            groupCountMap.put(dataCollectQuestion1.getGroupId(), groupCountMap.getOrDefault(dataCollectQuestion1.getGroupId(), 0) + 1);
        }
        int currentGroupCount = groupCountMap.getOrDefault(collectQuestion.getGroupId(), 0);
        if (CollectionUtils.isNotEmpty(dataCollectQuestions) && currentGroupCount >= 8 && (!dataCollectQuestions.contains(collectQuestion) || CollectionUtils.isNotEmpty((Collection)collectQuestion.getDatasetIdList())) && StringUtils.isNotBlank((CharSequence)collectQuestion.getGroupValue())) {
            if (Objects.equals("zh_TW", currentLocale)) {
                throw new DWBusinessException("P.KG.500.99999", "\u7576\u524d\u770b\u677f\u6700\u591a\u6536\u85cf8\u500b\u554f\u984c");
            }
            throw new DWBusinessException("P.KG.500.99999", "\u5f53\u524d\u770b\u677f\u6700\u591a\u6536\u85cf8\u4e2a\u95ee\u9898");
        }
    }

    public void updateDataCollectConfig(String boardId, DataCollectConfig config, List<DataCollectQuestions> dataCollectQuestions) throws Exception {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"tenantId").is((Object)config.getTenantId()).and("boardId").is((Object)boardId).and("userId").is((Object)config.getUserId()));
        Update update = new Update();
        update.set("dataCollectQuestions", dataCollectQuestions);
        if (StringUtils.isNotEmpty((CharSequence)config.getAgileDataMessageType())) {
            update.set("agileDataMessageType", (Object)config.getAgileDataMessageType());
        }
        this.mongoTemplateUser.updateMulti(query, (UpdateDefinition)update, DataCollectConfig.class);
    }

    public void postRemoveDataCollectConfig(String asaCode, List<String> groupIds) throws Exception {
        String userId = AthenaUtils.getUserId();
        String tenantId = AthenaUtils.getTenantId();
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"tenantId").is((Object)tenantId).and("userId").is((Object)userId));
        if (StringUtils.isNotEmpty((CharSequence)asaCode)) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"asaCode").is((Object)asaCode));
        } else {
            Criteria criteria = new Criteria().orOperator(new Criteria[]{Criteria.where((String)"asaCode").is((Object)""), Criteria.where((String)"asaCode").is(null)});
            query.addCriteria((CriteriaDefinition)criteria);
        }
        List dataCollectConfigs = this.mongoTemplateUser.find(query, DataCollectConfig.class);
        if (CollectionUtils.isEmpty((Collection)dataCollectConfigs)) {
            return;
        }
        List dataCollectQuestions = ((DataCollectConfig)dataCollectConfigs.get(0)).getDataCollectQuestions();
        if (CollectionUtils.isEmpty((Collection)dataCollectQuestions)) {
            return;
        }
        dataCollectQuestions.removeIf(dataCollectQuestion -> groupIds.contains(dataCollectQuestion.getGroupId()));
        this.updateDataCollectConfig(((DataCollectConfig)dataCollectConfigs.get(0)).getBoardId(), (DataCollectConfig)dataCollectConfigs.get(0), dataCollectQuestions);
    }

    public void assignGroupIdToCollectQuestion(DataCollectConfig config, DataCollectQuestions collectQuestion) throws Exception {
        List filteredList;
        DataCollectGroupConfig groupConfig = this.getDataCollectGroupConfig(config, collectQuestion);
        Object dataCollectGroupList = this.dataCollectGroupService.postQueryDataCollectGroupConfig(groupConfig);
        Map dataCollectGroupMap = (Map)dataCollectGroupList;
        Object groupData = new Object();
        if (!ObjectUtils.isEmpty((Object)dataCollectGroupMap)) {
            groupData = dataCollectGroupMap.get("groupData");
        }
        List dataCollectGroupConfigs = Collections.emptyList();
        if (!ObjectUtils.isEmpty((Object)groupData)) {
            dataCollectGroupConfigs = JSON.parseArray((String)groupData.toString(), DataCollectGroupConfig.class);
        }
        if (CollectionUtils.isNotEmpty(filteredList = dataCollectGroupConfigs.stream().filter(dataCollectGroupConfig -> Objects.equals(collectQuestion.getGroupValue(), dataCollectGroupConfig.getGroupValue())).collect(Collectors.toList()))) {
            collectQuestion.setGroupId(((DataCollectGroupConfig)filteredList.get(0)).getGroupId());
        } else {
            collectQuestion.setGroupId("group_" + UUID.randomUUID().toString().replace("-", ""));
            groupConfig.setOrderId(Integer.valueOf(CollectionUtils.isEmpty((Collection)dataCollectGroupConfigs) ? 1 : ((DataCollectGroupConfig)dataCollectGroupConfigs.get(dataCollectGroupConfigs.size() - 1)).getOrderId() + 1));
            groupConfig.setGroupId(collectQuestion.getGroupId());
            groupConfig.setGroupValue(collectQuestion.getGroupValue());
            this.dataCollectGroupService.postAddDataCollectGroupConfig(Collections.singletonList(groupConfig));
        }
    }

    public Object postQueryCollectStep(String questionId) {
        if (StringUtils.isEmpty((CharSequence)questionId)) {
            return null;
        }
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"dataCollectQuestions.questionId").is((Object)questionId));
        DataCollectConfig dataCollectConfigs = (DataCollectConfig)this.mongoTemplateUser.findOne(query, DataCollectConfig.class);
        if (Objects.isNull(dataCollectConfigs)) {
            return null;
        }
        DataCollectQuestions data = dataCollectConfigs.getDataCollectQuestions().stream().filter(dataCollectQuestion -> Objects.equals(questionId, dataCollectQuestion.getQuestionId())).findFirst().get();
        if (ObjectUtils.isEmpty((Object)data)) {
            return null;
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("solutionStep", data.getSolutionStep());
        result.put("groupId", data.getGroupId());
        result.put("groupValue", data.getGroupValue());
        result.put("groupType", data.getGroupType());
        result.put("questionId", data.getQuestionId());
        result.put("question", data.getQuestion());
        result.put("sceneCode", data.getSceneCode());
        result.put("appCode", data.getAppCode());
        result.put("metricIdList", data.getMetricIdList());
        result.put("showType", data.getShowType());
        result.put("snapshotId", data.getSnapshotId());
        result.put("datasetIdList", data.getDatasetIdList());
        result.put("boardId", dataCollectConfigs.getBoardId());
        result.put("filterAnalysis", data.getFilterAnalysis());
        result.put("stepFilterAnalysis", data.getStepFilterAnalysis());
        result.put("chartTitle", data.getChartTitle());
        return result;
    }

    public Object postUpdateCollectByConfig(QueryCollectDTO config) throws Exception {
        if (ObjectUtils.isEmpty((Object)config.getSolutionStep())) {
            return SUCCESS_MSG;
        }
        DataCollectConfig dataCollectConfig = new DataCollectConfig();
        dataCollectConfig.setTenantId(AthenaUtils.getTenantId());
        dataCollectConfig.setUserId(AthenaUtils.getUserId());
        dataCollectConfig.setBoardId(config.getBoardId());
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"boardId").is((Object)config.getBoardId()));
        DataCollectConfig dataCollectConfigs = (DataCollectConfig)this.mongoTemplateUser.findOne(query, DataCollectConfig.class);
        if (Objects.isNull(dataCollectConfigs)) {
            return FAIL_MSG;
        }
        dataCollectConfigs.getDataCollectQuestions().forEach(dataCollectQuestion -> {
            if (Objects.equals(dataCollectQuestion.getSceneCode(), config.getSceneCode()) && Objects.equals(dataCollectQuestion.getMetricIdList(), config.getMetricIdList()) && Objects.equals(dataCollectQuestion.getDatasetIdList(), config.getDatasetList()) && Objects.equals(dataCollectQuestion.getGroupId(), config.getGroupId())) {
                if (StringUtils.isEmpty((CharSequence)dataCollectQuestion.getQuestionId())) {
                    dataCollectQuestion.setQuestionId("question_" + UUID.randomUUID().toString().replace("-", ""));
                }
                dataCollectQuestion.setSolutionStep(config.getSolutionStep());
            }
        });
        this.updateDataCollectConfig(config.getBoardId(), dataCollectConfig, dataCollectConfigs.getDataCollectQuestions());
        return SUCCESS_MSG;
    }
}

