/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.agiledataquery.service.impl;

import com.alibaba.fastjson.JSON;
import com.digiwin.athena.agiledataquery.clients.IamService;
import com.digiwin.athena.agiledataquery.clients.KgService;
import com.digiwin.athena.agiledataquery.context.DWServiceContext;
import com.digiwin.athena.agiledataquery.dto.ReportSceneDTOs;
import com.digiwin.athena.agiledataquery.model.dataSubscription.DataSubscriptionConfig;
import com.digiwin.athena.agiledataquery.model.dataSubscription.DataSubscriptionConfigDTO;
import com.digiwin.athena.agiledataquery.model.dataSubscription.DataSubscriptionRule;
import com.digiwin.athena.agiledataquery.model.dataSubscription.DataSubscriptionScheduleParam;
import com.digiwin.athena.agiledataquery.model.dataSubscription.QuerySubscriptionDTO;
import com.digiwin.athena.agiledataquery.service.IDataSubscriptionService;
import com.digiwin.athena.agiledataquery.service.ISceneService;
import com.digiwin.athena.agiledataquery.service.inner.KgInnerService;
import com.digiwin.athena.agiledataquery.utils.DataSubscriptionUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.core.query.UpdateDefinition;
import org.springframework.http.HttpMethod;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class DataSubscriptionServiceImpl
implements IDataSubscriptionService {
    private static final Logger log = LoggerFactory.getLogger(DataSubscriptionServiceImpl.class);
    @Autowired
    @Qualifier(value="mongoTemplate")
    private MongoTemplate mongoTemplate;
    @Autowired
    @Qualifier(value="mongoTemplateTenant")
    MongoTemplate mongoTemplateUser;
    @Autowired
    ISceneService sceneService;
    @Autowired
    KgInnerService kgInnerService;
    @Autowired
    DataSubscriptionUtils dataSubscriptionUtils;
    @Autowired
    KgService kgService;
    private static final String SCHEDULE_URL = "/restful/standard/AgileDataEngine/schedule";
    @Value(value="${scdispatcherUrl}/restful/standard/AgileDataEngine/schedule")
    private String scdispatcherUrl;
    @Autowired
    private IamService iamService;

    public Object postAddDataSubscriptionConfig(DataSubscriptionRule config) throws Exception {
        Query query;
        DataSubscriptionRule dataSubscriptionRule;
        Map profile;
        Object tenantName;
        String tenantId = config.getTenantId();
        DataSubscriptionScheduleParam scheduleParam = config.getScheduleParam();
        if (scheduleParam == null) {
            return "fail";
        }
        String question = scheduleParam.getQuestion();
        String userId = scheduleParam.getUserId();
        String sceneCode = scheduleParam.getSceneCode();
        List metricIdList = CollectionUtils.isEmpty((Collection)scheduleParam.getMetricIdList()) ? new ArrayList() : scheduleParam.getMetricIdList();
        metricIdList.addAll(org.apache.commons.collections.CollectionUtils.isEmpty((Collection)scheduleParam.getDatasetIdList()) ? new ArrayList() : scheduleParam.getDatasetIdList());
        if (StringUtils.isBlank((CharSequence)question) || StringUtils.isBlank((CharSequence)userId) || StringUtils.isBlank((CharSequence)sceneCode) && CollectionUtils.isEmpty(metricIdList)) {
            return "fail";
        }
        String tenantVersion = this.kgInnerService.currentTenantVersion();
        List codes = scheduleParam.getDatasetIdList();
        ReportSceneDTOs reportScene = null;
        if (!CollectionUtils.isEmpty((Collection)codes)) {
            reportScene = (ReportSceneDTOs)this.mongoTemplate.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"version").is((Object)tenantVersion).and("code").in((Collection)codes)), ReportSceneDTOs.class, "agiledatainquiry_data_set");
        }
        if (Objects.isNull(reportScene)) {
            List<Object> sceneCodes = CollectionUtils.isEmpty(metricIdList) ? Collections.singletonList(sceneCode) : metricIdList;
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("code", sceneCodes.get(0));
            Object queryData = this.kgService.doForwardToKg("/restful/service/knowledgegraph/scene/querySceneMaps", HttpMethod.POST, params);
            if (ObjectUtils.isEmpty((Object)queryData)) {
                return "fail";
            }
            reportScene = (ReportSceneDTOs)JSON.parseObject((String)JSON.toJSONString((Object)queryData), ReportSceneDTOs.class);
            if (reportScene == null) {
                return "fail";
            }
        }
        if (Objects.isNull(tenantName = (profile = DWServiceContext.getContext().getProfile()).get("tenantName"))) {
            return "fail";
        }
        HttpMethod method = HttpMethod.POST;
        String appCode = reportScene.getAppCode();
        config.setAppCode(appCode);
        config.setActionId(reportScene.getActionId());
        scheduleParam.setTenantId(tenantId);
        scheduleParam.setTenantName(tenantName.toString());
        if (ObjectUtils.isEmpty((Object)scheduleParam.getSolutionStep()) && StringUtils.isNotBlank((CharSequence)config.getRuleId()) && !ObjectUtils.isEmpty((Object)(dataSubscriptionRule = (DataSubscriptionRule)this.mongoTemplateUser.findOne(query = Query.query((CriteriaDefinition)Criteria.where((String)"ruleId").is((Object)config.getRuleId())), DataSubscriptionRule.class))) && !ObjectUtils.isEmpty((Object)dataSubscriptionRule.getScheduleParam())) {
            scheduleParam.setSolutionStep(dataSubscriptionRule.getScheduleParam().getSolutionStep());
        }
        String res = "fail";
        if (StringUtils.isBlank((CharSequence)config.getRuleId())) {
            config.setRuleId("agileSubscribe_" + UUID.randomUUID().toString().replace("-", ""));
            DataSubscriptionConfig dataSubscriptionConfig = DataSubscriptionConfig.builder().tenantId(config.getTenantId()).ruleList(Collections.singletonList(config)).build();
            res = this.dataSubscriptionUtils.postDataSubscription((Object)dataSubscriptionConfig, SCHEDULE_URL, method);
        } else {
            method = HttpMethod.PUT;
            res = this.dataSubscriptionUtils.postDataSubscription((Object)config, SCHEDULE_URL, method);
        }
        if (Objects.equals("fail", res)) {
            return "fail";
        }
        if (Objects.equals(HttpMethod.POST.toString(), method.toString())) {
            this.mongoTemplateUser.save((Object)config);
        } else {
            Query query2 = Query.query((CriteriaDefinition)Criteria.where((String)"ruleId").is((Object)config.getRuleId()));
            Update update = new Update();
            update.set("triggers", (Object)config.getTriggers());
            update.set("enableStatus", (Object)config.getEnableStatus());
            update.set("scheduleParam", (Object)config.getScheduleParam());
            this.mongoTemplateUser.updateMulti(query2, (UpdateDefinition)update, DataSubscriptionRule.class);
        }
        return "success";
    }

    public List<DataSubscriptionRule> postQueryDataSubscriptionConfig(String tenantId, String userId, String question, String sceneCode) {
        return this.postQueryDataSubscriptionConfig(tenantId, userId, question, sceneCode, Collections.emptyList());
    }

    public List<DataSubscriptionRule> postQueryDataSubscriptionConfig(String tenantId, String userId, String question, String sceneCode, List<String> metricIdList) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"tenantId").is((Object)tenantId).and("scheduleParam.userId").is((Object)userId).and("enableStatus").is((Object)"Y").orOperator(new Criteria[]{Criteria.where((String)"scheduleParam.asaCode").is(null), Criteria.where((String)"scheduleParam.asaCode").is((Object)"")}));
        if (StringUtils.isNotEmpty((CharSequence)question)) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"scheduleParam.question").is((Object)question));
        }
        if (StringUtils.isNotEmpty((CharSequence)sceneCode)) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"scheduleParam.sceneCode").is((Object)sceneCode));
        }
        if (!CollectionUtils.isEmpty(metricIdList)) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"scheduleParam.metricIdList").all(metricIdList).size(metricIdList.size()));
        }
        return this.mongoTemplateUser.find(query, DataSubscriptionRule.class);
    }

    public List<DataSubscriptionRule> postQueryDataSubscriptionConfig(String tenantId, String userId, String question, String sceneCode, List<String> metricIdList, String asaCode) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"tenantId").is((Object)tenantId).and("scheduleParam.userId").is((Object)userId).and("enableStatus").is((Object)"Y").and("scheduleParam.asaCode").is((Object)asaCode));
        if (StringUtils.isNotEmpty((CharSequence)question)) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"scheduleParam.question").is((Object)question));
        }
        if (StringUtils.isNotEmpty((CharSequence)sceneCode)) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"scheduleParam.sceneCode").is((Object)sceneCode));
        }
        if (!CollectionUtils.isEmpty(metricIdList)) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"scheduleParam.metricIdList").all(metricIdList).size(metricIdList.size()));
        }
        return this.mongoTemplateUser.find(query, DataSubscriptionRule.class);
    }

    public List<DataSubscriptionRule> postQueryDataSubscriptionConfig(String tenantId, String userId, String question, String sceneCode, List<String> metricIdList, List<String> datasetIdList, String asaCode) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"tenantId").is((Object)tenantId).and("scheduleParam.userId").is((Object)userId).and("enableStatus").is((Object)"Y").and("scheduleParam.asaCode").is((Object)asaCode));
        if (StringUtils.isNotEmpty((CharSequence)question)) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"scheduleParam.question").is((Object)question));
        }
        if (StringUtils.isNotEmpty((CharSequence)sceneCode)) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"scheduleParam.sceneCode").is((Object)sceneCode));
        }
        if (!CollectionUtils.isEmpty(metricIdList)) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"scheduleParam.metricIdList").all(metricIdList).size(metricIdList.size()));
        }
        if (!CollectionUtils.isEmpty(datasetIdList)) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"scheduleParam.datasetIdList").all(datasetIdList).size(datasetIdList.size()));
        }
        return this.mongoTemplateUser.find(query, DataSubscriptionRule.class);
    }

    public Object postRemoveDataSubscriptionConfig(String tenantId, String userId, String sceneCode, String question) {
        return this.postRemoveDataSubscriptionConfig(tenantId, userId, sceneCode, Collections.emptyList(), question);
    }

    public Object postRemoveDataSubscriptionConfig(String tenantId, String userId, String sceneCode, List<String> metricIdList, String question) {
        List dataSubscriptionRules = this.postQueryDataSubscriptionConfig(tenantId, userId, question, sceneCode, metricIdList);
        if (!CollectionUtils.isEmpty((Collection)dataSubscriptionRules)) {
            List unDeletableRules = dataSubscriptionRules.stream().filter(rule -> Objects.nonNull(rule.getScheduleParam()) && Objects.equals(Boolean.FALSE, rule.getScheduleParam().getUndeletable())).collect(Collectors.toList());
            List distinctRuleIds = this.getRuleId(unDeletableRules);
            if (CollectionUtils.isEmpty((Collection)distinctRuleIds)) {
                return "fail";
            }
            DataSubscriptionConfigDTO dataSubscriptionConfig = DataSubscriptionConfigDTO.builder().tenantId(tenantId).ruleId(String.join((CharSequence)",", distinctRuleIds)).build();
            String res = this.dataSubscriptionUtils.postDataSubscription((Object)dataSubscriptionConfig, SCHEDULE_URL, HttpMethod.DELETE);
            if (Objects.equals("success", res)) {
                this.mongoTemplateUser.remove(Query.query((CriteriaDefinition)Criteria.where((String)"ruleId").in((Collection)distinctRuleIds)), DataSubscriptionRule.class);
                return "success";
            }
        }
        return "fail";
    }

    public Object postRemoveDataSubscriptionConfig(String tenantId, String userId, String sceneCode, List<String> metricIdList, String question, String asaCode) {
        List dataSubscriptionRules = this.postQueryDataSubscriptionConfig(tenantId, userId, question, sceneCode, metricIdList, asaCode);
        if (!CollectionUtils.isEmpty((Collection)dataSubscriptionRules)) {
            List unDeletableRules = dataSubscriptionRules.stream().filter(rule -> Objects.nonNull(rule.getScheduleParam()) && Objects.equals(Boolean.FALSE, rule.getScheduleParam().getUndeletable())).collect(Collectors.toList());
            List distinctRuleIds = this.getRuleId(unDeletableRules);
            if (CollectionUtils.isEmpty((Collection)distinctRuleIds)) {
                return "fail";
            }
            DataSubscriptionConfigDTO dataSubscriptionConfig = DataSubscriptionConfigDTO.builder().tenantId(tenantId).ruleId(String.join((CharSequence)",", distinctRuleIds)).build();
            String res = this.dataSubscriptionUtils.postDataSubscription((Object)dataSubscriptionConfig, SCHEDULE_URL, HttpMethod.DELETE);
            if (Objects.equals("success", res)) {
                this.mongoTemplateUser.remove(Query.query((CriteriaDefinition)Criteria.where((String)"ruleId").in((Collection)distinctRuleIds)), DataSubscriptionRule.class);
                return "success";
            }
        }
        return "fail";
    }

    public Object postRemoveDataSubscriptionConfig(String tenantId, String userId, String sceneCode, List<String> metricIdList, List<String> datasetIdList, String question, String asaCode) {
        List dataSubscriptionRules = this.postQueryDataSubscriptionConfig(tenantId, userId, question, sceneCode, metricIdList, datasetIdList, asaCode);
        if (!CollectionUtils.isEmpty((Collection)dataSubscriptionRules)) {
            List unDeletableRules = dataSubscriptionRules.stream().filter(rule -> Objects.nonNull(rule.getScheduleParam()) && Objects.equals(Boolean.FALSE, rule.getScheduleParam().getUndeletable())).collect(Collectors.toList());
            List distinctRuleIds = this.getRuleId(unDeletableRules);
            if (CollectionUtils.isEmpty((Collection)distinctRuleIds)) {
                return "fail";
            }
            DataSubscriptionConfigDTO dataSubscriptionConfig = DataSubscriptionConfigDTO.builder().tenantId(tenantId).ruleId(String.join((CharSequence)",", distinctRuleIds)).build();
            String res = this.dataSubscriptionUtils.postDataSubscription((Object)dataSubscriptionConfig, SCHEDULE_URL, HttpMethod.DELETE);
            if (Objects.equals("success", res)) {
                this.mongoTemplateUser.remove(Query.query((CriteriaDefinition)Criteria.where((String)"ruleId").in((Collection)distinctRuleIds)), DataSubscriptionRule.class);
                return "success";
            }
        }
        return "fail";
    }

    public Object postRemoveDataSubscriptionConfig(String tenantId, List<String> ruleIds) {
        if (CollectionUtils.isEmpty(ruleIds)) {
            return "fail";
        }
        DataSubscriptionConfigDTO dataSubscriptionConfig = DataSubscriptionConfigDTO.builder().tenantId(tenantId).ruleId(String.join((CharSequence)",", ruleIds)).build();
        String res = this.dataSubscriptionUtils.postDataSubscription((Object)dataSubscriptionConfig, SCHEDULE_URL, HttpMethod.DELETE);
        if (Objects.equals("success", res)) {
            this.mongoTemplateUser.remove(Query.query((CriteriaDefinition)Criteria.where((String)"ruleId").in(ruleIds)), DataSubscriptionRule.class);
            return "success";
        }
        return "fail";
    }

    public Object getSingleDataSubscriptionConfig(String ruleId) throws Exception {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"ruleId").is((Object)ruleId));
        return this.mongoTemplateUser.findOne(query, DataSubscriptionRule.class);
    }

    public List<DataSubscriptionRule> postQueryExpireDataSubscriptionConfig(String tenantId, String userId, String question, String appCode) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"tenantId").is((Object)tenantId));
        if (StringUtils.isNotEmpty((CharSequence)appCode)) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"appCode").is((Object)appCode));
        }
        if (StringUtils.isNotEmpty((CharSequence)userId)) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"scheduleParam.userId").is((Object)userId));
        }
        if (StringUtils.isNotEmpty((CharSequence)question)) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"scheduleParam.question").is((Object)question));
        }
        return this.mongoTemplateUser.find(query, DataSubscriptionRule.class);
    }

    public void postAppRenewDataSubscription(List<DataSubscriptionRule> config) {
        if (CollectionUtils.isEmpty(config)) {
            return;
        }
        List distinctRuleIds = this.getRuleId(config);
        String res = this.dataSubscriptionUtils.postDataSubscription(config, SCHEDULE_URL, HttpMethod.POST);
        if (Objects.equals("success", res)) {
            this.mongoTemplateUser.updateMulti(Query.query((CriteriaDefinition)Criteria.where((String)"ruleId").in((Collection)distinctRuleIds)), (UpdateDefinition)new Update().set("enableStatus", (Object)"Y"), DataSubscriptionRule.class);
        }
    }

    public void postRemoveDataSubscription(List<DataSubscriptionRule> config, String type) {
        if (CollectionUtils.isEmpty(config)) {
            return;
        }
        List distinctRuleIds = this.getRuleId(config);
        if (Objects.equals(type, "delete")) {
            this.mongoTemplateUser.remove(Query.query((CriteriaDefinition)Criteria.where((String)"ruleId").in((Collection)distinctRuleIds)), DataSubscriptionRule.class);
        } else {
            DataSubscriptionConfigDTO dataSubscriptionConfig = DataSubscriptionConfigDTO.builder().tenantId(config.get(0).getTenantId()).ruleId(String.join((CharSequence)",", distinctRuleIds)).build();
            String res = this.dataSubscriptionUtils.postDataSubscription((Object)dataSubscriptionConfig, SCHEDULE_URL, HttpMethod.DELETE);
            if (Objects.equals("success", res)) {
                this.mongoTemplateUser.updateMulti(Query.query((CriteriaDefinition)Criteria.where((String)"ruleId").in((Collection)distinctRuleIds)), (UpdateDefinition)new Update().set("enableStatus", (Object)"N"), DataSubscriptionRule.class);
            }
        }
    }

    private List<String> getRuleId(List<DataSubscriptionRule> config) {
        return config.stream().map(DataSubscriptionRule::getRuleId).distinct().collect(Collectors.toList());
    }

    public Object postSegmentDataSubscription(List<String> ruleIds) {
        Query query = new Query();
        if (!CollectionUtils.isEmpty(ruleIds)) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"ruleId").in(ruleIds));
        }
        List dataSubscriptionRules = this.mongoTemplateUser.find(query, DataSubscriptionRule.class);
        int count = 0;
        HashMap<String, Serializable> result = new HashMap<String, Serializable>();
        if (CollectionUtils.isEmpty((Collection)dataSubscriptionRules)) {
            result.put("count", Integer.valueOf(count));
            return result;
        }
        ArrayList<String> subscriptionConfigDTOList = new ArrayList<String>();
        count = dataSubscriptionRules.size();
        for (DataSubscriptionRule config : dataSubscriptionRules) {
            Boolean handleResult = this.handleDataSubscription(config);
            if (handleResult.booleanValue()) continue;
            subscriptionConfigDTOList.add(config.getRuleId());
        }
        result.put("count", Integer.valueOf(count));
        result.put("errorRuleIds", subscriptionConfigDTOList);
        return result;
    }

    private Boolean handleDataSubscription(DataSubscriptionRule config) {
        HashMap<String, String> profile = new HashMap<String, String>();
        profile.put("tenantId", config.getTenantId());
        DWServiceContext.getContext().setProfile(profile);
        DataSubscriptionConfigDTO delDataSubscriptionConfig = DataSubscriptionConfigDTO.builder().tenantId(config.getTenantId()).ruleId(config.getRuleId()).build();
        String delResult = this.dataSubscriptionUtils.postDataSubscription((Object)delDataSubscriptionConfig, this.scdispatcherUrl, HttpMethod.DELETE);
        if (Objects.equals("fail", delResult)) {
            return false;
        }
        String addResult = this.dataSubscriptionUtils.postDataSubscription((Object)config, SCHEDULE_URL, HttpMethod.PUT);
        return Objects.equals("success", addResult);
    }

    public Object postUpdateSubscriptionByConfig(QuerySubscriptionDTO config) {
        if (StringUtils.isEmpty((CharSequence)config.getRuleId()) || ObjectUtils.isEmpty((Object)config.getSolutionStep())) {
            return "success";
        }
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"ruleId").is((Object)config.getRuleId()));
        DataSubscriptionRule dataSubscriptionRule = (DataSubscriptionRule)this.mongoTemplateUser.findOne(query, DataSubscriptionRule.class);
        if (Objects.isNull(dataSubscriptionRule)) {
            return "success";
        }
        dataSubscriptionRule.getScheduleParam().setSolutionStep(config.getSolutionStep());
        String res = this.dataSubscriptionUtils.postDataSubscription((Object)config, SCHEDULE_URL, HttpMethod.PUT);
        Update update = new Update();
        update.set("scheduleParam", (Object)dataSubscriptionRule.getScheduleParam());
        this.mongoTemplateUser.updateMulti(query, (UpdateDefinition)update, DataSubscriptionRule.class);
        return "success";
    }
}

