/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.agiledataquery.service.impl;

import com.digiwin.athena.agiledataquery.clients.KgService;
import com.digiwin.athena.agiledataquery.domain.OperationUnit;
import com.digiwin.athena.agiledataquery.service.IMechanismService;
import com.digiwin.athena.agiledataquery.utils.DWBusinessException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.http.HttpMethod;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class MechanismServiceImpl
implements IMechanismService {
    private static final Logger log = LoggerFactory.getLogger(MechanismServiceImpl.class);
    @Autowired
    @Qualifier(value="mongoTemplateTenant")
    MongoTemplate mongoTemplate2;
    @Autowired
    private KgService kgService;

    public Object postQuerySmartDataVariable(List<String> variableIds, String tenantId) {
        Criteria criteria = Criteria.where((String)"tenantId").is((Object)tenantId).and("code").in(variableIds);
        Query query = new Query((CriteriaDefinition)criteria);
        List tenantVariableList = this.mongoTemplate2.find(query, Map.class, "agiledata_business_variables_value");
        HashMap<String, Map> resultMap = new HashMap<String, Map>();
        if (!CollectionUtils.isEmpty((Collection)tenantVariableList)) {
            for (Map map : tenantVariableList) {
                resultMap.put(map.get("code").toString(), map);
            }
        }
        variableIds.forEach(variableId -> resultMap.putIfAbsent((String)variableId, (Map)null));
        return resultMap;
    }

    public Object postQueryMechanismByCode(List<String> codeList, OperationUnit operationUnit, Boolean queryWithEocLevel) throws DWBusinessException {
        HashMap<String, Object> req = new HashMap<String, Object>();
        req.put("codeList", codeList);
        req.put("operationUnit", null);
        req.put("queryWithEocLevel", false);
        String url = "/restful/service/knowledgegraph/Mechanism/queryMechanismByCode";
        return this.kgService.doForwardToKg(url, HttpMethod.POST, req);
    }
}

