/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.agiledataquery.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.agiledataquery.clients.KgService;
import com.digiwin.athena.agiledataquery.domain.action.Action;
import com.digiwin.athena.agiledataquery.domain.action.ActionLabel;
import com.digiwin.athena.agiledataquery.domain.action.execution.model.ActionTypeEnum;
import com.digiwin.athena.agiledataquery.domain.app.Application;
import com.digiwin.athena.agiledataquery.domain.common.BaseEntity;
import com.digiwin.athena.agiledataquery.dto.ReportSceneDTOs;
import com.digiwin.athena.agiledataquery.model.sence.BusinessTypeDTO;
import com.digiwin.athena.agiledataquery.service.IMetricService;
import com.digiwin.athena.agiledataquery.service.ISceneService;
import com.digiwin.athena.agiledataquery.service.inner.DataPickService;
import com.digiwin.athena.agiledataquery.service.inner.KgInnerService;
import com.digiwin.athena.agiledataquery.utils.AthenaUtils;
import com.digiwin.athena.agiledataquery.utils.DWBusinessException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class MetricServiceImpl
implements IMetricService {
    private static final Logger log = LoggerFactory.getLogger(MetricServiceImpl.class);
    @Autowired
    @Qualifier(value="mongoTemplate")
    private MongoTemplate mongoTemplate;
    @Autowired
    @Qualifier(value="mongoTemplateTenant")
    private MongoTemplate mongoTemplateUser;
    @Autowired
    private KgInnerService kgInnerService;
    @Autowired
    private DataPickService dataPickService;
    @Autowired
    private KgService kgService;
    @Autowired
    ISceneService sceneService;

    public Object metricDataSource(String appCode, String version) throws Exception {
        if (StringUtils.isBlank((CharSequence)appCode) || StringUtils.isBlank((CharSequence)version)) {
            throw new IllegalArgumentException("appCode and version cannot be null or empty!");
        }
        HashMap<String, String> metricDataSource = new HashMap<String, String>();
        Application application = (Application)this.dataPickService.findOneByCondition(Criteria.where((String)"code").is((Object)appCode), Application.class, "application");
        if (application != null && StringUtils.isNotEmpty((CharSequence)application.getSource())) {
            metricDataSource.put("dataSource", application.getSource());
            metricDataSource.put("appCode", appCode);
            metricDataSource.put("version", version);
        }
        return metricDataSource;
    }

    public Object metricDataSource(List<String> indicatorIds) throws DWBusinessException, NoSuchFieldException, IllegalAccessException {
        if (CollectionUtils.isEmpty(indicatorIds)) {
            throw new DWBusinessException("indicatorIds cannot be null or empty!");
        }
        String tenantVersion = this.kgInnerService.currentTenantVersion();
        List dataSetList = this.mongoTemplate.find(Query.query((CriteriaDefinition)Criteria.where((String)"version").is((Object)tenantVersion).and("code").in(indicatorIds)), ReportSceneDTOs.class, "agiledatainquiry_data_set");
        if (CollectionUtils.isEmpty((Collection)dataSetList)) {
            HashMap<String, List<String>> params = new HashMap<String, List<String>>();
            params.put("indicatorIds", indicatorIds);
            return this.kgService.doForwardToKg(params);
        }
        ArrayList<String> appCodes = new ArrayList<String>();
        HashMap<String, ReportSceneDTOs> metricMap = new HashMap<String, ReportSceneDTOs>();
        for (ReportSceneDTOs scene : dataSetList) {
            appCodes.add(scene.getAppCode());
            metricMap.put(scene.getCode(), scene);
        }
        return this.sceneService.getTranslateContent((Object)this.getMetricDataSource(metricMap, appCodes, tenantVersion));
    }

    private List<Map<String, Object>> getMetricDataSource(Map<String, ReportSceneDTOs> metricMap, List<String> appCodes, String version) throws DWBusinessException {
        ArrayList<Map<String, Object>> metricDataSource = new ArrayList<Map<String, Object>>();
        List applications = this.dataPickService.find(Criteria.where((String)"code").in(appCodes), Application.class, "application");
        if (!CollectionUtils.isEmpty((Collection)applications)) {
            Map<String, String> applicationCodeToSource = applications.stream().collect(Collectors.toMap(BaseEntity::getCode, app -> Optional.ofNullable(app.getSource()).orElse("")));
            for (Map.Entry<String, ReportSceneDTOs> entry : metricMap.entrySet()) {
                ReportSceneDTOs scene = entry.getValue();
                HashMap<String, Object> dataSource = new HashMap<String, Object>();
                dataSource.put("appCode", scene.getAppCode());
                dataSource.put("version", version);
                dataSource.put("indicatorId", scene.getCode());
                dataSource.put("businessType", this.getBusinessType(scene));
                dataSource.put("productLine", scene.getProductLine());
                dataSource.put("classification", scene.getClassification());
                if (StringUtils.isNotEmpty((CharSequence)scene.getAppCode()) && applicationCodeToSource.containsKey(scene.getAppCode())) {
                    dataSource.put("dataSource", applicationCodeToSource.get(scene.getAppCode()));
                } else {
                    dataSource.put("dataSource", "");
                }
                dataSource.put("fieldSchema", scene.getFieldSchema());
                dataSource.put("measures", scene.getMeasures());
                dataSource.put("dimensions", scene.getDimensions());
                metricDataSource.add(dataSource);
            }
        }
        return metricDataSource;
    }

    private void handleMetricBusinessType(List<Map<String, Object>> result, List<String> businessTypes, String tenantVersion) throws DWBusinessException {
        String tenantId = AthenaUtils.getTenantId();
        List businessTypeDataList = this.mongoTemplateUser.find(Query.query((CriteriaDefinition)Criteria.where((String)"code").in(businessTypes).and("tenantId").is((Object)tenantId)), BusinessTypeDTO.class, "agiledata_business_type");
        if (CollectionUtils.isEmpty((Collection)businessTypeDataList)) {
            return;
        }
        Map businessTypeDataMap = businessTypeDataList.stream().collect(Collectors.toMap(BusinessTypeDTO::getCode, Function.identity()));
        result.forEach(data -> {
            String businessTypeCode = ((BusinessTypeDTO)data.get("businessType")).getCode();
            if (businessTypeDataMap.containsKey(businessTypeCode)) {
                data.put("businessType", businessTypeDataMap.get(businessTypeCode));
            }
        });
    }

    public Object metricQuerySchema(List<String> indicatorIds) throws DWBusinessException, NoSuchFieldException, IllegalAccessException {
        HashMap<String, List<String>> params = new HashMap<String, List<String>>();
        params.put("indicatorIds", indicatorIds);
        return this.kgService.doForwardToKg(params);
    }

    public Object metricBusinessByCode(String tenantId, String appCode, List<String> codes) throws DWBusinessException {
        String tenantVersion = this.kgInnerService.currentTenantVersion();
        List businessTypeSysDataList = this.mongoTemplate.find(Query.query((CriteriaDefinition)Criteria.where((String)"code").in(codes).and("appCode").is((Object)appCode).and("version").is((Object)tenantVersion)), BusinessTypeDTO.class, "agiledata_business_type");
        List businessTypeTenantDataList = this.mongoTemplateUser.find(Query.query((CriteriaDefinition)Criteria.where((String)"code").in(codes).and("appCode").is((Object)appCode).and("source").is((Object)"custom").and("tenantId").is((Object)tenantId)), BusinessTypeDTO.class, "agiledata_business_type");
        Map<String, BusinessTypeDTO> tenantMap = businessTypeTenantDataList.stream().collect(Collectors.toMap(BusinessTypeDTO::getCode, dto -> dto));
        List result = businessTypeSysDataList.stream().map(dto -> tenantMap.getOrDefault(dto.getCode(), (BusinessTypeDTO)dto)).collect(Collectors.toList());
        Map resultBusinessMap = result.stream().collect(Collectors.toMap(BusinessTypeDTO::getCode, Function.identity(), (existing, replacement) -> existing));
        codes.forEach(code -> {
            BusinessTypeDTO cfr_ignored_0 = (BusinessTypeDTO)resultBusinessMap.putIfAbsent((String)code, tenantMap.get(code));
        });
        return resultBusinessMap;
    }

    private List<Action> getAllMetricAction(Deque<String> stack, String tenantId, String tenantVersion) throws DWBusinessException {
        ArrayList<Action> metricActionList = new ArrayList<Action>();
        HashSet<String> processedIndicatorIds = new HashSet<String>();
        while (!stack.isEmpty()) {
            String currentIndicatorId = stack.pop();
            if (processedIndicatorIds.contains(currentIndicatorId)) continue;
            processedIndicatorIds.add(currentIndicatorId);
            List metricActions = this.dataPickService.filterByIndividual(new ArrayList(), tenantId, actionLabel -> actionLabel.getAction().getNameSpace());
            for (ActionLabel actionLabel2 : metricActions) {
                if (Objects.isNull(actionLabel2.getAction())) continue;
                if (Objects.equals(ActionTypeEnum.METRIC.toString(), actionLabel2.getAction().getType())) {
                    String metricId = actionLabel2.getAction().getQuoteMetricCode();
                    stack.push(metricId);
                    continue;
                }
                if (!Objects.equals(ActionTypeEnum.BMD_GENERAL.toString(), actionLabel2.getAction().getType())) continue;
                metricActionList.add(actionLabel2.getAction());
            }
        }
        return metricActionList;
    }

    public List<Object> getBusinessType(ReportSceneDTOs scene) {
        ArrayList<Object> businessType = scene.getBusinessType();
        if (!CollectionUtils.isEmpty((Collection)businessType)) {
            return businessType;
        }
        businessType = new ArrayList<Object>();
        this.extractBusinessType(scene.getFieldSchema(), businessType, "name");
        this.extractBusinessType(scene.getMeasures(), businessType, "data_name");
        return businessType;
    }

    private void extractBusinessType(List<Object> list, List<Object> businessType, String key) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        List dataList = list.stream().filter(item -> item instanceof Map || item instanceof JSONObject).map(item -> {
            if (item instanceof JSONObject) {
                return (JSONObject)item;
            }
            return new JSONObject((Map)item);
        }).filter(jsonObject -> jsonObject.containsKey((Object)"businessType")).map(jsonObject -> {
            JSONObject businessTypeConfig = jsonObject.getJSONObject("businessType");
            businessTypeConfig.put("key", jsonObject.get((Object)key));
            return businessTypeConfig;
        }).collect(Collectors.toList());
        businessType.addAll(dataList);
    }
}

