/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.agiledataquery.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.agiledataquery.clients.DMCUtils;
import com.digiwin.athena.agiledataquery.model.ppt.PptDefaultOwner;
import com.digiwin.athena.agiledataquery.model.ppt.PptDocument;
import com.digiwin.athena.agiledataquery.service.IPptService;
import com.digiwin.athena.agiledataquery.utils.AthenaUtils;
import com.digiwin.athena.agiledataquery.utils.DWBusinessException;
import com.mongodb.BasicDBObject;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.core.query.UpdateDefinition;
import org.springframework.stereotype.Service;

@Service
public class PptServiceImpl
implements IPptService {
    private static final Logger log = LoggerFactory.getLogger(PptServiceImpl.class);
    @Autowired
    @Qualifier(value="mongoTemplateTenant")
    private MongoTemplate mongoTemplateTenant;
    @Autowired
    private DMCUtils dmcUtils;
    private static final String COLLECTION = "agiledata_ppt_doc";

    public Object saveOrUpdate(PptDocument ppt) throws DWBusinessException {
        PptDefaultOwner owner;
        Query query;
        PptDocument exists;
        if (ppt == null) {
            throw new DWBusinessException("500", "PPT\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)ppt.getPptId())) {
            ppt.setPptId("ppt_" + UUID.randomUUID().toString().replace("-", ""));
        }
        String tenantId = AthenaUtils.getTenantId();
        String userId = AthenaUtils.getUserId();
        if (ppt.getDefaultPpt() != null && ppt.getDefaultPpt().booleanValue()) {
            BasicDBObject owner2 = new BasicDBObject("tenantId", (Object)tenantId).append("userId", (Object)userId);
            Query pullFromOthers = Query.query((CriteriaDefinition)Criteria.where((String)"defaultOwners").elemMatch(Criteria.where((String)"tenantId").is((Object)tenantId).and("userId").is((Object)userId)).and("dataType").is((Object)"system").and("defaultPpt").is((Object)true));
            Update pullUpdate = new Update().pull("defaultOwners", (Object)owner2);
            this.mongoTemplateTenant.updateMulti(pullFromOthers, (UpdateDefinition)pullUpdate, PptDocument.class, COLLECTION);
            Query emptyQuery = Query.query((CriteriaDefinition)Criteria.where((String)"dataType").is((Object)"system").and("defaultPpt").is((Object)true).and("defaultOwners").size(0));
            Update setFalse = new Update().set("defaultPpt", (Object)false);
            this.mongoTemplateTenant.updateMulti(emptyQuery, (UpdateDefinition)setFalse, COLLECTION);
            Update unsetDefaultPptUpdate = new Update().set("defaultPpt", (Object)false);
            Query unsetDefaultPptQuery = Query.query((CriteriaDefinition)new Criteria().andOperator(new Criteria[]{Criteria.where((String)"userId").is((Object)userId), Criteria.where((String)"tenantId").is((Object)tenantId), Criteria.where((String)"defaultPpt").is((Object)true), new Criteria().orOperator(new Criteria[]{Criteria.where((String)"dataType").is((Object)"user"), Criteria.where((String)"dataType").is(null), Criteria.where((String)"dataType").exists(false)})}));
            this.mongoTemplateTenant.updateMulti(unsetDefaultPptQuery, (UpdateDefinition)unsetDefaultPptUpdate, PptDocument.class, COLLECTION);
        }
        if ((exists = (PptDocument)this.mongoTemplateTenant.findOne(query = Query.query((CriteriaDefinition)Criteria.where((String)"pptId").is((Object)ppt.getPptId())), PptDocument.class, COLLECTION)) == null) {
            if (StringUtils.isBlank((CharSequence)ppt.getCreateDate())) {
                ppt.setCreateDate(ZonedDateTime.now().format(DateTimeFormatter.ISO_OFFSET_DATE_TIME));
            }
            if ("system".equalsIgnoreCase(ppt.getDataType())) {
                if (ppt.getDefaultPpt() != null && ppt.getDefaultPpt().booleanValue()) {
                    owner = new PptDefaultOwner();
                    owner.setTenantId(tenantId);
                    owner.setUserId(userId);
                    ppt.setDefaultOwners(Collections.singletonList(owner));
                } else {
                    ppt.setDefaultOwners(new ArrayList());
                }
            }
            this.mongoTemplateTenant.insert((Object)ppt, COLLECTION);
        } else {
            if ("system".equalsIgnoreCase(ppt.getDataType())) {
                if (ppt.getDefaultPpt() != null && ppt.getDefaultPpt().booleanValue()) {
                    owner = new PptDefaultOwner();
                    owner.setTenantId(tenantId);
                    owner.setUserId(userId);
                    ArrayList<PptDefaultOwner> owners = exists.getDefaultOwners();
                    if (CollectionUtils.isEmpty((Collection)owners)) {
                        owners = new ArrayList<PptDefaultOwner>();
                    }
                    owners.add(owner);
                    ppt.setDefaultOwners(owners.stream().distinct().collect(Collectors.toList()));
                } else {
                    ppt.setDefaultOwners(exists.getDefaultOwners());
                }
            }
            ppt.setCreateDate(exists.getCreateDate());
            this.mongoTemplateTenant.remove(query, PptDocument.class, COLLECTION);
            this.mongoTemplateTenant.insert((Object)ppt, COLLECTION);
        }
        HashMap<String, PptDocument> result = new HashMap<String, PptDocument>();
        result.put("data", ppt);
        return result;
    }

    public PptDocument getById(String pptId) throws DWBusinessException {
        if (StringUtils.isBlank((CharSequence)pptId)) {
            throw new DWBusinessException("500", "pptId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return (PptDocument)this.mongoTemplateTenant.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"pptId").is((Object)pptId)), PptDocument.class, COLLECTION);
    }

    public List<PptDocument> list(PptDocument ppt) throws DWBusinessException {
        String tenantId = StringUtils.isBlank((CharSequence)ppt.getTenantId()) ? AthenaUtils.getTenantId() : ppt.getTenantId();
        String userId = StringUtils.isBlank((CharSequence)ppt.getUserId()) ? AthenaUtils.getUserId() : ppt.getUserId();
        Criteria userCriteria = new Criteria().orOperator(new Criteria[]{Criteria.where((String)"dataType").is((Object)"user"), Criteria.where((String)"dataType").is(null), Criteria.where((String)"dataType").exists(false)});
        userCriteria = userCriteria.and("tenantId").is((Object)tenantId);
        if (StringUtils.isNotBlank((CharSequence)ppt.getUserId())) {
            userCriteria = userCriteria.and("userId").is((Object)ppt.getUserId());
        }
        Criteria systemCriteria = Criteria.where((String)"dataType").is((Object)"system");
        if (StringUtils.isNotBlank((CharSequence)ppt.getPptType())) {
            userCriteria = userCriteria.and("pptType").is((Object)ppt.getPptType());
            systemCriteria = systemCriteria.and("pptType").is((Object)ppt.getPptType());
        }
        if (StringUtils.isNotBlank((CharSequence)ppt.getPptName())) {
            userCriteria = userCriteria.and("pptName").is((Object)ppt.getPptName());
            systemCriteria = systemCriteria.and("pptName").is((Object)ppt.getPptName());
        }
        if (StringUtils.isNotBlank((CharSequence)ppt.getPptUrl())) {
            userCriteria = userCriteria.and("pptUrl").is((Object)ppt.getPptUrl());
            systemCriteria = systemCriteria.and("pptUrl").is((Object)ppt.getPptUrl());
        }
        if (ppt.getDefaultPpt() != null) {
            userCriteria = userCriteria.and("defaultPpt").is((Object)ppt.getDefaultPpt());
            if (Boolean.TRUE.equals(ppt.getDefaultPpt()) && StringUtils.isNotBlank((CharSequence)tenantId) && StringUtils.isNotBlank((CharSequence)userId)) {
                Criteria ownerMatch = Criteria.where((String)"defaultOwners").elemMatch(Criteria.where((String)"tenantId").is((Object)tenantId).and("userId").is((Object)userId));
                systemCriteria = systemCriteria.andOperator(new Criteria[]{ownerMatch});
            }
        }
        List userList = this.mongoTemplateTenant.find(Query.query((CriteriaDefinition)userCriteria), PptDocument.class, COLLECTION);
        List systemList = this.mongoTemplateTenant.find(Query.query((CriteriaDefinition)systemCriteria), PptDocument.class, COLLECTION);
        if (StringUtils.isNotBlank((CharSequence)tenantId) && StringUtils.isNotBlank((CharSequence)userId)) {
            for (PptDocument doc : systemList) {
                if (!Boolean.TRUE.equals(doc.getDefaultPpt()) || this.isOwner(doc, tenantId, userId)) continue;
                doc.setDefaultPpt(Boolean.valueOf(false));
            }
        }
        if (ppt.getDefaultPpt() != null && Boolean.FALSE.equals(ppt.getDefaultPpt()) && StringUtils.isNotBlank((CharSequence)tenantId) && StringUtils.isNotBlank((CharSequence)userId)) {
            userList = userList.stream().filter(d -> !this.isOwner(d, tenantId, userId)).collect(Collectors.toList());
            systemList = systemList.stream().filter(d -> !this.isOwner(d, tenantId, userId)).collect(Collectors.toList());
        }
        ArrayList<PptDocument> result = new ArrayList<PptDocument>();
        result.addAll(systemList);
        result.addAll(userList);
        Comparator byCreateDesc = (a, b) -> {
            ZonedDateTime da = this.parseDate(a.getCreateDate());
            ZonedDateTime db = this.parseDate(b.getCreateDate());
            if (da == null && db == null) {
                return 0;
            }
            if (da == null) {
                return 1;
            }
            if (db == null) {
                return -1;
            }
            return db.compareTo(da);
        };
        result.sort(byCreateDesc);
        return result;
    }

    private boolean isOwner(PptDocument doc, String tenantId, String userId) {
        if (doc == null || doc.getDefaultOwners() == null || doc.getDefaultOwners().isEmpty()) {
            return false;
        }
        for (Object o : doc.getDefaultOwners()) {
            if (o instanceof PptDefaultOwner) {
                PptDefaultOwner owner = (PptDefaultOwner)o;
                if (!tenantId.equals(owner.getTenantId()) || !userId.equals(owner.getUserId())) continue;
                return true;
            }
            if (!(o instanceof Map)) continue;
            Map m = (Map)o;
            Object t = m.get("tenantId");
            Object u = m.get("userId");
            if (!tenantId.equals(t) || !userId.equals(u)) continue;
            return true;
        }
        return false;
    }

    private ZonedDateTime parseDate(String iso) {
        if (StringUtils.isBlank((CharSequence)iso)) {
            return null;
        }
        try {
            return ZonedDateTime.parse(iso);
        }
        catch (Exception e) {
            try {
                DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
                return LocalDateTime.parse(iso, formatter).atZone(ZoneId.systemDefault());
            }
            catch (Exception ex) {
                try {
                    return LocalDateTime.parse(iso).atZone(ZoneId.systemDefault());
                }
                catch (Exception ex2) {
                    try {
                        return LocalDate.parse(iso).atStartOfDay(ZoneId.systemDefault());
                    }
                    catch (Exception ex3) {
                        log.warn("\u65e0\u6cd5\u89e3\u6790\u65e5\u671f\u5b57\u7b26\u4e32: {}", (Object)iso);
                        return null;
                    }
                }
            }
        }
    }

    public Object delete(String pptId, String docId) throws DWBusinessException {
        if (StringUtils.isBlank((CharSequence)pptId) || StringUtils.isBlank((CharSequence)docId)) {
            throw new DWBusinessException("500", "pptId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.mongoTemplateTenant.remove(Query.query((CriteriaDefinition)Criteria.where((String)"pptId").is((Object)pptId)), PptDocument.class, COLLECTION);
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        try {
            JSONObject res = this.dmcUtils.deleteDmcFile(docId, AthenaUtils.getHeaderToken());
            if (res.getInteger("code") == 200) {
                result.put("dmcDeleted", true);
            } else {
                result.put("dmcDeleted", false);
            }
        }
        catch (Exception e) {
            log.error("\u5220\u9664\u6587\u4ef6\u5931\u8d25", (Throwable)e);
            result.put("dmcDeleted", false);
        }
        return result;
    }

    public PptDocument setDefaultSystemPpt(String tenantId, String userId) throws DWBusinessException {
        Criteria systemCriteria = Criteria.where((String)"dataType").is((Object)"system");
        Query systemQuery = new Query((CriteriaDefinition)systemCriteria);
        systemQuery.with(Sort.by((Sort.Direction)Sort.Direction.ASC, (String[])new String[]{"createDate"}));
        systemQuery.limit(1);
        PptDocument systemPpt = (PptDocument)this.mongoTemplateTenant.findOne(systemQuery, PptDocument.class, COLLECTION);
        if (systemPpt == null) {
            throw new DWBusinessException("500", "\u672a\u627e\u5230\u53ef\u7528\u7684\u7cfb\u7edf\u7ea7PPT\u6587\u6863");
        }
        systemPpt.setDefaultPpt(Boolean.valueOf(true));
        return systemPpt;
    }
}

