/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.agiledataquery.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.agiledataquery.clients.ATMCService;
import com.digiwin.athena.agiledataquery.clients.CACUtils;
import com.digiwin.athena.agiledataquery.clients.EocService;
import com.digiwin.athena.agiledataquery.clients.IamService;
import com.digiwin.athena.agiledataquery.clients.KgService;
import com.digiwin.athena.agiledataquery.dao.ActivityDAO;
import com.digiwin.athena.agiledataquery.dao.MongoEntityBaseDAO;
import com.digiwin.athena.agiledataquery.domain.AppSubscription;
import com.digiwin.athena.agiledataquery.domain.OperationUnit;
import com.digiwin.athena.agiledataquery.domain.Task;
import com.digiwin.athena.agiledataquery.domain.TenantSummaryField;
import com.digiwin.athena.agiledataquery.domain.TenantSummaryFields;
import com.digiwin.athena.agiledataquery.domain.activity.Activity;
import com.digiwin.athena.agiledataquery.domain.activity.ActivityConfig;
import com.digiwin.athena.agiledataquery.domain.activity.ExportAndImportConfig;
import com.digiwin.athena.agiledataquery.domain.app.ApplicationRelation;
import com.digiwin.athena.agiledataquery.domain.app.FunctionCtrl;
import com.digiwin.athena.agiledataquery.domain.application.ApplicationGroup;
import com.digiwin.athena.agiledataquery.domain.common.BaseEntity;
import com.digiwin.athena.agiledataquery.domain.config.MergeRule;
import com.digiwin.athena.agiledataquery.domain.definition.ReminderRule;
import com.digiwin.athena.agiledataquery.domain.task.CardGroup;
import com.digiwin.athena.agiledataquery.domain.task.CardGroupApplication;
import com.digiwin.athena.agiledataquery.domain.task.CardGroupGroup;
import com.digiwin.athena.agiledataquery.domain.task.CardGroupTask;
import com.digiwin.athena.agiledataquery.domain.task.CardLabel;
import com.digiwin.athena.agiledataquery.domain.task.CardOrder;
import com.digiwin.athena.agiledataquery.domain.task.DataMapTaskVO;
import com.digiwin.athena.agiledataquery.domain.task.SystemGroup;
import com.digiwin.athena.agiledataquery.domain.task.TBBReportReplacer;
import com.digiwin.athena.agiledataquery.domain.valueobject.ActivityDataEntryVO;
import com.digiwin.athena.agiledataquery.dto.GroupAndLabelDto;
import com.digiwin.athena.agiledataquery.dto.TenantSummaryFieldsDto;
import com.digiwin.athena.agiledataquery.enums.WSPageCode;
import com.digiwin.athena.agiledataquery.model.CardConditionQueryDTO;
import com.digiwin.athena.agiledataquery.model.CardConfigQueryDTO;
import com.digiwin.athena.agiledataquery.service.IApplicationService;
import com.digiwin.athena.agiledataquery.service.ITaskService;
import com.digiwin.athena.agiledataquery.service.ITenantService;
import com.digiwin.athena.agiledataquery.service.inner.DataPickService;
import com.digiwin.athena.agiledataquery.service.inner.KgInnerService;
import com.digiwin.athena.agiledataquery.utils.AthenaUtils;
import com.digiwin.athena.agiledataquery.utils.DWBusinessException;
import com.digiwin.athena.agiledataquery.utils.I18nUtils;
import com.digiwin.athena.agiledataquery.utils.LanguageUtil;
import com.digiwin.athena.agiledataquery.utils.TranslateUtils;
import com.digiwin.athena.agiledataquery.vo.DataMapFindTaskResp;
import com.digiwin.athena.agiledataquery.vo.FindTaskFromUserRequest;
import com.digiwin.athena.agiledataquery.vo.FindTaskFromUserResp;
import com.digiwin.athena.agiledataquery.vo.FindTaskFromUserVO;
import com.digiwin.athena.agiledataquery.vo.SemcDictOption;
import com.digiwin.athena.agiledataquery.vo.TaskCardFieldRequest;
import com.digiwin.athena.agiledataquery.vo.TaskCardFieldVO;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.UpdateResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.core.query.UpdateDefinition;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class TaskServiceImpl
implements ITaskService {
    private static final Logger log = LoggerFactory.getLogger(TaskServiceImpl.class);
    public static final String SUMMARY = "summary";
    public static final String BUSINESS_INFO = "businessInfo";
    public static final String SEARCH_KEY = "searchKey";
    public static final String PROJECT_INFO = "projectInfo";
    @Autowired
    @Qualifier(value="mongoTemplate")
    private MongoTemplate mongoTemplate;
    @Autowired
    @Qualifier(value="mongoTemplateTenant")
    private MongoTemplate mongoTemplateUser;
    @Autowired
    private CACUtils cacUtils;
    @Autowired
    private IApplicationService applicationService;
    @Autowired
    ITenantService tenantService;
    @Autowired
    KgInnerService kgInnerService;
    @Autowired
    private MongoEntityBaseDAO mongoEntityBaseDAO;
    @Autowired
    private EocService eocService;
    @Autowired
    private IApplicationService appService;
    @Autowired
    private ATMCService atmcService;
    @Autowired
    TranslateUtils translateUtils;
    @Autowired
    @Qualifier(value="baseExecutor")
    ThreadPoolTaskExecutor executor;
    @Autowired(required=false)
    private StringRedisTemplate stringRedisTemplate;
    @Autowired
    DataPickService dataPickService;
    @Autowired
    private ActivityDAO activityDAO;
    @Autowired
    private KgService kgService;
    @Autowired
    IamService iamService;

    @Deprecated
    public Object getDefinition(String taskId) throws Exception {
        return this.getDefinitionWithMultiLanguage(taskId);
    }

    public Object getDefinitionWithMultiLanguage(String taskId, String pageCode) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("taskId", taskId);
        params.put("pageCode", pageCode);
        return this.kgService.doForwardToKg(params);
    }

    public Object getDefinitionWithMultiLanguage(String taskId) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("taskId", taskId);
        return this.kgService.doForwardToKg(params);
    }

    public Object postDefinitionWithMultiLanguage(String taskId, OperationUnit operationUnit) throws Exception {
        HashMap<String, String> query = new HashMap<String, String>();
        query.put("taskId", taskId);
        query.put("operationUnit", (String)operationUnit);
        return this.kgService.doForwardToKg(query);
    }

    @Deprecated
    public Object getActivities(String taskId) throws Exception {
        return this.getActivitiesWithMultiLanguage(taskId);
    }

    public Object getActivitiesWithMultiLanguage(String taskId) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("taskId", taskId);
        return this.kgService.doForwardToKg(params);
    }

    private static Object processLanguage(String defVal, String propName, Map<String, Map<String, String>> langMap) {
        if (langMap.get(propName) != null) {
            Map<String, String> propLangMap = langMap.get(propName);
            propLangMap.put("zh_CN", defVal);
            langMap.remove(propName);
            return propLangMap;
        }
        return defVal;
    }

    public Object getQueryItem(String condition) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("condition", condition);
        return this.kgService.doForwardToKg(params);
    }

    private List<Map> castActivityToItemMap(List<Activity> dataEntry, String localeStr, Map<String, List<String>> appCodeMap) {
        if (CollectionUtils.isEmpty(dataEntry)) {
            return new LinkedList<Map>();
        }
        LinkedList<Map> dataEntryMapList = new LinkedList<Map>();
        dataEntry.forEach(item -> {
            List appCodeList = (List)appCodeMap.get(item.getCode());
            if (!CollectionUtils.isEmpty((Collection)appCodeList)) {
                for (String appCode : appCodeList) {
                    HashMap<String, Object> itemMap = new HashMap<String, Object>(16);
                    itemMap.put("name", CollectionUtils.isEmpty((Map)item.getLang()) || CollectionUtils.isEmpty((Map)((Map)item.getLang().get("name"))) || null == ((Map)item.getLang().get("name")).get(localeStr) ? item.getName() : ((Map)item.getLang().get("name")).get(localeStr));
                    itemMap.put("type", "Activity");
                    itemMap.put("code", item.getCode());
                    itemMap.put("pattern", item.getPattern());
                    itemMap.put("subReport", BooleanUtils.toBoolean((Boolean)item.getSubReport()));
                    itemMap.put("ifCommon", "false");
                    itemMap.put("category", item.getCategory());
                    itemMap.put("appCode", appCode);
                    itemMap.put("ifCustom", false);
                    dataEntryMapList.add(itemMap);
                }
            }
        });
        return dataEntryMapList;
    }

    private List<Map> castActivityToItemMap(List<Activity> dataEntry, String localeStr, Map<String, List<String>> appCodeMap, List<String> tbbIfCustom) {
        if (CollectionUtils.isEmpty(dataEntry)) {
            return new LinkedList<Map>();
        }
        LinkedList<Map> dataEntryMapList = new LinkedList<Map>();
        dataEntry.forEach(item -> {
            List appCodeList = (List)appCodeMap.get(item.getCode());
            for (String appCode : appCodeList) {
                HashMap<String, Object> itemMap = new HashMap<String, Object>(16);
                itemMap.put("name", null == item.getLang() || item.getLang().isEmpty() || null == item.getLang().get("name") || null == ((Map)item.getLang().get("name")).get(localeStr) ? item.getName() : ((Map)item.getLang().get("name")).get(localeStr));
                itemMap.put("type", "Activity");
                itemMap.put("code", item.getCode());
                itemMap.put("pattern", item.getPattern());
                itemMap.put("subReport", BooleanUtils.toBoolean((Boolean)item.getSubReport()));
                itemMap.put("ifCommon", "false");
                itemMap.put("category", item.getCategory());
                itemMap.put("appCode", appCode);
                itemMap.put("ifCustom", tbbIfCustom.contains(item.getCode()));
                dataEntryMapList.add(itemMap);
            }
        });
        return dataEntryMapList;
    }

    private List<Map> castDataMapTaskToItemMap(List manualDataMapProject, String localeStr) {
        if (CollectionUtils.isEmpty((Collection)manualDataMapProject)) {
            return Collections.EMPTY_LIST;
        }
        List originalMap = JSON.parseArray((String)JSON.toJSONString((Object)manualDataMapProject), Map.class);
        LinkedList<Map> dataEntryMapList = new LinkedList<Map>();
        originalMap.forEach(item -> {
            HashMap<String, String> itemMap = new HashMap<String, String>(8);
            itemMap.put("name", (String)item.get("name"));
            itemMap.put("type", "Task");
            itemMap.put("code", (String)item.get("code"));
            itemMap.put("pattern", null == item.get("pattern") ? null : (String)item.get("pattern"));
            dataEntryMapList.add(itemMap);
        });
        return dataEntryMapList;
    }

    private List<Map> castTaskToItemMap(List<Task> manualProject, String localeStr) {
        if (CollectionUtils.isEmpty(manualProject)) {
            return Collections.emptyList();
        }
        LinkedList<Map> dataEntryMapList = new LinkedList<Map>();
        manualProject.forEach(item -> {
            HashMap<String, String> itemMap = new HashMap<String, String>(8);
            itemMap.put("name", null == item.getLang() || item.getLang().isEmpty() || null == item.getLang().get("name") || null == ((Map)item.getLang().get("name")).get(localeStr) ? item.getName() : (String)((Map)item.getLang().get("name")).get(localeStr));
            itemMap.put("type", "Task");
            itemMap.put("code", item.getCode());
            itemMap.put("pattern", item.getPattern());
            dataEntryMapList.add(itemMap);
        });
        return dataEntryMapList;
    }

    public Object getActivityNamesByCode(String activityCode) throws Exception {
        String tenantId = AthenaUtils.getTenantId();
        String tenantVersion = this.kgInnerService.getTenantVersion(tenantId);
        String loc_zh_CN = "zh_CN";
        String loc_zh_TW = "zh_TW";
        String loc_en_US = "en_US";
        String loc_default = "default";
        String key = "name";
        Activity activity = (Activity)this.dataPickService.chooseOneWithSameCode(this.activityDAO.getActivityByCodeAndVersion(activityCode, tenantVersion, tenantId));
        HashMap<String, String> lang = new HashMap<String, String>();
        if (null == activity) {
            return lang;
        }
        lang.put("default", activity.getName());
        if (null != activity.getLang() && !activity.getLang().isEmpty()) {
            String en_US = (String)((Map)activity.getLang().get("name")).get("en_US");
            String zh_TW = (String)((Map)activity.getLang().get("name")).get("zh_TW");
            String zh_CN = (String)((Map)activity.getLang().get("name")).get("zh_CN");
            if (!StringUtils.isEmpty((CharSequence)en_US)) {
                lang.put("en_US", en_US);
            }
            if (!StringUtils.isEmpty((CharSequence)zh_TW)) {
                lang.put("zh_TW", zh_TW);
            }
            if (!StringUtils.isEmpty((CharSequence)zh_CN)) {
                lang.put("zh_CN", zh_CN);
            }
        }
        return lang;
    }

    public Object postTenantTBBReportsByProductCode(TBBReportReplacer reportReplacer) throws Exception {
        String tenantVersion = this.kgInnerService.getTenantVersion(reportReplacer.getTenantId());
        this.clearTenantTBBReportsByProductCode(reportReplacer.getProductCode(), reportReplacer.getTenantId(), tenantVersion);
        reportReplacer.setVersion(tenantVersion);
        this.writeNewReportToDB(reportReplacer);
        return null;
    }

    private void clearTenantTBBReportsByProductCode(String productCode, String tenantId, String tenantVersion) throws DWBusinessException {
        Query queryUser = new Query();
        Criteria criteriaUser = Criteria.where((String)"tenantId").is((Object)tenantId).and("version").is((Object)tenantVersion).and("productCode").is((Object)productCode);
        queryUser.addCriteria((CriteriaDefinition)criteriaUser);
        this.mongoTemplateUser.remove(queryUser, "tbbReports");
    }

    private void writeNewReportToDB(TBBReportReplacer reportReplaceDO) {
        this.mongoTemplateUser.insert((Object)reportReplaceDO, "tbbReports");
    }

    public Object getTBBReports(String mode, String productCode) throws Exception {
        List activityDataEntryVOS;
        switch (mode) {
            case "pc": {
                activityDataEntryVOS = (List)this.getActivitiesByPattern("STATEMENT");
                break;
            }
            case "mobile": {
                activityDataEntryVOS = (List)this.getActivitiesByPattern("MOBI-STATEMENT");
                break;
            }
            default: {
                activityDataEntryVOS = (List)this.getActivitiesByPattern("STATEMENT");
            }
        }
        if (CollectionUtils.isEmpty((Collection)activityDataEntryVOS)) {
            return Collections.EMPTY_LIST;
        }
        activityDataEntryVOS = activityDataEntryVOS.stream().filter(activity -> activity.getAppCode() != null && activity.getAppCode().equals(productCode)).collect(Collectors.toList());
        return activityDataEntryVOS;
    }

    public Object getBaseDataApplication() throws Exception {
        return this.kgService.doForwardToKg(new HashMap());
    }

    public Object getActivitiesInfoByPattern() throws Exception {
        return this.kgService.doForwardToKg(new HashMap());
    }

    private void filterUc(List<Activity> activities, String tenantId) {
        Iterator<Activity> activityIterator = activities.iterator();
        ArrayList<String> ucCodes = new ArrayList<String>();
        while (activityIterator.hasNext()) {
            Activity activity = activityIterator.next();
            if (null == activity.getInclusionTenant()) continue;
            if (!activity.getInclusionTenant().contains(tenantId)) {
                activityIterator.remove();
                continue;
            }
            if (!activity.getCode().startsWith("UC_")) continue;
            ucCodes.add(activity.getCode().replace("UC_", ""));
        }
    }

    public Object getActivitiesByPattern(String pattern) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("pattern", pattern);
        return this.kgService.doForwardToKg(params);
    }

    public List<ExportAndImportConfig> getExportAndImportConfig() throws Exception {
        return (List)this.kgService.doForwardToKg(new HashMap());
    }

    private Set<String> getCommonAppsIncludedItems(Map<String, List<ApplicationRelation>> applicationRelationsMap) {
        Set appIdSet = this.getCommonAppIds(applicationRelationsMap);
        Set<String> commonAppsIncludedItems = Collections.emptySet();
        if (!CollectionUtils.isEmpty((Collection)appIdSet)) {
            commonAppsIncludedItems = new HashSet<String>(this.iamService.appItems(new ArrayList(appIdSet)));
        }
        Set<String> finalCommonAppsIncludedItems = commonAppsIncludedItems;
        return finalCommonAppsIncludedItems;
    }

    private Set<String> getCommonAppIds(Map<String, List<ApplicationRelation>> applicationRelationsMap) {
        HashSet<String> commonAppIds = new HashSet<String>();
        applicationRelationsMap.forEach((k, v) -> {
            ApplicationRelation applicationRelation = (ApplicationRelation)v.get(0);
            if (applicationRelation.getCommonApp().booleanValue()) {
                commonAppIds.add(applicationRelation.getAppCode());
            }
        });
        return commonAppIds;
    }

    public Object getActivitiesByPatternAndAppCode(String pattern, String appCode) throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("pattern", pattern);
        map.put("appCode", appCode);
        return this.kgService.doForwardToKg(map);
    }

    private void handleTBBTenantReports(String pattern, String tenantId, String tenantVersion, List<Activity> activities, Map<String, String> tbbCodeApplicationMap) {
        Query queryUser = new Query();
        Criteria criteriaUser = Criteria.where((String)"tenantId").is((Object)tenantId).and("version").is((Object)tenantVersion);
        queryUser.addCriteria((CriteriaDefinition)criteriaUser);
        List tbbReportReplacers = this.mongoTemplateUser.find(queryUser, TBBReportReplacer.class, "tbbReports");
        LinkedList tbbActivities = new LinkedList();
        HashSet replaceIdSet = new HashSet();
        if (!CollectionUtils.isEmpty((Collection)tbbReportReplacers)) {
            tbbReportReplacers.forEach(item -> item.getReports().forEach(itemj -> {
                if (pattern.equals("STATEMENT") && itemj.getMode().equals("pc") || pattern.equals("MOBI-STATEMENT") && itemj.getMode().equals("mobile")) {
                    Activity activity = new Activity();
                    activity.setCode(itemj.getId());
                    HashMap<String, Map> langMap = new HashMap<String, Map>();
                    langMap.put("name", itemj.getName());
                    activity.setLang(langMap);
                    tbbCodeApplicationMap.put(itemj.getId(), item.getProductCode());
                    if (!StringUtils.isEmpty((CharSequence)itemj.getReplaceId())) {
                        replaceIdSet.add(itemj.getReplaceId());
                    }
                    tbbActivities.add(activity);
                }
            }));
        }
        activities = !CollectionUtils.isEmpty(activities) ? activities.stream().filter(activity -> !replaceIdSet.contains(activity.getCode())).collect(Collectors.toList()) : new LinkedList<Activity>();
        if (!CollectionUtils.isEmpty(tbbActivities)) {
            tbbActivities.forEach(tbbActivity -> tbbActivity.setCategory("STATEMENT"));
            activities.addAll(tbbActivities);
        }
    }

    public Object getActivitiesAndSortByPattern(String pattern) throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("pattern", pattern);
        return this.kgService.doForwardToKg(map);
    }

    private void filterComponentByCode(List<ActivityDataEntryVO> activitiesByPattern, String pattern) throws DWBusinessException {
    }

    public List<ActivityDataEntryVO> postActivitiesGroup(List<ActivityDataEntryVO> requestList) throws Exception {
        log.info("start postActivitiesGroup:{}", (Object)System.currentTimeMillis());
        String tenantId = AthenaUtils.getTenantId();
        String tenantVersion = this.kgInnerService.getTenantVersion(tenantId);
        String lang = AthenaUtils.getCurrentLocale();
        for (ActivityDataEntryVO vo : requestList) {
            ApplicationGroup applicationGroup;
            Criteria criteria;
            if (!StringUtils.isEmpty((CharSequence)vo.getGroupCode())) {
                criteria = new Criteria();
                criteria.and("appCode").exists(false).and("groupCode").is((Object)vo.getGroupCode()).and("version").is((Object)tenantVersion);
                applicationGroup = (ApplicationGroup)this.mongoTemplate.findOne(new Query((CriteriaDefinition)criteria), ApplicationGroup.class);
            } else {
                criteria = new Criteria();
                criteria.and("appCode").is((Object)vo.getAppCode()).and("activityCode").is((Object)vo.getCode()).and("version").is((Object)tenantVersion);
                applicationGroup = (ApplicationGroup)this.mongoTemplate.findOne(new Query((CriteriaDefinition)criteria), ApplicationGroup.class);
                if (null != applicationGroup) {
                    vo.setGroupCode(applicationGroup.getGroupCode());
                }
            }
            if (null == applicationGroup || null == applicationGroup.getLang()) continue;
            vo.setGroupSort(StringUtils.isEmpty((CharSequence)applicationGroup.getGroupSort()) ? null : applicationGroup.getGroupSort());
            HashMap nameLangMap = (HashMap)applicationGroup.getLang().get("groupName");
            if (null == nameLangMap) {
                nameLangMap = applicationGroup.getLang().get("name") == null ? new HashMap() : (Map)applicationGroup.getLang().get("name");
            }
            String language = null == nameLangMap.get(lang) ? applicationGroup.getGroupName() : (String)nameLangMap.get(lang);
            vo.setGroupName(null == language ? applicationGroup.getGroupName() : language);
        }
        log.info("end postActivitiesGroup:{}", (Object)System.currentTimeMillis());
        return requestList;
    }

    private Map<String, Boolean> getActivityHasGroundEnd(List<Activity> activities) {
        if (CollectionUtils.isEmpty(activities)) {
            return new HashMap<String, Boolean>();
        }
        ArrayList allActivityList = new ArrayList();
        Map<String, List<Activity>> groupByVersionActivityMap = activities.stream().collect(Collectors.groupingBy(e -> e.getVersion() == null ? "" : e.getVersion()));
        Set<Map.Entry<String, List<Activity>>> entries = groupByVersionActivityMap.entrySet();
        for (Map.Entry<String, List<Activity>> entry : entries) {
            List<Activity> value = entry.getValue();
            List activityCodeList = value.stream().map(BaseEntity::getCode).collect(Collectors.toList());
            Query query = Query.query((CriteriaDefinition)Criteria.where((String)"code").in(activityCodeList).and("version").is((Object)entry.getKey()));
            query.fields().include("code").include("dependOnGroundEnd");
            List activityConfig = this.mongoTemplate.find(query, Activity.class, "activityConfigs");
            if (CollectionUtils.isEmpty((Collection)activityConfig)) continue;
            allActivityList.addAll(activityConfig);
        }
        Map<String, Boolean> resultMap = allActivityList.stream().collect(Collectors.toMap(BaseEntity::getCode, e -> BooleanUtils.toBoolean((Boolean)e.getDependOnGroundEnd()), (a, b) -> a));
        return resultMap;
    }

    private boolean isCardCustom(FunctionCtrl functionCtrl) {
        return functionCtrl != null && (functionCtrl.isProjectCardCustomizeFlag() || functionCtrl.isTaskCardCustomizeFlag());
    }

    public Object getActivityDefinition(String activityId, String pageCode) throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("activityId", activityId);
        map.put("pageCode", pageCode);
        return this.kgService.doForwardToKg(map);
    }

    private void dealReportSort(Activity activity, List<Map<String, Object>> sortData) {
        Map pages;
        if (activity != null && null != (pages = activity.getPages()) && !CollectionUtils.isEmpty((Collection)((List)pages.get("layout")))) {
            List layoutList = (List)pages.get("layout");
            for (Map layout : layoutList) {
                if (!"FORM_LIST".equals(layout.get("type"))) continue;
                TaskServiceImpl.processGroup((Map)layout, sortData);
            }
        }
    }

    private static void processGroup(Map<String, Object> layout, List<Map<String, Object>> sortData) {
        List group = (List)layout.get("group");
        if (group != null) {
            Optional<Map> sortItemOpt = sortData.stream().filter(item -> ((String)layout.get("id")).equals(item.get("id"))).findFirst();
            if (sortItemOpt.isPresent()) {
                Map sortIndexMap = TaskServiceImpl.createSortIndexMap((Map)sortItemOpt.get());
                group.sort(Comparator.comparingInt(item -> {
                    String pathSchema = (String)item.get("path") + ";" + item.get("schema");
                    return sortIndexMap.getOrDefault(pathSchema, 99999);
                }));
            }
            group.forEach(subItem -> {
                if ("FORM_LIST".equals(subItem.get("type"))) {
                    TaskServiceImpl.processGroup((Map)subItem, (List)sortData);
                }
            });
        }
    }

    public static Map<String, Integer> createSortIndexMap(Map<String, Object> sortItem) {
        List sortFields = (List)sortItem.get("sortField");
        if (sortFields == null) {
            return new HashMap<String, Integer>();
        }
        return sortFields.stream().collect(Collectors.toMap(field -> field, field -> sortFields.indexOf(field), (existingValue, newValue) -> existingValue));
    }

    private void processSysSummaryFields(Activity activity) {
        Map pages;
        if (null != activity && !CollectionUtils.isEmpty((Map)(pages = activity.getPages()))) {
            List dataStates = (List)pages.get("dataStates");
            if (!CollectionUtils.isEmpty((Collection)dataStates)) {
                dataStates.forEach(dataState -> {
                    if ("summary".equals(dataState.get("type"))) {
                        activity.setSummary(dataState);
                        activity.setSummaryFields((List)dataState.get("fieldMappings"));
                    }
                    if ("businessInfo".equals(dataState.get("type"))) {
                        activity.setBusinessInfo(dataState);
                    }
                    if ("searchKey".equals(dataState.get("type"))) {
                        activity.setSearchKey(dataState);
                    }
                    if ("projectInfo".equals(dataState.get("type"))) {
                        activity.setProjectInfo(dataState);
                    }
                });
                if (!this.checkNewSummary(activity)) {
                    List summaryFields = (List)((Map)dataStates.get(0)).get("summaryFields");
                    activity.setSummaryFields(summaryFields);
                }
            } else {
                List summaryFieldsCandidate = (List)pages.get("summaryFields");
                if (!CollectionUtils.isEmpty((Collection)summaryFieldsCandidate)) {
                    activity.setSummaryFields(summaryFieldsCandidate);
                }
            }
        }
    }

    private boolean checkNewSummary(Activity activity) {
        return !CollectionUtils.isEmpty((Map)activity.getSummary()) || !CollectionUtils.isEmpty((Map)activity.getBusinessInfo()) || !CollectionUtils.isEmpty((Map)activity.getSearchKey()) || !CollectionUtils.isEmpty((Map)activity.getProjectInfo());
    }

    private void processApplication(String activityId, Activity activity) throws DWBusinessException {
        if (null != activity) {
            ApplicationRelation applicationRelation = this.applicationService.getApplicationByTypeAndCode("activity", activityId, AthenaUtils.getCurrentLocale());
            if (null != applicationRelation) {
                activity.setApplication(applicationRelation.getAppCode());
                activity.setAppName(applicationRelation.getAppName());
            }
            activity.setActivityId(activityId);
            activity.setActivityName((Object)activity.getName());
            activity.getLang().put("activityName", activity.getLang().get("name"));
        }
    }

    private List<Map<String, Object>> mergeSummaryFields(List<Map<String, Object>> summaryFields, List<Map<String, Object>> transformedTenantSummaryFields) {
        if (CollectionUtils.isEmpty(summaryFields)) {
            return transformedTenantSummaryFields;
        }
        ArrayList<Map<String, Object>> mergedSummaryFields = new ArrayList<Map<String, Object>>();
        mergedSummaryFields.addAll(transformedTenantSummaryFields);
        mergedSummaryFields.addAll(summaryFields.stream().filter(map -> MapUtils.getBoolean((Map)map, (Object)"summary", (Boolean)true) == false).collect(Collectors.toList()));
        return mergedSummaryFields;
    }

    private List<Map<String, Object>> transformTenantFieldsToSys(TenantSummaryFields tenantSummaryFields, List<Map<String, Object>> summaryFields) {
        List tenantSummaryFieldList = tenantSummaryFields.getSummaryFields();
        if (!CollectionUtils.isEmpty((Collection)tenantSummaryFieldList)) {
            ArrayList<Map<String, Object>> sysSummaryFields = new ArrayList<Map<String, Object>>(6);
            for (int i = 0; i < tenantSummaryFieldList.size(); ++i) {
                List values = ((TenantSummaryField)tenantSummaryFieldList.get(i)).getValue();
                for (int j = 0; j < values.size(); ++j) {
                    String fieldPath = (String)values.get(j);
                    Optional<Map> first = summaryFields.stream().filter(map -> fieldPath.equals(MapUtil.getStr((Map)map, (Object)"value"))).findFirst();
                    Map sysSummaryField = Maps.newHashMap();
                    if (first.isPresent()) {
                        sysSummaryField = first.get();
                    }
                    Map sysSummaryFieldCopy = (Map)ObjectUtil.cloneByStream((Object)sysSummaryField);
                    sysSummaryFieldCopy.put("summary", true);
                    sysSummaryFieldCopy.put("actionId", tenantSummaryFields.getActionId());
                    sysSummaryFieldCopy.put("value", fieldPath);
                    ArrayList tagList = new ArrayList(1);
                    HashMap<String, Object> tag = new HashMap<String, Object>();
                    tag.put("code", "group_" + i);
                    tag.put("title", ((TenantSummaryField)tenantSummaryFieldList.get(i)).getTitle());
                    tag.put("customTitle", true);
                    if (StringUtils.isEmpty((CharSequence)MapUtils.getString((Map)sysSummaryFieldCopy, (Object)"description"))) {
                        sysSummaryFieldCopy.put("description", ((TenantSummaryField)tenantSummaryFieldList.get(i)).getTitle());
                        sysSummaryFieldCopy.put("data_type", "string");
                        sysSummaryFieldCopy.put("data_name", fieldPath.contains(".") ? fieldPath.split("\\.")[1] : fieldPath);
                    }
                    if (!tag.containsKey("lang")) {
                        JSONObject lang = new JSONObject();
                        JSONObject titleLang = new JSONObject();
                        titleLang.fluentPut("zh_CN", (Object)((TenantSummaryField)tenantSummaryFieldList.get(i)).getTitle()).fluentPut("zh_TW", (Object)((TenantSummaryField)tenantSummaryFieldList.get(i)).getTitle()).fluentPut("en_US", (Object)((TenantSummaryField)tenantSummaryFieldList.get(i)).getTitle());
                        lang.put("title", (Object)titleLang);
                        tag.put("lang", lang);
                    }
                    tagList.add(tag);
                    sysSummaryFieldCopy.put("tags", tagList);
                    sysSummaryFields.add(sysSummaryFieldCopy);
                }
            }
            return sysSummaryFields;
        }
        return summaryFields;
    }

    private TenantSummaryFieldsDto transformToTenantSummaryFieldsDTO(TenantSummaryFields tenantSummaryFields) {
        return (TenantSummaryFieldsDto)JSON.parseObject((String)JSON.toJSONString((Object)tenantSummaryFields), TenantSummaryFieldsDto.class);
    }

    private boolean judgeIfUseTenantSummaryFields(TenantSummaryFields tenantSummaryFields, List<Map<String, Object>> summaryFields) {
        if (null == tenantSummaryFields) {
            return false;
        }
        if (CollectionUtils.isEmpty(summaryFields)) {
            return false;
        }
        return summaryFields.get(0).get("actionId").equals(tenantSummaryFields.getActionId());
    }

    private boolean judgeIfUseTenantTitle(TenantSummaryFields tenantSummaryFields) {
        if (null == tenantSummaryFields) {
            return false;
        }
        String titlePrefix = tenantSummaryFields.getTitlePrefix();
        List title = tenantSummaryFields.getTitle();
        return !CollectionUtils.isEmpty((Collection)title) || !StringUtils.isEmpty((CharSequence)titlePrefix);
    }

    public Object getActivityDefinition(String taskId, String activityId, String pageCode) throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("taskId", taskId);
        map.put("activityId", activityId);
        map.put("pageCode", pageCode);
        return this.kgService.doForwardToKg(map);
    }

    private void handleReminderRule(Activity activity) {
        ReminderRule reminderRule = activity.getReminderRule();
        if (reminderRule != null && CollectionUtils.isEmpty((Collection)reminderRule.getRules())) {
            String currentLocale = AthenaUtils.getCurrentLocale();
            String titlePrefix = "\u89c4\u5219";
            if ("zh_TW".equals(currentLocale)) {
                titlePrefix = "\u898f\u5247";
            } else if ("en_US".equals(currentLocale)) {
                titlePrefix = "rule";
            }
            HashMap<String, Object> rule = new HashMap<String, Object>();
            rule.put("aheadTime", reminderRule.getAheadTime());
            rule.put("notices", reminderRule.getNotices());
            rule.put("rule", reminderRule.getRule());
            rule.put("title", titlePrefix + "1");
            rule.put("identities", Collections.emptyList());
            reminderRule.setRules(Collections.singletonList(rule));
            reminderRule.setRule(null);
            reminderRule.setNotices(null);
            reminderRule.setAheadTime(null);
        }
        if (reminderRule != null && !CollectionUtils.isEmpty((Collection)reminderRule.getRules())) {
            for (Map ruleItem : reminderRule.getRules()) {
                Map map = MapUtils.getMap((Map)ruleItem, (Object)"rule", Collections.emptyMap());
                String ruleType = MapUtils.getString((Map)map, (Object)"rule");
                if ("count".equals(ruleType)) {
                    map.put("interval", null);
                    continue;
                }
                map.put("count", null);
            }
        }
    }

    private void processMergeRule(Activity activity, String taskId, String activityId, FunctionCtrl functionCtrl) throws Exception {
        boolean enableCustomize;
        boolean bl = enableCustomize = null == functionCtrl ? false : functionCtrl.isTaskCardMergeCustomizeFlag();
        if (!enableCustomize) {
            return;
        }
        Map activityConfig = (Map)this.getActivityConfig(taskId, activityId);
        MergeRule mergeRule = (MergeRule)this.getTenantMergeConfig("task", activityId);
        if (null == mergeRule || mergeRule.getDelete().booleanValue()) {
            return;
        }
        activity.setMerge(mergeRule.getMerge());
        Map mergeConfig = MergeRule.convertToMergeConfig((List)mergeRule.getMergeRules(), (Map)activityConfig);
        activity.getConfig().put("mergeConfig", mergeConfig);
    }

    private boolean judgeUseMergeAbility(Map<String, Object> config, Boolean merge) {
        boolean mergeB = merge;
        Map mergeConfig = (Map)config.get("mergeConfig");
        if (!CollectionUtils.isEmpty((Map)mergeConfig)) {
            List fieldMeta = (List)mergeConfig.get("fieldMeta");
            if (mergeB && !CollectionUtils.isEmpty((Collection)fieldMeta)) {
                return true;
            }
        }
        return false;
    }

    public Object getActivityConfig(String taskId, String activityId) throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("taskId", taskId);
        map.put("activityId", activityId);
        return this.kgService.doForwardToKg(map);
    }

    public Object getTenantMergeConfig(String type, String code) throws Exception {
        String tenantId = AthenaUtils.getTenantId();
        String tenantVersion = this.kgInnerService.getTenantVersion(tenantId);
        Query queryUser = new Query();
        Criteria criteria = Criteria.where((String)"type").is((Object)type).and("code").is((Object)code).and("tenantId").is((Object)tenantId).and("version").is((Object)tenantVersion);
        queryUser.addCriteria((CriteriaDefinition)criteria);
        MergeRule mergeRule = (MergeRule)this.mongoTemplateUser.findOne(queryUser, MergeRule.class);
        return mergeRule;
    }

    public Object postTenantMergeRule(MergeRule mergeRule) throws Exception {
        HashMap<String, MergeRule> query = new HashMap<String, MergeRule>();
        query.put("mergeRule", mergeRule);
        return this.kgService.doForwardToKg(query);
    }

    public Object postDeleteTenantMergeRule(String type, String code, String application) throws Exception {
        HashMap<String, String> query = new HashMap<String, String>();
        query.put("type", type);
        query.put("code", code);
        query.put("application", application);
        return this.kgService.doForwardToKg(query);
    }

    public Object postActivityDefinition(String taskId, String activityId, String pageCode, OperationUnit operationUnit) throws Exception {
        HashMap<String, String> query = new HashMap<String, String>();
        query.put("taskId", taskId);
        query.put("activityId", activityId);
        query.put("pageCode", pageCode);
        query.put("operationUnit", (String)operationUnit);
        return this.kgService.doForwardToKg(query);
    }

    public Object getActivityStartTargetCode(String taskId, String activityId, String pageCode) throws Exception {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("projectCode", taskId);
        param.put("taskCode", activityId);
        return this.kgService.doForwardToKg(param);
    }

    public Object getTaskInfoFromDataMap(String activityId) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("activityId", activityId);
        return this.kgService.doForwardToKg(param);
    }

    public Object getActivityDefinitionWithMultiLanguage(String taskId, String activityId, String tenantId) throws Exception {
        return null;
    }

    public Object getManualList() throws DWBusinessException {
        return this.kgService.doForwardToKg(new HashMap());
    }

    public Object getManualListBasic() throws DWBusinessException {
        return null;
    }

    private String getTaskCode(Object object) {
        JSONObject jsonObject = JSON.parseObject((String)JSON.toJSONString((Object)object));
        String code = jsonObject.getString("code");
        return code;
    }

    public Object getDetail(String taskId) throws DWBusinessException {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("taskId", taskId);
        return this.kgService.doForwardToKg(param);
    }

    public Object getInputData(String taskId) throws DWBusinessException {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("taskId", taskId);
        return this.kgService.doForwardToKg(param);
    }

    public Object getSolvePlan(String taskId, String activityId) throws DWBusinessException {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("taskId", taskId);
        param.put("activityId", activityId);
        return this.kgService.doForwardToKg(param);
    }

    public Object getSolvePlan(String activityId) throws DWBusinessException {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("activityId", activityId);
        return this.kgService.doForwardToKg(param);
    }

    public Object getSolvePlanByData(String dataName) throws DWBusinessException {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("dataName", dataName);
        return this.kgService.doForwardToKg(param);
    }

    public Object getActivitiesWithMultiLanguage(String taskId, String compositionId) throws Exception {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("taskId", taskId);
        param.put("compositionId", compositionId);
        return this.kgService.doForwardToKg(param);
    }

    public Object getAllTasks() throws DWBusinessException {
        HashMap param = new HashMap();
        return this.kgService.doForwardToKg(param);
    }

    public Object getAppSubscription(String taskId) throws DWBusinessException {
        String tenantId = AthenaUtils.getTenantId();
        List relations = this.applicationService.getAppCodeByTaskCode(taskId);
        AppSubscription appSubscription = new AppSubscription();
        if (relations.size() > 0) {
            ApplicationRelation first = (ApplicationRelation)relations.get(0);
            appSubscription.setAppId(first.getAppCode());
            appSubscription.setName(first.getAppName());
            appSubscription.setTenantId(tenantId);
            appSubscription.setTaskId(taskId);
        }
        return appSubscription;
    }

    private void batchMapSetActionMap(Map<String, Object> data, String tenantId, List<Map<String, Object>> actionMap) {
        if (CollectionUtils.isEmpty(data)) {
            return;
        }
        actionMap.add(data);
        for (Map.Entry<String, Object> item : data.entrySet()) {
            Object value = item.getValue();
            if (value instanceof Map) {
                this.batchMapSetActionMap((Map)value, tenantId, actionMap);
                continue;
            }
            if (!(value instanceof List)) continue;
            this.batchListSetActionMap((List)value, tenantId, actionMap);
        }
    }

    private void batchListSetActionMap(List data, String tenantId, List<Map<String, Object>> actionMap) {
        if (CollectionUtils.isEmpty((Collection)data)) {
            return;
        }
        for (Object item : data) {
            if (item instanceof Map) {
                this.batchMapSetActionMap((Map)item, tenantId, actionMap);
                continue;
            }
            if (!(item instanceof List)) continue;
            this.batchListSetActionMap((List)item, tenantId, actionMap);
        }
    }

    private Task findTaskConfig(String tenantId, String taskCode, String taskVersion) {
        String tenantVersion = this.kgInnerService.getTenantVersion(tenantId);
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"code").is((Object)taskCode).and("version").is((Object)taskVersion));
        Task defTask = (Task)this.mongoTemplate.findOne(query, Task.class, "taskConfigs");
        Query query1 = Query.query((CriteriaDefinition)Criteria.where((String)"code").is((Object)taskCode).and("version").is((Object)taskVersion).and("tenantId").is((Object)tenantId));
        Task tenantTask = (Task)this.mongoTemplateUser.findOne(query1, Task.class, "taskConfigs");
        if (defTask != null) {
            if (tenantTask != null) {
                AthenaUtils.mergeObject((Object)tenantTask, (Object)defTask);
            }
            return defTask;
        }
        return tenantTask;
    }

    @Deprecated
    public Object postUpdateTaskConfig(Task data) throws DWBusinessException {
        HashMap<String, Task> map = new HashMap<String, Task>();
        map.put("data", data);
        return this.kgService.doForwardToKg(map);
    }

    public Object postUpdateTaskConfig(Task data, OperationUnit operationUnit) throws DWBusinessException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("data", data);
        map.put("operationUnit", operationUnit);
        return this.kgService.doForwardToKg(map);
    }

    public Object postQueryRelatedTask(String tenantId, String activityId) throws Exception {
        Map app;
        String appId;
        String tenantVersion = this.kgInnerService.getTenantVersion(tenantId);
        if (tenantId == null || tenantId.isEmpty()) {
            throw new DWBusinessException(I18nUtils.getValue((String)"knowledgegraph.tenantIdEmpty"));
        }
        if (activityId == null || activityId.isEmpty()) {
            throw new DWBusinessException(I18nUtils.getValue((String)"knowledgegraph.activityIdEmpty"));
        }
        HashMap<String, String> keyConditions = new HashMap<String, String>();
        keyConditions.put("code", activityId);
        ActivityConfig config = (ActivityConfig)this.dataPickService.findByCode(activityId, ActivityConfig.class, "activityConfigs");
        if (config.getRelatedTasks() != null && config.getRelatedTasks().size() > 0 && StringUtils.isNotEmpty((CharSequence)(appId = (String)(app = (Map)config.getRelatedTasks().get(0)).get("appId"))) && this.cacUtils.getAppAuth(tenantId, appId).booleanValue()) {
            return app.get("taskCode");
        }
        return null;
    }

    public Object getTaskByApp(String applicationCode) throws Exception {
        HashMap<String, String> query = new HashMap<String, String>();
        query.put("applicationCode", applicationCode);
        return this.kgService.doForwardToKg(query);
    }

    public Object postTaskByApp(String applicationCode, OperationUnit operationUnit) throws Exception {
        HashMap<String, String> query = new HashMap<String, String>();
        query.put("applicationCode", applicationCode);
        query.put("operationUnit", (String)operationUnit);
        return this.kgService.doForwardToKg(query);
    }

    public Object postFixTask(String taskId, OperationUnit operationUnit) throws Exception {
        HashMap<String, String> query = new HashMap<String, String>();
        query.put("taskId", taskId);
        query.put("operationUnit", (String)operationUnit);
        return this.kgService.doForwardToKg(query);
    }

    public Object getReportsByBizCodeNType(String bizCode, Integer type) throws Exception {
        return this.getReportsByBizCodeNType(bizCode, type, null);
    }

    public Object getReportsByBizCodeNType(String bizCode, Integer type, String userId) throws Exception {
        HashMap<String, Object> query = new HashMap<String, Object>();
        query.put("bizCode", bizCode);
        query.put("type", type);
        query.put("userId", userId);
        return this.kgService.doForwardToKg(query);
    }

    @Deprecated
    public Object getDataEntryByBizCodeNType(String code, Integer type) throws Exception {
        HashMap<String, Object> query = new HashMap<String, Object>();
        query.put("code", code);
        query.put("type", type);
        return this.kgService.doForwardToKg(query);
    }

    public Object getReportByBizCodeNTypeNReportCode(String bizCode, Integer type, String reportCode) throws Exception {
        HashMap<String, Object> query = new HashMap<String, Object>();
        query.put("bizCode", bizCode);
        query.put("type", type);
        query.put("reportCode", reportCode);
        return this.kgService.doForwardToKg(query);
    }

    public Object getBizsByReportCodeNType(String reportCode, Integer type) throws Exception {
        HashMap<String, Object> query = new HashMap<String, Object>();
        query.put("reportCode", reportCode);
        query.put("type", type);
        return this.kgService.doForwardToKg(query);
    }

    public Object postAuthorityConfigs(List<String> taskIdList) throws Exception {
        HashMap<String, List<String>> query1 = new HashMap<String, List<String>>();
        query1.put("taskIdList", taskIdList);
        return this.kgService.doForwardToKg(query1);
    }

    public Object postActivityDefinitionList(String taskId, Set<String> activityIds, String pageCode) throws Exception {
        return this.postActivityDefinitionList(taskId, activityIds, pageCode, null);
    }

    public Object postActivityDefinitionList(String taskId, Set<String> activityIds, String pageCode, OperationUnit operationUnit) throws Exception {
        HashMap<String, Object> query = new HashMap<String, Object>();
        query.put("taskId", taskId);
        query.put("activityIds", activityIds);
        query.put("pageCode", pageCode);
        query.put("operationUnit", operationUnit);
        return this.kgService.doForwardToKg(query);
    }

    public Object postQueryTaskAndActivityInfo() throws Exception {
        return this.kgService.doForwardToKg(new HashMap());
    }

    public Object postQueryAllProjectAndTaskInfo() {
        HashMap query = new HashMap();
        return this.kgService.doForwardToKg(query);
    }

    public Object postTenantSummaryFields(TenantSummaryFieldsDto tenantSummaryFields) throws Exception {
        HashMap<String, TenantSummaryFieldsDto> query = new HashMap<String, TenantSummaryFieldsDto>();
        query.put("tenantSummaryFields", tenantSummaryFields);
        return this.kgService.doForwardToKg(query);
    }

    private TenantSummaryFields transformToTenantSummaryFieldsPO(TenantSummaryFieldsDto tenantSummaryFields) {
        return (TenantSummaryFields)JSON.parseObject((String)JSON.toJSONString((Object)tenantSummaryFields), TenantSummaryFields.class);
    }

    public Object deleteTenantSummaryFields(TenantSummaryFieldsDto tenantSummaryFields) throws Exception {
        HashMap<String, TenantSummaryFieldsDto> query = new HashMap<String, TenantSummaryFieldsDto>();
        query.put("tenantSummaryFields", tenantSummaryFields);
        return this.kgService.doForwardToKg(query);
    }

    private TenantSummaryFields queryTenantSummaryFields(String application, String type, String code) throws DWBusinessException {
        String tenantId = AthenaUtils.getTenantId();
        Query queryUser = new Query();
        Criteria criteriaUser = Criteria.where((String)"tenantId").is((Object)tenantId).and("type").is((Object)type).and("code").is((Object)code).and("application").is((Object)application);
        queryUser.addCriteria((CriteriaDefinition)criteriaUser);
        TenantSummaryFields result = (TenantSummaryFields)this.mongoTemplateUser.findOne(queryUser, TenantSummaryFields.class);
        return result;
    }

    public Object postApplicationRelation(String type, Set<String> codes) throws DWBusinessException {
        HashMap<String, Object> query = new HashMap<String, Object>();
        query.put("type", type);
        query.put("codes", codes);
        return this.kgService.doForwardToKg(query);
    }

    public Map<String, List<ApplicationRelation>> getApplicationsMapByTypeAndCodes(String type, Collection<String> codes) throws DWBusinessException {
        HashMap<String, List<ApplicationRelation>> applicationRelationsMap = new HashMap<String, List<ApplicationRelation>>();
        for (String code : codes) {
            Query queryUser = new Query();
            Criteria criteriaUser = Criteria.where((String)"type").is((Object)type).and("code").is((Object)code);
            queryUser.addCriteria((CriteriaDefinition)criteriaUser);
            List applicationRelations = this.dataPickService.find(Criteria.where((String)"type").is((Object)type).and("code").is((Object)code), ApplicationRelation.class, "applicationRelation");
            applicationRelationsMap.put(code, applicationRelations);
        }
        return applicationRelationsMap;
    }

    public Object postDataViewList(List<String> viewCodes) throws NoSuchFieldException, IllegalAccessException, DWBusinessException {
        HashMap<String, List> dataMap = new HashMap<String, List>();
        String tenantVersion = this.kgInnerService.currentTenantVersion();
        List dataViews = this.mongoTemplate.find(Query.query((CriteriaDefinition)Criteria.where((String)"code").in(viewCodes).and("version").is((Object)tenantVersion)), Object.class, "dataView");
        if (!CollectionUtils.isEmpty((Collection)dataViews)) {
            String localeStr = AthenaUtils.getCurrentLocale();
            String dataViewsStr = this.translateUtils.translateContent((Object)dataViews);
            dataViews = JSON.parseArray((String)dataViewsStr, Object.class);
            LanguageUtil.processLocaleLanguage((Object)dataViews, (String)localeStr);
        }
        dataMap.put("dataViews", dataViews);
        return dataMap;
    }

    private void addPageCodeCriteria(String pageCode, Criteria criteria) {
        if ("project-card".equals(pageCode)) {
            criteria.and("pageCode").is((Object)pageCode);
        } else {
            criteria.orOperator(new Criteria[]{Criteria.where((String)"pageCode").is((Object)pageCode), Criteria.where((String)"pageCode").exists(false)});
        }
    }

    public Object getCardLabel(String code, String pageCode) throws DWBusinessException {
        HashMap<String, String> query = new HashMap<String, String>();
        query.put("code", code);
        query.put("pageCode", pageCode);
        return this.kgService.doForwardToKg(query);
    }

    public Object getCardLabel(String code) throws DWBusinessException {
        return this.getCardLabel(code, "task-card");
    }

    public Object postSaveCardLabel(CardLabel cardLabel) throws Exception {
        HashMap<String, CardLabel> query = new HashMap<String, CardLabel>();
        query.put("cardLabel", cardLabel);
        return this.kgService.doForwardToKg(query);
    }

    public Object getDeleteCardLabel(String code, String pageCode) throws Exception {
        HashMap<String, String> query = new HashMap<String, String>();
        query.put("code", code);
        query.put("pageCode", pageCode);
        return this.kgService.doForwardToKg(query);
    }

    public Object getDeleteCardLabel(String code) throws Exception {
        return this.getDeleteCardLabel(code, "task-card");
    }

    public Object getCardGroup() throws Exception {
        return this.kgService.doForwardToKg(new HashMap());
    }

    public Object postSaveCardGroup(CardGroup cardGroup) throws DWBusinessException {
        String tenantId = AthenaUtils.getTenantId();
        cardGroup.setTenantId(tenantId);
        cardGroup.setVersion(tenantId);
        Query queryUser = new Query();
        Criteria criteria = Criteria.where((String)"tenantId").is((Object)tenantId);
        queryUser.addCriteria((CriteriaDefinition)criteria);
        Update update = new Update();
        if (CollectionUtil.isNotEmpty((Collection)cardGroup.getApplications())) {
            for (CardGroupApplication application : cardGroup.getApplications()) {
                for (CardGroupTask task : application.getTasks()) {
                    task.setEnabled(task.getGroups().stream().anyMatch(v -> Boolean.TRUE.equals(v.isEnabled())));
                    task.setDefaultEffective(task.getGroups().stream().anyMatch(v -> Boolean.TRUE.equals(v.getDefaultGroup())));
                    for (CardGroupGroup group : task.getGroups()) {
                        group.setDefaultEffective(group.isEnabled());
                    }
                }
            }
            update.set("applications", (Object)cardGroup.getApplications());
        }
        if (null != cardGroup.getSystem()) {
            update.set("system", (Object)cardGroup.getSystem());
        }
        update.set("enabled", (Object)true);
        UpdateResult updateResult = this.mongoTemplateUser.upsert(queryUser, (UpdateDefinition)update, CardGroup.class);
        long count = updateResult.getModifiedCount();
        return count;
    }

    public Object getCardGroupStatus() throws DWBusinessException {
        String tenantId = AthenaUtils.getTenantId();
        Criteria orderCriteria = Criteria.where((String)"tenantId").is((Object)tenantId);
        Query orderQry = new Query();
        orderQry.addCriteria((CriteriaDefinition)orderCriteria);
        CardGroup cardGroup = (CardGroup)this.mongoTemplateUser.findOne(orderQry, CardGroup.class);
        if (null == cardGroup) {
            return false;
        }
        return cardGroup.getEnabled();
    }

    public Object getDeleteCardGroup() throws Exception {
        String tenantId = AthenaUtils.getTenantId();
        Query queryUser = new Query();
        Criteria criteria = Criteria.where((String)"tenantId").is((Object)tenantId);
        queryUser.addCriteria((CriteriaDefinition)criteria);
        DeleteResult deleteResult = this.mongoTemplateUser.remove(queryUser, CardGroup.class);
        long count = deleteResult.getDeletedCount();
        CardGroup cardGroup = (CardGroup)this.getCardGroup();
        cardGroup.setEnabled(Boolean.valueOf(true));
        this.postSaveCardGroup(cardGroup);
        return cardGroup;
    }

    public Object getCardConfig() throws Exception {
        return this.kgService.doForwardToKg(new HashMap());
    }

    private void handleCardConfigByBusinessMessageSourceMethod(CardGroup cardGroup, CardOrder cardOrder, List<CardLabel> labels, GroupAndLabelDto groupAndLabelDto) throws DWBusinessException {
        Map businessMessageSourceMethodMap = groupAndLabelDto.getBusinessMessageSourceMethodMap();
        Set taskCodes = businessMessageSourceMethodMap.keySet();
        Object o = this.postCardConfigByType(new CardConfigQueryDTO().setCodes(new ArrayList(taskCodes)).setPageCode("task-card").setCardOrder(cardOrder).setNeedQueryCardOrder(false));
        JSONObject config = (JSONObject)o;
        taskCodes.forEach(c -> businessMessageSourceMethodMap.put(c, config.getJSONObject(c).get((Object)"config")));
    }

    public Object getTenantTask() throws Exception {
        return this.kgService.doForwardToKg(new HashMap());
    }

    public Object postSaveTaskOrder(CardOrder cardOrder) throws DWBusinessException {
        if (null == cardOrder.getEnabled() && CollectionUtil.isEmpty((Collection)cardOrder.getTaskTypeOrders())) {
            return null;
        }
        String tenantId = AthenaUtils.getTenantId();
        Query queryUser = new Query();
        Criteria criteria = Criteria.where((String)"tenantId").is((Object)tenantId);
        queryUser.addCriteria((CriteriaDefinition)criteria);
        Update update = new Update();
        if (null != cardOrder.getEnabled()) {
            update.set("enabled", (Object)cardOrder.getEnabled());
        }
        if (CollectionUtil.isNotEmpty((Collection)cardOrder.getTaskTypeOrders())) {
            update.set("taskTypeOrders", (Object)cardOrder.getTaskTypeOrders());
        }
        UpdateResult updateResult = this.mongoTemplateUser.upsert(queryUser, (UpdateDefinition)update, CardOrder.class);
        return updateResult.getModifiedCount();
    }

    public Object getDeleteTaskOrder() throws DWBusinessException {
        Query queryUser = new Query();
        Criteria criteria = Criteria.where((String)"tenantId").is((Object)AthenaUtils.getTenantId());
        queryUser.addCriteria((CriteriaDefinition)criteria);
        Update update = new Update();
        update.set("taskTypeOrders", new ArrayList());
        UpdateResult updateResult = this.mongoTemplateUser.upsert(queryUser, (UpdateDefinition)update, CardOrder.class);
        return updateResult.getModifiedCount();
    }

    public Object getTaskOrderStatus() throws DWBusinessException {
        Query queryUser = new Query();
        Criteria criteria = Criteria.where((String)"tenantId").is((Object)AthenaUtils.getTenantId());
        queryUser.addCriteria((CriteriaDefinition)criteria);
        CardOrder cardOrder = (CardOrder)this.mongoTemplateUser.findOne(queryUser, CardOrder.class);
        if (null == cardOrder) {
            return false;
        }
        return cardOrder.getEnabled();
    }

    public Object getTaskOrder() throws DWBusinessException {
        Query queryUser = new Query();
        Criteria criteria = Criteria.where((String)"tenantId").is((Object)AthenaUtils.getTenantId());
        queryUser.addCriteria((CriteriaDefinition)criteria);
        CardOrder cardOrder = (CardOrder)this.mongoTemplateUser.findOne(queryUser, CardOrder.class);
        if (null == cardOrder || CollectionUtil.isEmpty((Collection)cardOrder.getTaskTypeOrders())) {
            return null;
        }
        return cardOrder.getTaskTypeOrders();
    }

    public Object getTenantApplications() throws Exception {
        return this.kgService.doForwardToKg(new HashMap());
    }

    public Object getTenantTasksByAppCode(String code) throws Exception {
        HashMap<String, String> query = new HashMap<String, String>();
        query.put("code", code);
        return this.kgService.doForwardToKg(query);
    }

    public Object postCardConfigByType(CardConfigQueryDTO cardConfigQueryDTO) throws DWBusinessException {
        HashMap<String, CardConfigQueryDTO> query = new HashMap<String, CardConfigQueryDTO>();
        query.put("cardConfigQueryDTO", cardConfigQueryDTO);
        return this.kgService.doForwardToKg(query);
    }

    private WSPageCode getWsPageCode(String pageCode) {
        WSPageCode wsPageCode = null;
        switch (pageCode) {
            case "project-card": {
                wsPageCode = WSPageCode.project;
                break;
            }
            case "task-card": {
                wsPageCode = WSPageCode.task;
            }
        }
        return wsPageCode;
    }

    public Object postQueryCondition(CardConditionQueryDTO cardConditionQueryDTO) {
        HashMap<String, CardConditionQueryDTO> query = new HashMap<String, CardConditionQueryDTO>();
        query.put("cardConditionQueryDTO", cardConditionQueryDTO);
        return this.kgService.doForwardToKg(query);
    }

    public Object getPageUIElement(String code, String activityId, String pageCode) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("code", code);
        params.put("activityId", activityId);
        params.put("pageCode", pageCode);
        return this.kgService.doForwardToKg(params);
    }

    public Object postSystemHooksByTenantId(String tenantId, List<String> pageCodes) throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("tenantId", tenantId);
        params.put("pageCodes", pageCodes);
        return this.kgService.doForwardToKg(params);
    }

    public Object postSystemHooks(String md5, List<String> activityIds, List<String> pageCodes) throws Exception {
        String tenantId = AthenaUtils.getTenantId();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("md5", md5);
        params.put("activityIds", activityIds);
        params.put("pageCodes", pageCodes);
        return this.kgService.doForwardToKg(params);
    }

    public List<TaskCardFieldVO> postViewTaskCardField(TaskCardFieldRequest taskCardFieldRequest) {
        HashMap<String, TaskCardFieldRequest> params = new HashMap<String, TaskCardFieldRequest>();
        params.put("taskCardFieldRequest", taskCardFieldRequest);
        return (List)this.kgService.doForwardToKg(params);
    }

    public List<SemcDictOption> getCodeOptions(String type) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("type", type);
        return (List)this.kgService.doForwardToKg(params);
    }

    private void addDictOptionList(List<Map<String, Object>> dataList, List<SemcDictOption> dictOptionList, Set<String> codes) {
        dataList.forEach(e -> {
            SemcDictOption option = new SemcDictOption();
            String code = MapUtils.getString((Map)e, (Object)"code");
            if (codes.add(code)) {
                Map nameMap;
                Map lang = (Map)e.get("lang");
                if (lang != null && MapUtils.isNotEmpty((Map)(nameMap = (Map)lang.get("name")))) {
                    HashMap<String, Map> nameLang = new HashMap<String, Map>();
                    nameLang.put("name", nameMap);
                    option.setLang(nameLang);
                }
                option.setName(MapUtils.getString((Map)e, (Object)"name"));
                option.setCode(MapUtils.getString((Map)e, (Object)"code"));
                dictOptionList.add(option);
            }
        });
    }

    public List<SemcDictOption> getTenantGroupConfigCode() throws DWBusinessException {
        String tenantId = AthenaUtils.getTenantId();
        Criteria criteria = Criteria.where((String)"tenantId").is((Object)tenantId);
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)criteria);
        CardGroup cardLabel = (CardGroup)this.mongoTemplateUser.findOne(query, CardGroup.class);
        if (cardLabel == null) {
            return null;
        }
        if (BooleanUtils.isTrue((Boolean)cardLabel.getEnabled())) {
            List groups;
            SystemGroup system = cardLabel.getSystem();
            ArrayList codes = Lists.newArrayList();
            if (system != null && !CollectionUtils.isEmpty((Collection)(groups = system.getGroups()))) {
                groups.forEach(e -> {
                    Boolean commonEnable = e.getCommonEnable();
                    boolean isAdd = commonEnable != null ? commonEnable != false && e.isEnabled() : e.isEnabled();
                    if (isAdd) {
                        SemcDictOption semcDictOption = new SemcDictOption();
                        semcDictOption.setName(e.getName());
                        Map lang = e.getLang();
                        if (lang != null) {
                            lang.put("name", lang.get("aliasName"));
                        }
                        semcDictOption.setType("system");
                        semcDictOption.setLang(lang);
                        semcDictOption.setCode(e.getCode());
                        semcDictOption.setName(e.getName());
                        codes.add(semcDictOption);
                    }
                });
            }
            return codes;
        }
        return null;
    }

    public Object postDataEntryAndReportByAppCode(String appCode, String pattern) throws Exception {
        String tenantId = AthenaUtils.getTenantId();
        String tenantVersion = this.kgInnerService.getTenantVersion(tenantId);
        List activityCodes = this.dataPickService.tenantProductCodes("activity", (List)Lists.newArrayList((Object[])new String[]{appCode}));
        List activities = this.activityDAO.getActivitiesByPattern(tenantId, pattern, tenantVersion, activityCodes);
        activities = this.dataPickService.excludeWithSameCode(activities);
        if ("DATA_ENTRY".equals(pattern) && org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)activities)) {
            for (Activity activity : activities) {
                Boolean isCustomize;
                Object activityDefinition = this.getActivityDefinition(activity.getCode(), "basic-data");
                if (activityDefinition == null) {
                    log.error("postDataEntryAndReportByAppCode not found Definition appCode:" + appCode + " ,code:" + activity.getCode());
                    continue;
                }
                JSONObject jsonObject = JSON.parseObject((String)JSON.toJSONString((Object)activityDefinition));
                JSONObject pages = jsonObject.getJSONObject("pages");
                Boolean bl = isCustomize = Objects.nonNull(pages) ? pages.getBoolean("isCustomize") : null;
                if (Objects.isNull(isCustomize) && "CUSTOM".equals(jsonObject.getString("pattern"))) {
                    isCustomize = true;
                }
                activity.setIsCustomize(isCustomize);
            }
        }
        return activities;
    }

    public Object postTaskList(Map<String, Object> query) throws Exception {
        return this.kgService.doForwardToKg(query);
    }

    public Object postProjectExcludeMainlineByAppCode(String appCode) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("appCode", appCode);
        return this.kgService.doForwardToKg(params);
    }

    public Object postProjectListBasic(Map<String, Object> query) {
        return this.kgService.doForwardToKg(query);
    }

    public Object postProjectList(Map<String, Object> query) {
        return this.kgService.doForwardToKg(query);
    }

    public Object postFindTaskFromUser(FindTaskFromUserRequest request) throws Exception {
        HashMap<String, FindTaskFromUserRequest> params = new HashMap<String, FindTaskFromUserRequest>();
        params.put("request", request);
        return this.kgService.doForwardToKg(params);
    }

    private void handleRequestCategory(Map<String, Object> query, List<String> category) {
        if (CollectionUtils.isEmpty(category)) {
            return;
        }
        List categoryList = Stream.of("APPROVAL", "SOLVE", "REPLY", "PROCESS", "DATA_ENTRY").collect(Collectors.toList());
        ArrayList drivenCategory = new ArrayList();
        if (category.contains("OTHER")) {
            categoryList.removeAll(category);
            query.put("excludeCategoryList", categoryList);
            this.handleDrivenCategory(drivenCategory, categoryList);
        } else {
            query.put("includeCategoryList", category);
            this.handleDrivenCategory(drivenCategory, category);
        }
        query.put("drivenCategory", drivenCategory);
    }

    private FindTaskFromUserResp handleFindTaskRespParam(Object taskFromUser, FindTaskFromUserRequest request, String currentLocale) {
        if (Objects.isNull(taskFromUser)) {
            return new FindTaskFromUserResp(null, request.getPageNum(), request.getPageSize(), Long.valueOf(0L));
        }
        DataMapFindTaskResp dataMapFindTaskResp = (DataMapFindTaskResp)JSONObject.parseObject((String)JSONObject.toJSONString((Object)taskFromUser), DataMapFindTaskResp.class);
        if (Objects.isNull(dataMapFindTaskResp)) {
            return new FindTaskFromUserResp(null, request.getPageNum(), request.getPageSize(), Long.valueOf(0L));
        }
        if (CollectionUtils.isEmpty((Collection)dataMapFindTaskResp.getData())) {
            return new FindTaskFromUserResp(null, request.getPageNum(), request.getPageSize(), dataMapFindTaskResp.getTotal());
        }
        ArrayList<FindTaskFromUserVO> data = new ArrayList<FindTaskFromUserVO>();
        for (DataMapTaskVO dataMapTaskVO : dataMapFindTaskResp.getData()) {
            FindTaskFromUserVO vo = new FindTaskFromUserVO();
            vo.setTaskDefName(dataMapTaskVO, currentLocale);
            vo.setTaskDefCode(dataMapTaskVO.getCode());
            vo.setApplication(dataMapTaskVO.getApplication());
            vo.setCategory(Objects.equals("DATA_ENTRY_DRIVEN", dataMapTaskVO.getCategory()) ? dataMapTaskVO.getDrivenCategory() : dataMapTaskVO.getCategory());
            data.add(vo);
        }
        return new FindTaskFromUserResp(data, request.getPageNum(), request.getPageSize(), dataMapFindTaskResp.getTotal());
    }

    private void handleDrivenCategory(List<String> drivenCategory, List<String> category) {
        if (category.contains("APPROVAL")) {
            drivenCategory.add("ManualApprove");
        }
        if (category.contains("PROCESS")) {
            drivenCategory.add("ManualExecution");
        }
    }
}

