/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.agiledataquery.service.inner;

import com.digiwin.athena.agiledataquery.context.DWServiceContext;
import com.digiwin.athena.agiledataquery.domain.TenantEntity;
import com.digiwin.athena.agiledataquery.utils.AthenaUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class KgInnerService {
    private static final String DEFAULT_TENANT_VERSION = "2.0";
    private static final Logger logger = LoggerFactory.getLogger(KgInnerService.class);
    @Autowired
    StringRedisTemplate stringRedisTemplate;
    @Autowired
    @Qualifier(value="mongoTemplateTenant")
    MongoTemplate mongoTemplateUser;
    @Autowired
    @Qualifier(value="mongoTemplate")
    MongoTemplate mongoTemplate;
    private static ThreadLocal<String> tenantVersionHolder = new ThreadLocal();

    public String currentTenantVersion() {
        String version = null;
        try {
            String tenantId = AthenaUtils.getTenantId();
            version = this.getTenantVersion(tenantId);
        }
        catch (Exception e) {
            logger.warn("Failed to get current tenant version", (Throwable)e);
        }
        finally {
            KgInnerService.cleanThreads();
        }
        if (null == version) {
            version = "2.0";
        }
        return version;
    }

    public String getCurrentTenantVersion() {
        String version = null;
        try {
            String tenantId = AthenaUtils.getTenantId();
            version = this.getTenantVersion(tenantId);
        }
        catch (Exception e) {
            logger.warn("Failed to get current tenant version", (Throwable)e);
        }
        finally {
            KgInnerService.cleanThreads();
        }
        if (version == null) {
            version = "2.0";
        }
        return version;
    }

    public String getTenantVersion(String tenantId) {
        String version;
        block14: {
            if (tenantId == null || tenantId.trim().isEmpty()) {
                logger.warn("Tenant ID is null or empty, using default version");
                return "2.0";
            }
            boolean isTimedTask = false;
            version = null;
            try {
                String cachedVersion = (String)tenantVersionHolder.get();
                if (cachedVersion != null) {
                    logger.debug("Found tenant version in ThreadLocal cache: {}", (Object)cachedVersion);
                    return cachedVersion;
                }
                try {
                    version = (String)DWServiceContext.getContext().getRequestHeader().get(tenantId + "tenantVersion");
                }
                catch (Exception e) {
                    isTimedTask = true;
                    logger.debug("No DWServiceContext available, likely in timed task");
                }
                if (version != null) {
                    logger.debug("Found tenant version in request context: {}", (Object)version);
                    tenantVersionHolder.set(version);
                    return version;
                }
                try {
                    if (this.mongoTemplate == null) {
                        logger.warn("MongoTemplate is not available, using default version");
                        return "2.0";
                    }
                    Query query = new Query((CriteriaDefinition)Criteria.where((String)"tenantId").is((Object)tenantId));
                    TenantEntity tenantEntity = (TenantEntity)this.mongoTemplate.findOne(query, TenantEntity.class);
                    if (tenantEntity == null || tenantEntity.getVersion() == null) {
                        version = "2.0";
                        logger.warn("Tenant not found or version is null for tenantId: {}, using default version: {}", (Object)tenantId, (Object)version);
                    } else {
                        version = tenantEntity.getVersion();
                        logger.debug("Found tenant version in database: {}", (Object)version);
                    }
                    tenantVersionHolder.set(version);
                    if (isTimedTask) break block14;
                    try {
                        DWServiceContext.getContext().getRequestHeader().put(tenantId + "tenantVersion", version);
                    }
                    catch (Exception e) {
                        logger.warn("Failed to cache tenant version to request context", (Throwable)e);
                    }
                }
                catch (Exception e) {
                    logger.error("Failed to get tenant version from database for tenantId: " + tenantId, (Throwable)e);
                    version = "2.0";
                }
            }
            catch (Exception e) {
                logger.error("Unexpected error while getting tenant version for tenantId: " + tenantId, (Throwable)e);
                version = "2.0";
            }
        }
        return version;
    }

    public static void cleanThreads() {
        try {
            tenantVersionHolder.remove();
            logger.debug("ThreadLocal tenantVersionHolder cleaned successfully");
        }
        catch (Exception e) {
            logger.warn("Failed to clean ThreadLocal tenantVersionHolder", (Throwable)e);
        }
    }
}

