/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.agiledataquery.synonym.aop;

import com.digiwin.athena.agiledataquery.synonym.service.TranslateService;
import java.util.ArrayList;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Aspect
@Component
public class SynonymAspect {
    @Autowired
    private TranslateService translationService;

    @Pointcut(value="execution(* com.digiwin.athena.synonym.controller.*.*(..))")
    public void serviceLoggingPointcut() {
    }

    @AfterReturning(pointcut="serviceLoggingPointcut()", returning="rvt")
    public void doAfterReturning(JoinPoint joinPoint, Object rvt) {
        ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        HttpServletRequest request = attributes.getRequest();
        String locale = request.getHeader("Locale");
        if (rvt == null) {
            return;
        }
    }

    public String translate(String msg) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(msg);
        Map translation = this.translationService.translation(list, Boolean.valueOf(true));
        Map lang = (Map)translation.get("lang");
        if (lang == null) {
            return null;
        }
        Map msgMap = (Map)lang.get(msg);
        if (msgMap == null) {
            return null;
        }
        String zhTw = (String)msgMap.get("zh_TW");
        return zhTw;
    }
}

