/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.agiledataquery.synonym.dao;

import com.digiwin.athena.agiledataquery.synonym.domain.AppThresholdConfig;
import com.digiwin.athena.agiledataquery.utils.DWBusinessException;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Repository;
import org.springframework.util.CollectionUtils;

@Repository
public class AppThresholdConfigDao {
    @Autowired
    @Qualifier(value="mongoTemplateTenant")
    private MongoTemplate mongoTemplate;

    public void update(AppThresholdConfig appThresholdConfig) {
        if (appThresholdConfig == null) {
            return;
        }
        this.mongoTemplate.save((Object)appThresholdConfig);
    }

    public void saveAll(List<AppThresholdConfig> appThresholdConfigs) {
        this.mongoTemplate.insertAll(appThresholdConfigs);
    }

    public List<AppThresholdConfig> findList(String tenantId, String code) {
        if (StringUtils.isEmpty((CharSequence)tenantId)) {
            throw new DWBusinessException("\u79df\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Query query = new Query();
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"tenantId").is((Object)tenantId)});
        if (StringUtils.isNotBlank((CharSequence)code)) {
            criteria.and("appCode").is((Object)code);
        }
        query.addCriteria((CriteriaDefinition)criteria);
        return this.mongoTemplate.find(query, AppThresholdConfig.class);
    }

    public void delete(List<String> list, String tenantId) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        if (StringUtils.isEmpty((CharSequence)tenantId)) {
            throw new DWBusinessException("\u79df\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"id").in(list).andOperator(new Criteria[]{Criteria.where((String)"tenantId").is((Object)tenantId)}));
        this.mongoTemplate.remove(query, AppThresholdConfig.class);
    }
}

