/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.agiledataquery.synonym.dao;

import cn.hutool.core.collection.ListUtil;
import com.digiwin.athena.agiledataquery.domain.BigScreenViewConfig;
import com.digiwin.athena.agiledataquery.model.sence.ReportSceneDTO;
import com.digiwin.athena.agiledataquery.service.ISceneService;
import com.digiwin.athena.agiledataquery.service.IScreenService;
import com.digiwin.athena.agiledataquery.service.inner.KgInnerService;
import com.digiwin.athena.agiledataquery.synonym.domain.po.ScreenInfo;
import com.digiwin.athena.agiledataquery.utils.DWBusinessException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Repository;
import org.springframework.util.CollectionUtils;

@Repository
public class BigScreenViewConfigDao {
    @Autowired
    @Qualifier(value="mongoTemplateTenant")
    private MongoTemplate mongoTemplate;
    @Autowired
    private IScreenService screenService;
    @Autowired
    KgInnerService kgInnerService;
    @Autowired
    private ISceneService sceneService;

    public void update(BigScreenViewConfig bigScreenViewConfig) {
        if (bigScreenViewConfig == null) {
            return;
        }
        this.mongoTemplate.save((Object)bigScreenViewConfig);
    }

    public void saveAll(List<BigScreenViewConfig> bigScreenViewConfigs) {
        this.mongoTemplate.insertAll(bigScreenViewConfigs);
    }

    public List<BigScreenViewConfig> findList(String tenantId, String appCode) {
        if (StringUtils.isEmpty((CharSequence)tenantId)) {
            throw new DWBusinessException("\u79df\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Query query = new Query();
        Criteria criteria = new Criteria();
        criteria.and("tenantId").is((Object)tenantId);
        if (StringUtils.isNotBlank((CharSequence)appCode)) {
            criteria.and("appCode").is((Object)appCode);
        }
        query.addCriteria((CriteriaDefinition)criteria);
        List bigScreenViewConfigs = this.mongoTemplate.find(query, BigScreenViewConfig.class);
        return bigScreenViewConfigs.stream().filter(item -> !StringUtils.equals((CharSequence)item.getType(), (CharSequence)"custom")).collect(Collectors.toList());
    }

    public BigScreenViewConfig findOne(String bigScreenViewConfigCode) {
        if (StringUtils.isEmpty((CharSequence)bigScreenViewConfigCode)) {
            return null;
        }
        Query query = new Query();
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"bigScreenCode").is((Object)bigScreenViewConfigCode)});
        query.addCriteria((CriteriaDefinition)criteria);
        return (BigScreenViewConfig)this.mongoTemplate.findOne(query, BigScreenViewConfig.class);
    }

    public void delete(List<String> list, String tenantId, String appCode) {
        if (StringUtils.isEmpty((CharSequence)tenantId) || StringUtils.isEmpty((CharSequence)appCode)) {
            throw new DWBusinessException("\u79df\u6237id\u4e0e\u5e94\u7528code\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Query query = new Query();
        Criteria criteria = new Criteria();
        criteria.and("tenantId").is((Object)tenantId);
        criteria.and("appCode").is((Object)appCode);
        criteria.and("type").ne((Object)"custom");
        if (!CollectionUtils.isEmpty(list)) {
            criteria.and("bigScreenCode").in(list);
        }
        query.addCriteria((CriteriaDefinition)criteria);
        this.mongoTemplate.remove(query, BigScreenViewConfig.class);
    }

    public List<ScreenInfo> postQuerySceneByApp(String appCode) throws Exception {
        if (StringUtils.isEmpty((CharSequence)appCode)) {
            return new ArrayList<ScreenInfo>();
        }
        List appCodes = ListUtil.of((Object[])new String[]{appCode});
        String tenantVersion = this.kgInnerService.currentTenantVersion();
        List sceneDTOS = this.sceneService.querySceneByAppAndTag(appCodes, "screen", tenantVersion);
        ArrayList<ScreenInfo> result = new ArrayList<ScreenInfo>();
        if (!CollectionUtils.isEmpty((Collection)sceneDTOS)) {
            for (ReportSceneDTO dto : sceneDTOS) {
                ScreenInfo info = new ScreenInfo();
                BeanUtils.copyProperties((Object)dto, (Object)info);
                result.add(info);
            }
        }
        return result;
    }

    public BigScreenViewConfig getCustom(String tenantId, String appCode) {
        if (StringUtils.isEmpty((CharSequence)tenantId)) {
            throw new DWBusinessException("\u79df\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Query query = new Query();
        Criteria criteria = new Criteria();
        criteria.and("tenantId").is((Object)tenantId);
        if (StringUtils.isNotBlank((CharSequence)appCode)) {
            criteria.and("appCode").is((Object)appCode);
        }
        query.addCriteria((CriteriaDefinition)criteria);
        List bigScreenViewConfigs = this.mongoTemplate.find(query, BigScreenViewConfig.class);
        List custom = bigScreenViewConfigs.stream().filter(item -> StringUtils.equals((CharSequence)item.getType(), (CharSequence)"custom")).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(custom)) {
            return null;
        }
        return (BigScreenViewConfig)custom.get(0);
    }
}

