/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.agiledataquery.synonym.dao;

import com.digiwin.athena.agiledataquery.service.inner.KgInnerService;
import com.digiwin.athena.agiledataquery.synonym.domain.BusinessType;
import com.digiwin.athena.agiledataquery.synonym.domain.po.DeleteVo;
import com.digiwin.athena.agiledataquery.synonym.domain.po.PageVo;
import com.digiwin.athena.agiledataquery.utils.AthenaUtils;
import com.digiwin.athena.agiledataquery.utils.DWBusinessException;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Repository;
import org.springframework.util.CollectionUtils;
import org.springframework.web.client.RestTemplate;

@Repository
public class BusinessTypeDao {
    @Resource
    @Qualifier(value="mongoTemplateTenant")
    private MongoTemplate mongoTemplate;
    @Resource
    private MongoTemplate systemMongoTemplate;
    @Autowired
    KgInnerService kgInnerService;
    @Resource
    private RestTemplate restTemplate;
    private static final String APP_CODE = "appCode";

    public PageVo<BusinessType> getPage(String appCode, String tid, int pageNum, int pageSize) {
        if (StringUtils.isEmpty((CharSequence)tid)) {
            throw new DWBusinessException("\u79df\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (pageSize == 0) {
            pageSize = 10;
        }
        --pageNum;
        Query query = new Query();
        Criteria criteria = new Criteria();
        criteria.and("tenantId").is((Object)tid);
        criteria.and(APP_CODE).is((Object)appCode);
        query.addCriteria((CriteriaDefinition)criteria);
        PageRequest pageable = PageRequest.of((int)pageNum, (int)pageSize, (Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"editTime"});
        long totalCount = this.mongoTemplate.count(query, BusinessType.class);
        List businessTypes = this.mongoTemplate.find(query.with((Pageable)pageable), BusinessType.class);
        int totalPage = (int)(totalCount % (long)pageSize == 0L ? totalCount / (long)pageSize : totalCount / (long)pageSize + 1L);
        return new PageVo((int)totalCount, businessTypes, pageNum, pageSize, totalPage);
    }

    public BusinessType getSystemOne(String appCode, String code) {
        String tenantId = AthenaUtils.getTenantId();
        String tenantVersion = this.kgInnerService.getTenantVersion(tenantId);
        Query query = new Query();
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)APP_CODE).is((Object)appCode)});
        criteria.and("code").is((Object)code);
        criteria.and("version").is((Object)tenantVersion);
        query.addCriteria((CriteriaDefinition)criteria);
        return (BusinessType)this.systemMongoTemplate.findOne(query, BusinessType.class);
    }

    public void update(BusinessType businessType) {
        if (businessType == null) {
            return;
        }
        businessType.setEditTime(new Date());
        this.mongoTemplate.save((Object)businessType);
    }

    public List<BusinessType> findList(String appCode, String tid) {
        if (StringUtils.isEmpty((CharSequence)tid)) {
            throw new DWBusinessException("\u79df\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Query query = new Query();
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"tenantId").is((Object)tid)});
        criteria.and(APP_CODE).is((Object)appCode);
        query.addCriteria((CriteriaDefinition)criteria);
        return this.mongoTemplate.find(query, BusinessType.class);
    }

    public List<BusinessType> querySystemBusinessTypeByVersion(String appCode, String tenantVersion) {
        Query query = new Query();
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"version").is((Object)tenantVersion)});
        criteria.and(APP_CODE).is((Object)appCode);
        query.addCriteria((CriteriaDefinition)criteria);
        return this.systemMongoTemplate.find(query, BusinessType.class);
    }

    public void batchDelete(DeleteVo deleteVo) {
        Query query = new Query();
        Criteria criteria = new Criteria();
        criteria.and("tenantId").is((Object)deleteVo.getTid());
        criteria.and(APP_CODE).is((Object)deleteVo.getAppCode());
        if (!CollectionUtils.isEmpty((Collection)deleteVo.getIds())) {
            criteria.and("id").in((Collection)deleteVo.getIds());
        }
        query.addCriteria((CriteriaDefinition)criteria);
        this.mongoTemplate.remove(query, BusinessType.class);
    }

    public void batchInsert(List<BusinessType> insertList) {
        this.mongoTemplate.insertAll(insertList);
    }
}

