/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.agiledataquery.synonym.dao;

import com.digiwin.athena.agiledataquery.synonym.domain.EntityType;
import com.digiwin.athena.agiledataquery.synonym.domain.po.PageVo;
import com.digiwin.athena.agiledataquery.utils.DWBusinessException;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Repository;

@Repository
public class EntityTypeDao {
    @Autowired
    private MongoTemplate mongoTemplate;

    public void insert(EntityType entityType) {
        this.mongoTemplate.insert((Object)entityType);
    }

    public void delete(String id, String tenantId) {
        if (StringUtils.isEmpty((CharSequence)id)) {
            return;
        }
        if (StringUtils.isEmpty((CharSequence)tenantId)) {
            throw new DWBusinessException("\u79df\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"objectId").is((Object)id).andOperator(new Criteria[]{Criteria.where((String)"tenantId").is((Object)tenantId)}));
        this.mongoTemplate.remove(query, EntityType.class);
    }

    public List<EntityType> findList(String tenantId) {
        if (StringUtils.isEmpty((CharSequence)tenantId)) {
            throw new DWBusinessException("\u79df\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Query query = new Query();
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"tenantId").is((Object)tenantId)});
        query.addCriteria((CriteriaDefinition)criteria);
        return this.mongoTemplate.find(query, EntityType.class);
    }

    public PageVo<EntityType> getPage(String tid, int pageNum, int pageSize) {
        if (StringUtils.isEmpty((CharSequence)tid)) {
            throw new DWBusinessException("\u79df\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (pageSize == 0) {
            pageSize = 10;
        }
        Query query = new Query();
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"tenantId").is((Object)tid)});
        query.addCriteria((CriteriaDefinition)criteria);
        PageRequest pageable = PageRequest.of((int)pageNum, (int)pageSize);
        long totalCount = this.mongoTemplate.count(query, EntityType.class);
        List entityTypes = this.mongoTemplate.find(query.with((Pageable)pageable), EntityType.class);
        int totalPage = (int)(totalCount % (long)pageSize == 0L ? totalCount / (long)pageSize : totalCount / (long)pageSize + 1L);
        return new PageVo((int)totalCount, entityTypes, pageNum, pageSize, totalPage);
    }
}

