/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.agiledataquery.synonym.dao;

import com.digiwin.athena.agiledataquery.synonym.domain.Synonym;
import com.digiwin.athena.agiledataquery.synonym.domain.po.PageVo;
import com.digiwin.athena.agiledataquery.utils.DWBusinessException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Repository;
import org.springframework.util.CollectionUtils;

@Repository
public class SynonymDao {
    @Autowired
    private MongoTemplate mongoTemplate;

    public void insertOrUpdate(Synonym synonym) {
        if (synonym == null) {
            return;
        }
        this.mongoTemplate.save((Object)synonym);
    }

    public void saveAll(List<Synonym> synonyms) {
        this.mongoTemplate.insertAll(synonyms);
    }

    public PageVo findListPage(String tenantId, String properNoun, String entityTypeName, String des, int page, int pageSize) {
        if (StringUtils.isEmpty((CharSequence)tenantId)) {
            throw new DWBusinessException("\u79df\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Query query = new Query();
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"tenantId").is((Object)tenantId)});
        if (StringUtils.isNotEmpty((CharSequence)des)) {
            criteria.and("description").regex(des);
        }
        if (StringUtils.isNotEmpty((CharSequence)properNoun)) {
            criteria.orOperator(new Criteria[]{Criteria.where((String)"properNoun").regex(properNoun), Criteria.where((String)"zh_CN_Str").regex(properNoun), Criteria.where((String)"zh_TW_Str").regex(properNoun)});
        }
        if (StringUtils.isNotEmpty((CharSequence)entityTypeName)) {
            criteria.and("entityTypeName").regex(entityTypeName);
        }
        query.addCriteria((CriteriaDefinition)criteria);
        PageRequest pageable = PageRequest.of((int)page, (int)pageSize);
        long totalCount = this.mongoTemplate.count(query, Synonym.class);
        List synonyms = this.mongoTemplate.find(query.with((Pageable)pageable), Synonym.class);
        int totalPage = (int)(totalCount % (long)pageSize == 0L ? totalCount / (long)pageSize : totalCount / (long)pageSize + 1L);
        return new PageVo((int)totalCount, synonyms, page, pageSize, totalPage);
    }

    public Map<String, Synonym> findMap(String tenantId, List<String> ids) {
        if (StringUtils.isEmpty((CharSequence)tenantId)) {
            throw new DWBusinessException("\u79df\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Query query = new Query();
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"tenantId").is((Object)tenantId)});
        if (!CollectionUtils.isEmpty(ids)) {
            criteria.andOperator(new Criteria[]{Criteria.where((String)"_id").in(ids)});
        }
        query.addCriteria((CriteriaDefinition)criteria);
        List synonyms = this.mongoTemplate.find(query, Synonym.class);
        HashMap<String, Synonym> map = new HashMap<String, Synonym>();
        for (Synonym synonym : synonyms) {
            map.put(synonym.getObjectId(), synonym);
        }
        return map;
    }

    public List<Synonym> findList(String tenantId, String properNoun, String entityTypeName, String des) {
        if (StringUtils.isEmpty((CharSequence)tenantId)) {
            throw new DWBusinessException("\u79df\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Query query = new Query();
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"tenantId").is((Object)tenantId)});
        if (StringUtils.isNotEmpty((CharSequence)des)) {
            criteria.and("description").regex(des);
        }
        if (StringUtils.isNotEmpty((CharSequence)properNoun)) {
            criteria.orOperator(new Criteria[]{Criteria.where((String)"properNoun").regex(properNoun), Criteria.where((String)"zh_CN_Str").regex(properNoun), Criteria.where((String)"zh_TW_Str").regex(properNoun)});
        }
        if (StringUtils.isNotEmpty((CharSequence)entityTypeName)) {
            criteria.and("entityTypeName").regex(entityTypeName);
        }
        query.addCriteria((CriteriaDefinition)criteria);
        return this.mongoTemplate.find(query, Synonym.class);
    }

    public List<Synonym> findList(String tenantId, List<String> ids) {
        if (StringUtils.isEmpty((CharSequence)tenantId)) {
            throw new DWBusinessException("\u79df\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Query query = new Query();
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"tenantId").is((Object)tenantId)});
        if (!CollectionUtils.isEmpty(ids)) {
            criteria.and("_id").in(ids);
        }
        query.addCriteria((CriteriaDefinition)criteria);
        return this.mongoTemplate.find(query, Synonym.class);
    }

    public Synonym findOne(String tenantId, String properNoun) {
        if (StringUtils.isEmpty((CharSequence)tenantId) || StringUtils.isEmpty((CharSequence)properNoun)) {
            throw new DWBusinessException("\u79df\u6237id/\u4e13\u6709\u540d\u8bcd/\u5b9e\u4f53\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Query query = new Query();
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"tenantId").is((Object)tenantId), Criteria.where((String)"properNoun").is((Object)properNoun)});
        query.addCriteria((CriteriaDefinition)criteria);
        return (Synonym)this.mongoTemplate.findOne(query, Synonym.class);
    }

    public void delete(List<String> list, String tenantId) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        if (StringUtils.isEmpty((CharSequence)tenantId)) {
            throw new DWBusinessException("\u79df\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"objectId").in(list).andOperator(new Criteria[]{Criteria.where((String)"tenantId").is((Object)tenantId)}));
        this.mongoTemplate.remove(query, Synonym.class);
    }
}

