/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.agiledataquery.synonym.http;

import com.alibaba.fastjson.JSONObject;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class ModelCenterApiHelper {
    private static final Logger log = LoggerFactory.getLogger(ModelCenterApiHelper.class);
    @Value(value="${rest-url.bmd}")
    private String modelCenterUrl;
    @Autowired
    private RestTemplate restTemplate;

    public JSONObject getDataByModel(JSONObject schema, String token, Long tenantSid, String userEmail) {
        String url = this.modelCenterUrl + "/server/semantic/api/v1/public/common/model/playground";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("token", token);
        headers.add("dccTenantSid", tenantSid + "");
        headers.add("locally", "true");
        headers.add("userId", userEmail);
        HttpEntity httpEntity = new HttpEntity((Object)schema, (MultiValueMap)headers);
        log.info("\u8c03\u6a21\u578b\u4e2d\u5fc3\u83b7\u53d6\u6570\u636e\u5730\u5740\u4e3a\uff1a" + url);
        ResponseEntity result = this.restTemplate.postForEntity(url, (Object)httpEntity, JSONObject.class, new Object[0]);
        int statusCodeValue = result.getStatusCodeValue();
        if (statusCodeValue != 200) {
            log.info("\u8c03\u6a21\u578b\u4e2d\u5fc3\u83b7\u53d6\u6570\u636e\u5931\u8d25:{}", (Object)result);
            return new JSONObject();
        }
        JSONObject body = (JSONObject)result.getBody();
        if (Objects.isNull(body)) {
            log.info("\u8c03\u6a21\u578b\u4e2d\u5fc3\u6ca1\u83b7\u53d6\u5230\u6570\u636e:{}", (Object)result);
            return new JSONObject();
        }
        JSONObject data = body.getJSONObject("data");
        if (Objects.isNull(data)) {
            log.info("\u8c03\u6a21\u578b\u4e2d\u5fc3data\u4e3a\u7a7a:{}", (Object)result);
            return new JSONObject();
        }
        return data;
    }
}

