/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.agiledataquery.synonym.service.impl;

import com.alibaba.fastjson.JSON;
import com.digiwin.athena.agiledataquery.enums.NewSourceType;
import com.digiwin.athena.agiledataquery.service.inner.KgInnerService;
import com.digiwin.athena.agiledataquery.synonym.dao.BusinessVariablesValueDao;
import com.digiwin.athena.agiledataquery.synonym.domain.AthenaUser;
import com.digiwin.athena.agiledataquery.synonym.domain.AthenaUserLocal;
import com.digiwin.athena.agiledataquery.synonym.domain.BusinessVariables;
import com.digiwin.athena.agiledataquery.synonym.domain.BusinessVariablesValue;
import com.digiwin.athena.agiledataquery.synonym.domain.po.DeleteVo;
import com.digiwin.athena.agiledataquery.synonym.domain.po.PageVo;
import com.digiwin.athena.agiledataquery.synonym.service.BusinessVariablesValueService;
import com.digiwin.athena.agiledataquery.utils.DWBusinessException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class BusinessVariablesValueServiceImpl
implements BusinessVariablesValueService {
    private static final Logger log = LoggerFactory.getLogger(BusinessVariablesValueServiceImpl.class);
    @Autowired
    private BusinessVariablesValueDao businessVariablesValueDao;
    @Autowired
    private KgInnerService kgInnerService;

    public PageVo<BusinessVariablesValue> getPage(String appCode, String tid, int pageSize, int pageNum) {
        return this.businessVariablesValueDao.getPage(appCode, tid, pageSize, pageNum);
    }

    public void update(BusinessVariablesValue businessVariablesValue) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String format = sdf.format(new Date());
        AthenaUser user = AthenaUserLocal.getUser();
        if (null != user) {
            businessVariablesValue.setUpdateBy(user.getUserName());
        }
        businessVariablesValue.setUpdateDate(format);
        this.businessVariablesValueDao.update(businessVariablesValue);
    }

    public void syncData(String tid, String appCode) {
        this.syncValueData(tid, appCode);
    }

    private void syncValueData(String tid, String appCode) {
        if (StringUtils.isEmpty((Object)tid)) {
            throw new DWBusinessException("\u672a\u83b7\u53d6\u5230\u5f53\u524d\u7528\u6237\u7684\u79df\u6237");
        }
        String tenantVersion = this.kgInnerService.getTenantVersion(tid);
        List businessVariablesValues = this.businessVariablesValueDao.queryBusinessVariablesValue(tid, appCode);
        List businessVariables = this.businessVariablesValueDao.queryBusinessVariables(appCode, tenantVersion);
        ArrayList<BusinessVariablesValue> newList = new ArrayList<BusinessVariablesValue>();
        HashMap<String, BusinessVariablesValue> valueMap = new HashMap<String, BusinessVariablesValue>();
        HashMap<String, BusinessVariables> map = new HashMap<String, BusinessVariables>();
        if (!CollectionUtils.isEmpty((Collection)businessVariablesValues)) {
            for (BusinessVariablesValue businessVariablesValue : businessVariablesValues) {
                valueMap.put(businessVariablesValue.getCode(), businessVariablesValue);
            }
        }
        if (!CollectionUtils.isEmpty((Collection)businessVariables)) {
            for (BusinessVariables businessVariable : businessVariables) {
                map.put(businessVariable.getCode(), businessVariable);
            }
        }
        DeleteVo deleteVo = new DeleteVo();
        deleteVo.setTid(tid);
        deleteVo.setAppCode(appCode);
        if (CollectionUtils.isEmpty((Collection)businessVariables)) {
            this.businessVariablesValueDao.deleteBusinessVariables(deleteVo);
        } else {
            ArrayList<String> idList = new ArrayList<String>();
            for (BusinessVariables businessVariable : businessVariables) {
                BusinessVariablesValue businessVariablesValue = (BusinessVariablesValue)valueMap.get(businessVariable.getCode());
                String variableDataType = businessVariable.getData_type();
                if (businessVariablesValue == null) {
                    newList.add(this.toValue(businessVariable, businessVariablesValue, tid));
                    continue;
                }
                if (!Boolean.TRUE.equals(this.compareOld(businessVariablesValue, businessVariable)) && businessVariablesValue.getData_type().equals(variableDataType)) continue;
                newList.add(this.toValue(businessVariable, businessVariablesValue, tid));
                idList.add(businessVariablesValue.getId());
            }
            for (BusinessVariablesValue businessVariablesValue : businessVariablesValues) {
                BusinessVariables variables = (BusinessVariables)map.get(businessVariablesValue.getCode());
                if (variables != null) continue;
                idList.add(businessVariablesValue.getId());
            }
            if (!CollectionUtils.isEmpty(idList)) {
                deleteVo.setIds(idList);
                this.businessVariablesValueDao.deleteBusinessVariables(deleteVo);
            }
            this.businessVariablesValueDao.insertBusinessVariables(newList);
        }
    }

    private Boolean compareOld(BusinessVariablesValue oldValue, BusinessVariables newValue) {
        String newValueName;
        String oldValueDescription = oldValue.getDescription();
        String newValueDescription = newValue.getDescription();
        String oldValueName = oldValue.getName();
        if (!oldValueName.equals(newValueName = newValue.getName())) {
            return true;
        }
        if (!StringUtils.isEmpty((Object)oldValueDescription) && !StringUtils.isEmpty((Object)newValueDescription) ? !oldValueDescription.equals(newValueDescription) : StringUtils.isEmpty((Object)oldValueDescription) && !StringUtils.isEmpty((Object)newValueDescription)) {
            return true;
        }
        if (!newValue.getData_type().equals(oldValue.getData_type())) {
            return true;
        }
        return !Objects.equals(newValue.getOperationTag(), oldValue.getOperationTag());
    }

    private BusinessVariablesValue toValue(BusinessVariables businessVariables, BusinessVariablesValue oldBusinessVariablesValue, String tenantId) {
        BusinessVariablesValue businessVariablesValue = new BusinessVariablesValue();
        businessVariablesValue.setId(UUID.randomUUID().toString());
        businessVariablesValue.setLang(JSON.parseObject((String)businessVariables.getLang()));
        businessVariablesValue.setData_name(businessVariables.getData_name());
        businessVariablesValue.setStatus("0");
        businessVariablesValue.setSource(businessVariables.getSource());
        if (oldBusinessVariablesValue != null) {
            businessVariablesValue.setValue(oldBusinessVariablesValue.getValue());
            businessVariablesValue.setUpdateBy(oldBusinessVariablesValue.getUpdateBy());
            businessVariablesValue.setUpdateDate(oldBusinessVariablesValue.getUpdateDate());
            businessVariablesValue.setCompileVersion(businessVariables.getCompileVersion());
            businessVariablesValue.setStatus(oldBusinessVariablesValue.getStatus());
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)oldBusinessVariablesValue.getSource())) {
                businessVariablesValue.setSource(oldBusinessVariablesValue.getSource());
            }
        }
        businessVariablesValue.setTenantId(tenantId);
        businessVariablesValue.setDescription(businessVariables.getDescription());
        businessVariablesValue.setData_type(businessVariables.getData_type());
        businessVariablesValue.setAppCode(businessVariables.getAppCode());
        businessVariablesValue.setOperationTag(businessVariables.getOperationTag());
        businessVariablesValue.setName(businessVariables.getName());
        businessVariablesValue.setCode(businessVariables.getCode());
        return businessVariablesValue;
    }

    public void dealHistoryData() {
        List list = this.businessVariablesValueDao.queryAll();
        for (BusinessVariablesValue item : list) {
            item.setSource(NewSourceType.CUSTOM.getCode());
        }
        this.businessVariablesValueDao.saveBusinessVariables(list);
    }
}

