/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.agiledataquery.synonym.service.impl;

import com.digiwin.athena.agiledataquery.synonym.dao.EntityTypeRest;
import com.digiwin.athena.agiledataquery.synonym.dao.SynonymRest;
import com.digiwin.athena.agiledataquery.synonym.domain.EntityType;
import com.digiwin.athena.agiledataquery.synonym.domain.SystemEntityType;
import com.digiwin.athena.agiledataquery.synonym.domain.po.PageVo;
import com.digiwin.athena.agiledataquery.synonym.service.EntityTypeService;
import com.digiwin.athena.agiledataquery.synonym.service.TranslateService;
import com.digiwin.athena.agiledataquery.utils.DWBusinessException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class EntityTypeServiceImpl
implements EntityTypeService {
    @Autowired
    private EntityTypeRest entityTypeDao;
    @Autowired
    private TranslateService translationService;
    @Autowired
    private SynonymRest synonymDao;

    public void insert(EntityType entityType) throws IOException {
        if (entityType == null || StringUtils.isEmpty((CharSequence)entityType.getEntityTypeName()) || StringUtils.isEmpty((CharSequence)entityType.getTenantId())) {
            throw new DWBusinessException("\u5b9e\u4f53\u7c7b\u578b\u53c2\u6570\u6821\u9a8c\u672a\u901a\u8fc7\uff0c\u8bf7\u68c0\u67e5\u4f20\u53c2");
        }
        String entityTypeName = entityType.getEntityTypeName();
        List nameList = this.findNameList(entityType.getTenantId());
        if (nameList.contains(entityTypeName)) {
            throw new DWBusinessException("\u5b9e\u4f53\u540d\u79f0\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5\u4f20\u53c2");
        }
        ArrayList<String> list = new ArrayList<String>();
        list.add(entityTypeName);
        this.entityTypeDao.insert(entityType);
    }

    public void delete(String tenantId, String id) {
        this.entityTypeDao.delete(id, tenantId);
    }

    public void deleteList(String tenantId, List<String> ids) {
        this.entityTypeDao.deleteList(tenantId, ids);
    }

    public List<EntityType> findList(String tenantId) throws IOException {
        if (StringUtils.isEmpty((CharSequence)tenantId)) {
            throw new DWBusinessException("\u79df\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List entityTypes = this.entityTypeDao.findList(tenantId);
        List allSystemEntityType = this.getAllSystemEntityType();
        List systemEntityTypeList = this.convertSystemEntityTypeList(allSystemEntityType);
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)entityTypes)) {
            return this.getEntityLang(systemEntityTypeList);
        }
        ArrayList<String> deleteList = new ArrayList<String>();
        for (EntityType entityType : entityTypes) {
            List initNameList = allSystemEntityType.stream().map(SystemEntityType::getEntityTypeName).collect(Collectors.toList());
            if (initNameList.contains(entityType.getEntityTypeName())) {
                deleteList.add(entityType.getObjectId());
                continue;
            }
            systemEntityTypeList.add(entityType);
        }
        this.deleteList(tenantId, deleteList);
        return this.getEntityLang(systemEntityTypeList);
    }

    public List<String> findNameList(String tenantId) throws IOException {
        List list = this.findList(tenantId);
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)list)) {
            return new ArrayList<String>();
        }
        return list.stream().map(EntityType::getEntityTypeName).collect(Collectors.toList());
    }

    public PageVo<EntityType> getPage(String tid, int pageNum, int pageSize) throws IOException {
        if (StringUtils.isEmpty((CharSequence)tid)) {
            throw new DWBusinessException("\u79df\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        PageVo page = new PageVo();
        List entityTypes = this.entityTypeDao.findList(tid);
        List allSystemEntityType = this.getAllSystemEntityType();
        List systemEntityTypeList = this.convertSystemEntityTypeList(allSystemEntityType);
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)entityTypes)) {
            page = this.subList(systemEntityTypeList, pageNum, pageSize);
        } else {
            ArrayList<String> deleteList = new ArrayList<String>();
            for (EntityType entityType : entityTypes) {
                List initNameList = allSystemEntityType.stream().map(SystemEntityType::getEntityTypeName).collect(Collectors.toList());
                if (initNameList.contains(entityType.getEntityTypeName())) {
                    deleteList.add(entityType.getObjectId());
                    continue;
                }
                systemEntityTypeList.add(entityType);
            }
            this.deleteList(tid, deleteList);
            page = this.subList(systemEntityTypeList, pageNum, pageSize);
        }
        Map map = this.getPerNum(tid);
        for (EntityType entityType : page.getList()) {
            Integer i = (Integer)map.get(entityType.getEntityTypeName());
            if (i == null) {
                entityType.setPerNum(Integer.valueOf(0));
                continue;
            }
            entityType.setPerNum(i);
        }
        List list = page.getList();
        this.getEntityLang(list);
        return page;
    }

    private PageVo<EntityType> subList(List<EntityType> list, int page, int rows) {
        PageVo pageVo = new PageVo();
        List<Object> listSort = new ArrayList();
        int size = list.size();
        int pageStart = 0;
        pageStart = page == 0 ? 0 : page * rows;
        int pageEnd = pageStart + rows;
        if (pageEnd >= size) {
            pageEnd = size;
        }
        if (size > pageStart) {
            listSort = list.subList(pageStart, pageEnd);
        }
        pageVo.setList(listSort);
        pageVo.setTotal(list.size());
        pageVo.setPage(page);
        pageVo.setPageSize(rows);
        pageVo.setTotalPage(list.size() / rows + 1);
        return pageVo;
    }

    public Map<String, Integer> getPerNum(String tid) {
        return this.synonymDao.groupByEntityCount(tid);
    }

    public PageVo<SystemEntityType> getSystemEntityTypePage(int pageNum, int pageSize, String entityTypeName) {
        return this.entityTypeDao.getSystemPage(entityTypeName, pageNum, pageSize);
    }

    public List<SystemEntityType> getAllSystemEntityType() {
        List all = this.entityTypeDao.getAll();
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)all)) {
            List systemEntityTypes = this.initSystemEntityType();
            return systemEntityTypes;
        }
        return all;
    }

    private List<EntityType> convertSystemEntityTypeList(List<SystemEntityType> systemEntityTypes) {
        ArrayList<EntityType> entityTypes = new ArrayList<EntityType>();
        if (org.apache.commons.collections.CollectionUtils.isEmpty(systemEntityTypes)) {
            return entityTypes;
        }
        for (SystemEntityType systemEntityType : systemEntityTypes) {
            EntityType entityType = this.convertSystenmEntityType(systemEntityType);
            entityTypes.add(entityType);
        }
        return entityTypes;
    }

    private EntityType convertSystenmEntityType(SystemEntityType systemEntityType) {
        if (systemEntityType == null) {
            throw new DWBusinessException("\u5904\u7406\u901a\u7528\u5b9e\u4f53\u7c7b\u578b\u5f02\u5e38");
        }
        EntityType entityType = new EntityType();
        entityType.setEntityTypeName(systemEntityType.getEntityTypeName());
        entityType.setDeleteFlag(systemEntityType.getDeleteFlag());
        return entityType;
    }

    private List<SystemEntityType> initSystemEntityType() {
        List nameList = this.getInitNameList();
        ArrayList<SystemEntityType> systemEntityTypeList = new ArrayList<SystemEntityType>();
        for (String name : nameList) {
            SystemEntityType systemEntityType = new SystemEntityType();
            systemEntityType.setEntityTypeName(name);
            systemEntityTypeList.add(systemEntityType);
        }
        this.insertSystemEntityType(systemEntityTypeList);
        return systemEntityTypeList;
    }

    private List<String> getInitNameList() {
        ArrayList<String> nameList = new ArrayList<String>();
        nameList.add("\u7ef4\u5ea6");
        nameList.add("\u76ee\u6807");
        nameList.add("\u54c1\u540d");
        nameList.add("\u5ba2\u6237\u540d\u79f0");
        nameList.add("\u4e1a\u52a1\u5458");
        nameList.add("\u90e8\u95e8\u540d\u79f0");
        nameList.add("\u54c1\u53f7");
        nameList.add("\u8f66\u578b");
        nameList.add("\u8ba1\u5212\u5458");
        return nameList;
    }

    public void deleteSystemEntityType(String id) {
        this.entityTypeDao.deleteSysEntity(id);
    }

    public void insertSystemEntityType(List<SystemEntityType> systemEntityType) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(systemEntityType)) {
            return;
        }
        List collect = systemEntityType.stream().map(SystemEntityType::getEntityTypeName).collect(Collectors.toList());
        List systemListByNames = this.entityTypeDao.getSystemListByNames(collect);
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)systemListByNames)) {
            for (SystemEntityType entityType : systemEntityType) {
                entityType.setObjectId(UUID.randomUUID().toString());
            }
        } else {
            throw new DWBusinessException("\u5f53\u524d\u5b58\u5165\u7684\u5b9e\u4f53\u540d\u79f0\u5b58\u5728\u91cd\u590d\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u3002");
        }
        this.entityTypeDao.saveAll(systemEntityType);
    }

    public List<EntityType> getEntityLang(List<EntityType> entityTypes) throws IOException {
        if (!CollectionUtils.isEmpty(entityTypes)) {
            HashMap<String, String> map = new HashMap<String, String>();
            for (EntityType entityType : entityTypes) {
                map.put(entityType.getEntityTypeName(), entityType.getEntityTypeName());
            }
            Map entityName = this.translationService.translateBatch(map, "entityTypeName");
            for (EntityType entityType : entityTypes) {
                Map stringMultiLanguageDTOMap = (Map)entityName.get(entityType.getEntityTypeName());
                entityType.setLang(stringMultiLanguageDTOMap);
            }
        }
        return entityTypes;
    }
}

