/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.agiledataquery.synonym.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.agiledataquery.config.RedisLock;
import com.digiwin.athena.agiledataquery.domain.definition.actions.MultiLanguageDTO;
import com.digiwin.athena.agiledataquery.synonym.dataSync.dao.SyncAppInfoDao;
import com.digiwin.athena.agiledataquery.synonym.domain.AthenaUserLocal;
import com.digiwin.athena.agiledataquery.synonym.domain.EntityType;
import com.digiwin.athena.agiledataquery.synonym.domain.ExecuteRecordRequest;
import com.digiwin.athena.agiledataquery.synonym.domain.ManualExecuteRequest;
import com.digiwin.athena.agiledataquery.synonym.http.OperatePlatformApiServiceHelper;
import com.digiwin.athena.agiledataquery.synonym.service.EntityTypeService;
import com.digiwin.athena.agiledataquery.synonym.service.ExecuteRecordService;
import com.digiwin.athena.agiledataquery.synonym.service.TranslateService;
import com.digiwin.athena.agiledataquery.synonym.task.DataSynchronizationTask;
import com.digiwin.athena.agiledataquery.utils.DWBusinessException;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.quartz.JobKey;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.impl.matchers.GroupMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ExecuteRecordServiceImpl
implements ExecuteRecordService {
    private static final Logger log = LoggerFactory.getLogger(ExecuteRecordServiceImpl.class);
    @Autowired
    private OperatePlatformApiServiceHelper operatePlatformApiServiceHelper;
    @Autowired
    private SyncAppInfoDao syncAppInfoDao;
    @Autowired
    private DataSynchronizationTask dataSynchronizationTask;
    @Autowired
    private RedisLock redisLock;
    @Autowired
    private EntityTypeService entityTypeService;
    @Autowired
    private TranslateService translationService;
    @Autowired
    private Scheduler scheduler;

    public JSONObject list(ExecuteRecordRequest request) throws IOException {
        String token = AthenaUserLocal.getUser().getToken();
        JSONObject jsonObject = new JSONObject();
        JSONArray jsonArray = jsonObject.getJSONArray("rows");
        JSONArray newjsonArray = new JSONArray();
        if (jsonArray != null && jsonArray.size() > 0) {
            Map entityLang = this.getEntityLang(request.getTenantId());
            for (int i = 0; i < jsonArray.size(); ++i) {
                JSONObject jsonArrayJSONObject = jsonArray.getJSONObject(i);
                String string = jsonArrayJSONObject.getString("entityType");
                Map stringMultiLanguageDTOMap = (Map)entityLang.get(string);
                jsonArrayJSONObject.put("lang", (Object)stringMultiLanguageDTOMap);
                newjsonArray.add((Object)jsonArrayJSONObject);
            }
            jsonObject.put("rows", (Object)newjsonArray);
        }
        return jsonObject;
    }

    public Map<String, Map<String, MultiLanguageDTO>> getEntityLang(String tenantId) throws IOException {
        List entityTypes = this.entityTypeService.findList(tenantId);
        if (!CollectionUtils.isEmpty((Collection)entityTypes)) {
            HashMap<String, String> map = new HashMap<String, String>();
            for (EntityType entityType : entityTypes) {
                map.put(entityType.getEntityTypeName(), entityType.getEntityTypeName());
            }
            return this.translationService.translateBatch(map, "entityType");
        }
        return null;
    }

    public void manual(ManualExecuteRequest request) {
        String tenantId = AthenaUserLocal.getUser().getTenantId();
        String manualSynchronizationTaskLock = null;
        String redisKey = tenantId + "_" + request.getAppName() + "_" + request.getAppType() + "_" + request.getEntityType();
        try {
            List localListPage;
            manualSynchronizationTaskLock = this.redisLock.tryLock(redisKey, 300000L);
            if (manualSynchronizationTaskLock != null) {
                localListPage = this.syncAppInfoDao.findLocalListPage(tenantId);
                if (CollectionUtils.isEmpty((Collection)localListPage)) {
                    log.info("\u672a\u83b7\u53d6\u5230\u5f53\u524d\u79df\u6237\u7684\u6570\u636e\u540c\u6b65\u914d\u7f6e");
                    throw new DWBusinessException("\u672a\u83b7\u53d6\u5230\u5f53\u524d\u79df\u6237\u7684\u6570\u636e\u540c\u6b65\u914d\u7f6e");
                }
                List collect = localListPage.stream().filter(e -> StringUtils.equals((CharSequence)e.getAppName(), (CharSequence)request.getAppName()) && StringUtils.equals((CharSequence)e.getAppType(), (CharSequence)request.getAppType())).collect(Collectors.toList());
                if (CollectionUtils.isEmpty(collect)) {
                    log.info("\u672a\u83b7\u53d6\u5230\u5f53\u524d\u4ea7\u54c1\u7684\u6570\u636e\u540c\u6b65\u914d\u7f6e");
                    throw new DWBusinessException("\u672a\u83b7\u53d6\u5230\u5f53\u524d\u4ea7\u54c1\u7684\u6570\u636e\u540c\u6b65\u914d\u7f6e");
                }
            } else {
                throw new DWBusinessException("\u8be5\u79df\u62375min\u4e4b\u5185\u5df2\u7ecf\u624b\u52a8\u540c\u6b65\u8fc7\u8be5\u4ea7\u54c1\u7684\u5b9e\u4f53\u7c7b\u578b\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            this.dataSynchronizationTask.createJob(localListPage, "manual", request.getEntityType());
        }
        catch (Exception e2) {
            throw new DWBusinessException(e2.getMessage());
        }
    }

    public void deleteJob(String jobId) {
        try {
            String tenantId = AthenaUserLocal.getUser().getTenantId();
            for (JobKey jobKey : this.scheduler.getJobKeys(GroupMatcher.groupEquals((String)tenantId))) {
                if (!jobKey.getName().contains(jobId)) continue;
                this.scheduler.deleteJob(jobKey);
                log.info("\u4efb\u52a1\u5220\u9664\u6210\u529f,jobKeyName:{}", (Object)jobKey.getName());
            }
        }
        catch (SchedulerException e) {
            throw new DWBusinessException(e.getMessage());
        }
    }
}

