/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.agiledataquery.synonym.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.agiledataquery.model.dataSubscription.DataSubscriptionRule;
import com.digiwin.athena.agiledataquery.model.dataSubscription.DataSubscriptionScheduleParam;
import com.digiwin.athena.agiledataquery.service.impl.DataSubscriptionServiceImpl;
import com.digiwin.athena.agiledataquery.synonym.dao.SubscriptionDao;
import com.digiwin.athena.agiledataquery.synonym.domain.AthenaUserLocal;
import com.digiwin.athena.agiledataquery.synonym.domain.Subscription;
import com.digiwin.athena.agiledataquery.synonym.domain.TenantUserResult;
import com.digiwin.athena.agiledataquery.synonym.domain.po.PageVo;
import com.digiwin.athena.agiledataquery.synonym.dto.EntryInfo;
import com.digiwin.athena.agiledataquery.synonym.dto.GetSubscriptionByPageRequest;
import com.digiwin.athena.agiledataquery.synonym.dto.SubscriberInfo;
import com.digiwin.athena.agiledataquery.synonym.http.IamServiceApiHelper;
import com.digiwin.athena.agiledataquery.synonym.service.SubscriptioManageService;
import com.digiwin.athena.agiledataquery.synonym.util.DateUtil;
import com.digiwin.athena.agiledataquery.utils.DWBusinessException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class SubscriptioManageServiceImpl
implements SubscriptioManageService {
    private static final Logger log = LoggerFactory.getLogger(SubscriptioManageServiceImpl.class);
    @Resource
    private SubscriptionDao subscriptionDao;
    @Autowired
    private IamServiceApiHelper iamServiceApiHelper;
    @Autowired
    private DataSubscriptionServiceImpl dataSubscriptionService;

    public void creatOrUpdateEntry(Subscription subscription) {
        String userId = AthenaUserLocal.getUser().getUserId();
        String tenantId = AthenaUserLocal.getUser().getTenantId();
        if (StringUtils.isEmpty((Object)subscription.getCode())) {
            subscription.setCode(UUID.randomUUID().toString().replace("-", ""));
            subscription.setCreateBy(userId);
            subscription.setTenantId(tenantId);
            subscription.setType("entry");
            this.subscriptionDao.createEntry(subscription);
        } else {
            Subscription entryDetail = this.subscriptionDao.getEntryDetail(subscription.getCode());
            if (Objects.isNull(entryDetail)) {
                throw new DWBusinessException("\u8bcd\u6761\u4e0d\u5b58\u5728");
            }
            subscription.setEditBy(userId);
            this.subscriptionDao.updateEntry(subscription);
        }
    }

    public PageVo<Subscription> getSubscriptionPage(GetSubscriptionByPageRequest request) {
        return this.subscriptionDao.getSubscriptionPage(request);
    }

    public PageVo<Subscription> getEntryPage(GetSubscriptionByPageRequest request) {
        return this.subscriptionDao.getEntryPage(request);
    }

    public void deleteSubscription(List<Subscription> dtoList) {
        try {
            List ruleIds;
            String tenantId;
            Object result;
            if (!CollectionUtils.isEmpty(dtoList) && org.apache.commons.lang3.StringUtils.equals((CharSequence)String.valueOf(result = this.dataSubscriptionService.postRemoveDataSubscriptionConfig(tenantId = AthenaUserLocal.getUser().getTenantId(), ruleIds = dtoList.stream().map(Subscription::getCode).collect(Collectors.toList()))), (CharSequence)"success")) {
                this.subscriptionDao.deleteSubscription(tenantId, ruleIds);
            }
        }
        catch (Exception exception) {
            log.error("\u5220\u9664\u8ba2\u9605\u5931\u8d25:{}", (Object)exception.getMessage());
        }
    }

    public TenantUserResult getUsersInTenant(String tenantId, String question) {
        List byQuestion = this.subscriptionDao.findByQuestion(tenantId, question);
        List<Object> existUsers = !CollectionUtils.isEmpty((Collection)byQuestion) ? byQuestion.stream().map(Subscription::getSubscriber).collect(Collectors.toList()) : new ArrayList();
        String integrationToken = this.iamServiceApiHelper.getIntegrationToken(tenantId);
        TenantUserResult tenantUserResult = this.iamServiceApiHelper.queryUserInTenant(tenantId, integrationToken, Integer.valueOf(1000), Integer.valueOf(1));
        List userList = tenantUserResult.getUserList();
        userList.removeIf(e -> existUsers.contains(e.getString("id")));
        return tenantUserResult;
    }

    public JSONArray getRolesInTenant() {
        return this.iamServiceApiHelper.queryRolesInTenant();
    }

    public void createSubscription(Subscription subscriptionDto) {
        String userId = AthenaUserLocal.getUser().getUserId();
        subscriptionDto.setType("subscription");
        subscriptionDto.setCreateBy(userId);
        Subscription subscription = (Subscription)JSONObject.parseObject((String)JSON.toJSONString((Object)subscriptionDto), Subscription.class);
        try {
            String tenantId = subscription.getTenantId();
            EntryInfo entryInfo = subscription.getQuestion();
            String question = entryInfo.getQuestion();
            String sceneCode = entryInfo.getSceneCode();
            List metricIdList = entryInfo.getMetricIdList();
            List datasetIdList = entryInfo.getDatasetIdList();
            List subscribers = subscription.getSubscribers();
            if (!CollectionUtils.isEmpty((Collection)subscribers)) {
                for (SubscriberInfo subscriber : subscribers) {
                    List dataSubscriptionRules = this.dataSubscriptionService.postQueryDataSubscriptionConfig(tenantId, subscriber.getUserId(), question, sceneCode, metricIdList, datasetIdList, "asada");
                    if (CollectionUtils.isEmpty((Collection)dataSubscriptionRules)) {
                        this.createSystemSubscription(tenantId, subscriber, subscription);
                        continue;
                    }
                    List system = dataSubscriptionRules.stream().filter(e -> e.getScheduleParam().getUndeletable()).collect(Collectors.toList());
                    if (CollectionUtils.isEmpty(system)) {
                        this.createSystemSubscription(tenantId, subscriber, subscription);
                        continue;
                    }
                    DataSubscriptionRule dataSubscriptionRule = (DataSubscriptionRule)system.get(0);
                    Subscription subs = this.subscriptionDao.fineOne(new Query((CriteriaDefinition)Criteria.where((String)"tenantId").is((Object)tenantId).and("code").is((Object)dataSubscriptionRule.getRuleId())));
                    if (!Objects.isNull(subs)) continue;
                    Subscription copy = new Subscription();
                    BeanUtils.copyProperties((Object)subscription, (Object)copy);
                    copy.setObjectId(null);
                    copy.setCode(dataSubscriptionRule.getRuleId());
                    copy.setSubscriber(subscriber.getUserId());
                    copy.setSubscriberName(subscriber.getUserName());
                    copy.setSubscribers(null);
                    copy.setCreateDate(DateUtil.getStringDate((Date)new Date()));
                    copy.setEditDate(null);
                    copy.setEditBy(null);
                    this.subscriptionDao.insertOne(copy);
                }
            }
        }
        catch (Exception e2) {
            log.error("\u521b\u5efa\u7cfb\u7edf\u8ba2\u9605\u5931\u8d25:{}", (Object)e2.getMessage());
        }
    }

    public void editSubscription(Subscription subscription) {
        String userId = AthenaUserLocal.getUser().getUserId();
        subscription.setEditBy(userId);
        try {
            DataSubscriptionRule dataSubscriptionRule = (DataSubscriptionRule)this.dataSubscriptionService.getSingleDataSubscriptionConfig(subscription.getCode());
            if (Objects.isNull(dataSubscriptionRule) || !dataSubscriptionRule.getScheduleParam().getUndeletable().booleanValue()) {
                throw new DWBusinessException("\u8be5\u7cfb\u7edf\u8ba2\u9605\u4e0d\u5b58\u5728");
            }
            dataSubscriptionRule.setTriggers(subscription.getFrequency());
            Object result = this.dataSubscriptionService.postAddDataSubscriptionConfig(dataSubscriptionRule);
            if (org.apache.commons.lang3.StringUtils.equals((CharSequence)String.valueOf(result), (CharSequence)"success")) {
                subscription.setEditDate(DateUtil.getStringDate((Date)new Date()));
                this.subscriptionDao.updateEntry(subscription);
            }
        }
        catch (Exception e) {
            log.error("\u7f16\u8f91\u8ba2\u9605\u5931\u8d25:{}", (Object)e.getMessage());
        }
    }

    public Subscription getEntryDetail(String code) {
        return this.subscriptionDao.getEntryDetail(code);
    }

    public void deleteEntry(String code) {
        this.subscriptionDao.deleteEntry(code);
    }

    public List<EntryInfo> querySubscription() {
        String userId;
        String tenantId = AthenaUserLocal.getUser().getTenantId();
        List response = this.subscriptionDao.querySubscription(tenantId, userId = AthenaUserLocal.getUser().getUserId());
        if (CollectionUtils.isEmpty((Collection)response)) {
            return new ArrayList<EntryInfo>();
        }
        ArrayList<EntryInfo> scheduleParams = new ArrayList<EntryInfo>();
        for (DataSubscriptionRule rule : response) {
            List datasetIdList;
            DataSubscriptionScheduleParam scheduleParam = rule.getScheduleParam();
            String ruleId = rule.getRuleId();
            EntryInfo schedule = new EntryInfo();
            schedule.setId(ruleId);
            schedule.setQuestion(scheduleParam.getQuestion());
            schedule.setSceneCode(scheduleParam.getSceneCode());
            List metricIdList = scheduleParam.getMetricIdList();
            if (!CollectionUtils.isEmpty((Collection)metricIdList)) {
                schedule.setMetricIdList(metricIdList);
            }
            if (!CollectionUtils.isEmpty((Collection)(datasetIdList = scheduleParam.getDatasetIdList()))) {
                schedule.setDatasetIdList(datasetIdList);
            }
            scheduleParams.add(schedule);
        }
        return scheduleParams;
    }

    private void createSystemSubscription(String tenantId, SubscriberInfo subscriber, Subscription subscription) {
        try {
            List system;
            List rules;
            DataSubscriptionRule config = DataSubscriptionRule.builder().tenantId(tenantId).caller("agileSubscribe").enableStatus("Y").build();
            DataSubscriptionScheduleParam scheduleParam = this.convertScheduleParam(subscription.getQuestion(), subscriber.getUserId(), subscriber.getUserName());
            config.setScheduleParam(scheduleParam);
            config.setTriggers(subscription.getFrequency());
            Object result = this.dataSubscriptionService.postAddDataSubscriptionConfig(config);
            if (!org.apache.commons.lang3.StringUtils.equals((CharSequence)String.valueOf(result), (CharSequence)"success")) {
                log.error("\u7cfb\u7edf\u8ba2\u9605\u521b\u5efa\u5931\u8d25,tenantId:{},question:{},userId:{}", new Object[]{tenantId, subscription.getQuestion().getQuestion(), subscriber.getUserId()});
            }
            if (!CollectionUtils.isEmpty((Collection)(rules = this.dataSubscriptionService.postQueryDataSubscriptionConfig(tenantId, subscriber.getUserId(), subscription.getQuestion().getQuestion(), subscription.getQuestion().getSceneCode(), subscription.getQuestion().getMetricIdList(), subscription.getQuestion().getDatasetIdList(), "asada"))) && !CollectionUtils.isEmpty(system = rules.stream().filter(e -> e.getScheduleParam().getUndeletable()).collect(Collectors.toList()))) {
                String ruleId = ((DataSubscriptionRule)system.get(0)).getRuleId();
                Subscription copy = new Subscription();
                BeanUtils.copyProperties((Object)subscription, (Object)copy);
                copy.setObjectId(null);
                copy.setCode(ruleId);
                copy.setSubscriber(subscriber.getUserId());
                copy.setSubscriberName(subscriber.getUserName());
                copy.setSubscribers(null);
                copy.setCreateDate(DateUtil.getStringDate((Date)new Date()));
                copy.setEditDate(null);
                copy.setEditBy(null);
                this.subscriptionDao.insertOne(copy);
            }
        }
        catch (Exception ex) {
            log.error("\u7cfb\u7edf\u8ba2\u9605\u521b\u5efa\u5931\u8d25:{}", (Object)ex.getMessage());
        }
    }

    private DataSubscriptionScheduleParam convertScheduleParam(EntryInfo question, String userId, String userName) {
        DataSubscriptionScheduleParam scheduleParam = new DataSubscriptionScheduleParam();
        scheduleParam.setUserId(userId);
        scheduleParam.setAsaCode("asada");
        scheduleParam.setUserName(userName);
        scheduleParam.setQuestion(question.getQuestion());
        scheduleParam.setSceneCode(question.getSceneCode());
        scheduleParam.setMetricIdList(question.getMetricIdList());
        scheduleParam.setDatasetIdList(question.getDatasetIdList());
        scheduleParam.setUndeletable(Boolean.valueOf(true));
        return scheduleParam;
    }
}

