/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.agiledataquery.synonym.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.JSONPath;
import com.alibaba.fastjson.parser.Feature;
import com.digiwin.athena.agiledataquery.domain.definition.actions.MultiLanguageDTO;
import com.digiwin.athena.agiledataquery.synonym.domain.AthenaUserLocal;
import com.digiwin.athena.agiledataquery.synonym.dto.BaseResultDTO;
import com.digiwin.athena.agiledataquery.synonym.enums.OperationEnum;
import com.digiwin.athena.agiledataquery.synonym.service.TranslateService;
import com.digiwin.athena.agiledataquery.utils.DWBusinessException;
import com.digiwin.athena.agiledataquery.utils.Utils;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.util.ObjectUtils;
import org.springframework.web.client.RestTemplate;

@Service
public class TranslateServiceImpl
implements TranslateService {
    private static final Logger log = LoggerFactory.getLogger(TranslateServiceImpl.class);
    public static final String TRANSLATE_API = "/restful/service/translater/IDWTranslateService/translate";
    public static final String TRANSLATE_CUSTOM_API = "/restful/service/translater/IDWTranslateService/translateCustom";
    @Autowired
    RestTemplate restTemplate;
    @Value(value="${translateUrl}")
    private String translationUrl;

    public Map<String, Map<String, MultiLanguageDTO>> translateBatch(Map<String, String> content, String key) throws IOException {
        JSONObject zh2Hant = this.callTranslateService(content);
        if (Objects.isNull(zh2Hant)) {
            log.error("fail to call translate service");
            return new HashMap<String, Map<String, MultiLanguageDTO>>();
        }
        HashMap<String, Map<String, MultiLanguageDTO>> langMap = new HashMap<String, Map<String, MultiLanguageDTO>>();
        for (Map.Entry<String, String> entry : content.entrySet()) {
            MultiLanguageDTO multiLanguageDTO = new MultiLanguageDTO();
            multiLanguageDTO.setEn_US(entry.getValue());
            multiLanguageDTO.setZh_TW(zh2Hant.getString(entry.getKey()));
            multiLanguageDTO.setZh_CN(entry.getValue());
            HashMap<String, MultiLanguageDTO> keyLang = new HashMap<String, MultiLanguageDTO>();
            keyLang.put(key, multiLanguageDTO);
            langMap.put(entry.getKey(), keyLang);
        }
        return langMap;
    }

    public Map<String, Map<String, Map<String, String>>> translateBatchToMap(Map<String, String> content, String key) throws IOException {
        JSONObject zh2Hant = this.callTranslateService(content);
        if (Objects.isNull(zh2Hant)) {
            return new HashMap<String, Map<String, Map<String, String>>>();
        }
        HashMap<String, Map<String, Map<String, String>>> langMap = new HashMap<String, Map<String, Map<String, String>>>();
        for (Map.Entry<String, String> entry : content.entrySet()) {
            HashMap<String, String> lang = new HashMap<String, String>();
            lang.put("en_US", entry.getValue());
            lang.put("zh_TW", zh2Hant.getString(entry.getKey()));
            lang.put("zh_CN", entry.getValue());
            HashMap<String, HashMap<String, String>> keyLang = new HashMap<String, HashMap<String, String>>();
            keyLang.put(key, lang);
            langMap.put(entry.getKey(), keyLang);
        }
        return langMap;
    }

    private JSONObject callTranslateService(Map<String, String> content) throws IOException {
        String url = this.translationUrl + TRANSLATE_API;
        JSONObject req = new JSONObject();
        req.put("content", content);
        String[] convertTypes = new String[]{"zh2Hant"};
        req.put("convertTypes", (Object)convertTypes);
        String response = Utils.postJson((String)url, null, (Map)req);
        if (StringUtils.isEmpty((CharSequence)response)) {
            return null;
        }
        JSONObject jsonObject = JSONObject.parseObject((String)response);
        Integer status = jsonObject.getInteger("status");
        if (status != 200) {
            return null;
        }
        JSONObject data = jsonObject.getJSONObject("response").getJSONObject("data");
        return data.getJSONObject("zh2Hant");
    }

    public JSONObject translate(JSONObject param) throws IOException {
        String url = this.translationUrl + TRANSLATE_API;
        String response = Utils.postJson((String)url, null, (Map)param);
        if (StringUtils.isEmpty((CharSequence)response)) {
            throw new DWBusinessException("Request for translation interface failed");
        }
        JSONObject jsonObject = JSONObject.parseObject((String)response);
        Integer status = jsonObject.getInteger("status");
        if (status != 200) {
            throw new DWBusinessException(jsonObject.getString("errorMessage"));
        }
        JSONObject data = jsonObject.getJSONObject("response").getJSONObject("data");
        return data;
    }

    public JSONObject translateCustom(JSONObject param) throws IOException {
        int disableDecimalFeature = JSON.DEFAULT_PARSER_FEATURE & ~Feature.UseBigDecimal.getMask();
        param = (JSONObject)JSONObject.parseObject((String)param.toJSONString(), JSONObject.class, (int)disableDecimalFeature, (Feature[])new Feature[0]);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("content", (Object)param);
        String[] convertTypes = new String[]{"zh2Hant"};
        jsonObject.put("convertTypes", (Object)convertTypes);
        String url = this.translationUrl + TRANSLATE_CUSTOM_API;
        String response = Utils.postJson((String)url, null, (Map)jsonObject);
        if (StringUtils.isEmpty((CharSequence)response)) {
            throw new DWBusinessException("Request for translation interface failed");
        }
        JSONObject result = (JSONObject)JSONObject.parseObject((String)response, JSONObject.class, (int)disableDecimalFeature, (Feature[])new Feature[0]);
        Integer status = result.getInteger("status");
        Object eval = JSONPath.eval((Object)result, (String)"response.success");
        if (status != 200 || ObjectUtils.isEmpty((Object)eval) || !((Boolean)eval).booleanValue()) {
            log.error("Request for translation interface failed, errorMessage : " + result.getString("errorMessage"));
            return param;
        }
        JSONObject data = result.getJSONObject("response").getJSONObject("data");
        return data;
    }

    public JSONObject translateBatchToMap(Map<String, String> content) throws IOException {
        JSONObject zh2Hant = this.callTranslateService(content);
        if (Objects.isNull(zh2Hant)) {
            return null;
        }
        return zh2Hant;
    }

    public Map<String, Map<String, String>> getTranslateLang(String content, String key) throws IOException {
        HashMap<String, Map<String, String>> result = new HashMap<String, Map<String, String>>();
        HashMap<String, String> langResult = new HashMap<String, String>();
        JSONObject jo = new JSONObject();
        jo.put("content", (Object)content);
        jo.put("convertTypes", Arrays.asList("zh2Hant", "zh2En"));
        JSONObject jsonObject = this.translateCustom(jo);
        JSONObject lang = jsonObject.getJSONObject("lang");
        if (Objects.isNull(lang)) {
            langResult.put("zh_CN", content);
            langResult.put("zh_TW", content);
            langResult.put("en_US", content);
        } else {
            langResult.put("zh_CN", lang.getJSONObject("content").getString("zh_CN"));
            langResult.put("zh_TW", lang.getJSONObject("content").getString("zh_TW"));
            langResult.put("en_US", lang.getJSONObject("content").getString("zh_CN"));
        }
        result.put(key, langResult);
        return result;
    }

    public Map<String, MultiLanguageDTO> getTranslateMultiLanguageDTO(Map<String, String> content) throws IOException {
        JSONObject zh2Hant = this.callTranslateService(content);
        if (Objects.isNull(zh2Hant)) {
            log.error("fail to call translate service");
            return new HashMap<String, MultiLanguageDTO>();
        }
        HashMap<String, MultiLanguageDTO> langMap = new HashMap<String, MultiLanguageDTO>();
        for (Map.Entry<String, String> entry : content.entrySet()) {
            MultiLanguageDTO multiLanguageDTO = new MultiLanguageDTO();
            multiLanguageDTO.setEn_US(entry.getValue());
            multiLanguageDTO.setZh_TW(zh2Hant.getString(entry.getKey()));
            multiLanguageDTO.setZh_CN(entry.getValue());
            langMap.put(entry.getKey(), multiLanguageDTO);
        }
        return langMap;
    }

    public Map translation(List<String> key, Boolean localeIsTarget) {
        String locale = AthenaUserLocal.getLocale();
        HttpHeaders headers = new HttpHeaders();
        String requestUrl = this.translationUrl + 11;
        HashMap<String, Object> requestMap = new HashMap<String, Object>();
        if ("zh_CN".equalsIgnoreCase(locale)) {
            requestMap.put("convertTypes", Collections.singletonList(localeIsTarget != false ? "zh2Hans" : "zh2Hant"));
        }
        if ("zh_TW".equalsIgnoreCase(locale)) {
            requestMap.put("convertTypes", Collections.singletonList(localeIsTarget != false ? "zh2Hant" : "zh2Hans"));
        }
        ConcurrentHashMap<String, String> content = new ConcurrentHashMap<String, String>();
        for (String k : key) {
            content.put(k, k);
        }
        requestMap.put("content", content);
        HttpEntity requestEntity = new HttpEntity(requestMap, (MultiValueMap)headers);
        ResponseEntity exchange = this.restTemplate.exchange(requestUrl, HttpMethod.POST, requestEntity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
        Map translationMap = (Map)((BaseResultDTO)exchange.getBody()).checkResponse("translationUrl");
        return (Map)translationMap.get("data");
    }

    public String getTranslateLocale(String content, String locale) throws IOException {
        JSONObject jo = new JSONObject();
        jo.put("content", (Object)content);
        jo.put("convertTypes", Arrays.asList("zh2Hant", "zh2En"));
        JSONObject jsonObject = this.translateCustom(jo);
        JSONObject lang = jsonObject.getJSONObject("lang");
        if (null == lang) {
            return content;
        }
        return lang.getJSONObject("content").getString(locale);
    }

    public String getTranslateLocaleByOperation(String content, String locale, String operation) throws IOException {
        if (!OperationEnum.GET.getCode().equals(operation)) {
            return content;
        }
        JSONObject jo = new JSONObject();
        jo.put("content", (Object)content);
        jo.put("convertTypes", Arrays.asList("zh2Hant", "zh2En"));
        JSONObject jsonObject = this.translateCustom(jo);
        JSONObject lang = jsonObject.getJSONObject("lang");
        if (null == lang) {
            return content;
        }
        return lang.getJSONObject("content").getString(locale);
    }

    public List<Object> translateCustomInList(List<Object> paramList) throws IOException {
        JSONObject jo = new JSONObject();
        jo.put("content", paramList);
        JSONObject jsonObject = this.translateCustom(jo);
        List result = JSONArray.parseArray((String)JSON.toJSONString((Object)jsonObject.get((Object)"content")), Object.class);
        if (!ObjectUtils.isEmpty((Object)result)) {
            return result;
        }
        return paramList;
    }

    private void handleJsonparam(JSONObject param) {
        Set keySet = param.keySet();
        List<Object> keyList = Arrays.asList(keySet.toArray());
        for (int i = 0; i < keyList.size(); ++i) {
            String key = (String)keyList.get(i);
            if ("language".equals(key)) {
                param.remove((Object)key);
                continue;
            }
            Object value = param.get((Object)key);
            if (value instanceof JSONObject) {
                this.handleJsonparam((JSONObject)value);
                continue;
            }
            if (!(value instanceof JSONArray)) continue;
            for (int j = 0; j < ((JSONArray)value).size(); ++j) {
                Object value1 = ((JSONArray)value).get(j);
                if (!(value1 instanceof JSONObject)) continue;
                this.handleJsonparam((JSONObject)value1);
            }
        }
    }

    private void handleJsonresponse(JSONObject json) {
        Set keySet = json.keySet();
        List<Object> keyList = Arrays.asList(keySet.toArray());
        for (int i = 0; i < keyList.size(); ++i) {
            Object value;
            String key = (String)keyList.get(i);
            if ("lang".equals(key)) {
                value = json.get((Object)"lang");
                json.put("language", value);
                continue;
            }
            value = json.get((Object)key);
            if (value instanceof JSONObject) {
                this.handleJsonresponse((JSONObject)value);
                continue;
            }
            if (!(value instanceof JSONArray)) continue;
            for (int j = 0; j < ((JSONArray)value).size(); ++j) {
                Object value1 = ((JSONArray)value).get(j);
                if (!(value1 instanceof JSONObject)) continue;
                this.handleJsonresponse((JSONObject)value1);
            }
        }
    }
}

