/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.agiledataquery.synonym.task;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.agiledataquery.clients.IamService;
import com.digiwin.athena.agiledataquery.config.RedisLock;
import com.digiwin.athena.agiledataquery.synonym.domain.ExecuteRecord;
import com.digiwin.athena.agiledataquery.synonym.domain.JobEntity;
import com.digiwin.athena.agiledataquery.synonym.http.OperatePlatformApiServiceHelper;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpMethod;

public abstract class AbstractQuartzJob
implements Job {
    private static final Logger log = LoggerFactory.getLogger(AbstractQuartzJob.class);
    @Autowired
    private OperatePlatformApiServiceHelper operatePlatformApiServiceHelper;
    @Autowired
    private RedisLock redisLock;
    @Autowired
    private IamService iamService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        String jobExecuteLock = null;
        JobEntity jobEntity = new JobEntity();
        Object o = jobExecutionContext.getMergedJobDataMap().get((Object)"TASK_PROPERTIES");
        JobEntity job = (JobEntity)JSONObject.parseObject((String)JSON.toJSONString((Object)o), JobEntity.class);
        BeanUtils.copyProperties((Object)job, (Object)jobEntity);
        try {
            jobExecuteLock = this.redisLock.tryLock(jobEntity.getJobId(), 300000L);
            if (jobExecuteLock != null) {
                log.info("\u4efb\u52a1\u5f00\u59cb\u6267\u884c\uff0cjobId:{},cron:{}", (Object)jobEntity.getJobId(), (Object)jobEntity.getCronExpression());
                this.doExecute(jobExecutionContext, jobEntity);
                this.after(jobExecutionContext, jobEntity, null);
            } else {
                log.info("\u6ca1\u6709\u83b7\u53d6\u5230\u9501");
            }
        }
        catch (Exception e) {
            log.error("\u4efb\u52a1\u6267\u884c\u5f02\u5e38  - \uff1a", (Throwable)e);
        }
        finally {
            if (jobExecuteLock != null) {
                log.info("\u91ca\u653e\u9501jobExecuteLock\uff1a{}", (Object)jobExecuteLock);
                this.redisLock.unlock(jobEntity.getJobId(), jobExecuteLock);
            }
        }
    }

    protected void after(JobExecutionContext context, JobEntity sysJob, Exception e) throws Exception {
        JSONObject invoke;
        ExecuteRecord executeRecord = new ExecuteRecord();
        executeRecord.setExecuteResult(Boolean.valueOf(sysJob.getExecuteResult() != null && sysJob.getExecuteResult() != false));
        executeRecord.setExecuteType(sysJob.getExecuteType());
        executeRecord.setSize(Long.valueOf(sysJob.getSize() == null ? 0L : (long)sysJob.getSize().intValue()));
        executeRecord.setProductName(sysJob.getProductName());
        executeRecord.setEntityType(sysJob.getEntityType());
        executeRecord.setSystemEnv(sysJob.getCurrEnv());
        executeRecord.setTenantId(sysJob.getTenantId());
        Date date = new Date();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String format = dateFormat.format(date);
        executeRecord.setExecuteTime(format);
        Object login = this.iamService.login(sysJob.getTenantId());
        JSONObject loginJsonObject = JSON.parseObject((String)JSON.toJSONString((Object)login));
        String token = null;
        if (StringUtils.equals((CharSequence)sysJob.getTenantId(), (CharSequence)loginJsonObject.getString("tenantId"))) {
            token = loginJsonObject.getString("token");
            log.info("\u6267\u884c\u8bb0\u5f55-\u767b\u5f55\u63a5\u53e3\u8fd4\u56detoken:{}", (Object)token);
        }
        if (Objects.isNull(invoke = this.operatePlatformApiServiceHelper.apiInvoke(HttpMethod.POST, JSONObject.toJSONString((Object)executeRecord), "/system/execute/record/add", token)) || invoke.getInteger("code") != 200) {
            log.info("\u63d2\u5165\u6267\u884c\u8bb0\u5f55\u5931\u8d25,jobId:{}", (Object)sysJob.getJobId());
        }
        log.info("\u63d2\u5165\u6267\u884c\u8bb0\u5f55\u6210\u529f,jobId:{}", (Object)sysJob.getJobId());
    }

    protected abstract void doExecute(JobExecutionContext var1, JobEntity var2) throws Exception;
}

