/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.agiledataquery.synonym.task;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.agiledataquery.clients.IamService;
import com.digiwin.athena.agiledataquery.synonym.dao.SynonymRest;
import com.digiwin.athena.agiledataquery.synonym.dataSync.domain.po.OnPremAppData;
import com.digiwin.athena.agiledataquery.synonym.dataSync.domain.vo.AppInfoVo;
import com.digiwin.athena.agiledataquery.synonym.dataSync.service.SyncAppInfoService;
import com.digiwin.athena.agiledataquery.synonym.domain.AthenaUser;
import com.digiwin.athena.agiledataquery.synonym.domain.AthenaUserLocal;
import com.digiwin.athena.agiledataquery.synonym.domain.JobEntity;
import com.digiwin.athena.agiledataquery.synonym.domain.Synonym;
import com.digiwin.athena.agiledataquery.synonym.http.DcdpinteractApiHelper;
import com.digiwin.athena.agiledataquery.synonym.http.EocServiceHelper;
import com.digiwin.athena.agiledataquery.synonym.http.ModelCenterApiHelper;
import com.digiwin.athena.agiledataquery.synonym.service.SynonymService;
import com.digiwin.athena.agiledataquery.synonym.task.AbstractQuartzJob;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.quartz.JobExecutionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class DataSyncQuartzJobExecution
extends AbstractQuartzJob {
    private static final Logger log = LoggerFactory.getLogger(DataSyncQuartzJobExecution.class);
    @Autowired
    private DcdpinteractApiHelper dcdpinteractApiHelper;
    @Autowired
    private ModelCenterApiHelper modelCenterApiHelper;
    @Autowired
    private SynonymService synonymService;
    @Autowired
    private IamService iamService;
    @Autowired
    private EocServiceHelper eocServiceHelper;
    @Autowired
    private SyncAppInfoService syncAppInfoService;
    @Autowired
    private SynonymRest synonymRest;
    private static final Map<String, String> dbMap = new HashMap();

    protected void doExecute(JobExecutionContext context, JobEntity sysJob) throws Exception {
        JSONObject data;
        Object user = context.getMergedJobDataMap().get((Object)"TASK_USER");
        Object login = this.iamService.login(sysJob.getTenantId());
        JSONObject loginJsonObject = JSON.parseObject((String)JSON.toJSONString((Object)login));
        String token = null;
        Long tenantSid = null;
        if (StringUtils.equals((CharSequence)sysJob.getTenantId(), (CharSequence)loginJsonObject.getString("tenantId"))) {
            token = loginJsonObject.getString("token");
            tenantSid = loginJsonObject.getLong("tenantSid");
            log.info("\u4efb\u52a1\u6267\u884c-\u767b\u5f55\u63a5\u53e3\u8fd4\u56detoken:{}", (Object)token);
        }
        if (Objects.isNull(user)) {
            AthenaUser user1 = AthenaUser.builder().build();
            user1.setTenantId(sysJob.getTenantId());
            user1.setLocale("zh_CN");
            user1.setToken(token);
            user = user1;
        }
        AthenaUserLocal.setUser((AthenaUser)((AthenaUser)user));
        String total = sysJob.getTotalQuerySchema();
        String select = sysJob.getSelectQuerySchema();
        if (StringUtils.isNotEmpty((CharSequence)total) && StringUtils.isNotEmpty((CharSequence)select)) {
            log.info("\u8c03\u6a21\u578b\u4e2d\u5fc3\u83b7\u53d6\u6570\u636e");
            log.info("totalQuerySchema:{}", (Object)total);
            JSONObject dataByModel = this.modelCenterApiHelper.getDataByModel(JSONObject.parseObject((String)total), token, tenantSid, sysJob.getUserEmail());
            Long totalNum = dataByModel.getLong("total");
            if (Objects.isNull(totalNum) || totalNum <= 0L) {
                log.info("\u8c03\u6a21\u578b\u4e2d\u5fc3\u6ca1\u67e5\u8be2\u5230\u6570\u636e!");
            } else {
                ArrayList properNounTotal = new ArrayList();
                long batchSize = 1000L;
                long batch = totalNum / batchSize + 1L;
                JSONObject select1 = JSONObject.parseObject((String)select);
                List synonymsInDb = this.synonymRest.findList(sysJob.getTenantId(), new ArrayList());
                for (long i = 0L; i < batch; ++i) {
                    JSONObject page = select1.getJSONObject("page");
                    page.put("pageSize", (Object)batchSize);
                    page.put("pageNo", (Object)(i + 1L));
                    select1.put("page", (Object)page);
                    log.info("selectQuerySchema:{}", (Object)select1);
                    JSONObject dataByModel1 = this.modelCenterApiHelper.getDataByModel(select1, token, tenantSid, sysJob.getUserEmail());
                    JSONArray list = dataByModel1.getJSONArray("data");
                    if (CollectionUtils.isEmpty((Collection)list)) {
                        log.info("\u8c03\u6a21\u578b\u4e2d\u5fc3\u6ca1\u67e5\u8be2\u5230\u6570\u636e1");
                        continue;
                    }
                    this.dataProcess(list, sysJob, user, properNounTotal, synonymsInDb);
                }
                sysJob.setSize(Integer.valueOf(properNounTotal.size()));
                sysJob.setExecuteResult(Boolean.valueOf(properNounTotal.size() > 0));
            }
        }
        String totalSql = sysJob.getTotalSql();
        String selectSql = sysJob.getSelectSql();
        if (StringUtils.isNotEmpty((CharSequence)totalSql) && StringUtils.isNotEmpty((CharSequence)selectSql)) {
            log.info("\u8c03\u5730\u7aef\u83b7\u53d6\u6570\u636e");
            AppInfoVo localAppInfo = this.syncAppInfoService.getLocalAppInfo(sysJob.getTenantId(), false);
            log.info("onPremDataSync.localAppInfo:{}", (Object)localAppInfo);
            List onPremAppDataList = localAppInfo.getOnPremAppDataList();
            ArrayList properNounTotal = new ArrayList();
            if (CollectionUtils.isEmpty((Collection)onPremAppDataList)) {
                this.onPremDataSync(totalSql, selectSql, token, sysJob, user, null, properNounTotal);
            } else {
                List collect = onPremAppDataList.stream().filter(e -> StringUtils.equals((CharSequence)e.getChatBIProductCode(), (CharSequence)sysJob.getProductCode())).collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(collect)) {
                    for (OnPremAppData data2 : collect) {
                        this.onPremDataSync(totalSql, selectSql, token, sysJob, user, data2, properNounTotal);
                    }
                }
            }
            sysJob.setSize(Integer.valueOf(properNounTotal.size()));
            sysJob.setExecuteResult(Boolean.valueOf(!properNounTotal.isEmpty()));
        }
        if (StringUtils.equals((CharSequence)sysJob.getEntityType(), (CharSequence)"\u516c\u53f8\u540d\u79f0") && Objects.nonNull(data = this.eocServiceHelper.getCompanyInfos(token))) {
            ArrayList properNounTotal = new ArrayList();
            JSONArray companyInfos = data.getJSONArray("list");
            if (CollectionUtils.isEmpty((Collection)companyInfos)) {
                log.info("\u8c03eoc\u6ca1\u67e5\u8be2\u5230\u79df\u6237\u7684\u516c\u53f8\u6570\u636e\uff0c\u79df\u6237id:{}", (Object)sysJob.getTenantId());
                return;
            }
            List synonymsInDb = this.synonymRest.findList(sysJob.getTenantId(), new ArrayList());
            sysJob.setProperNoun("name");
            this.dataProcess(companyInfos, sysJob, user, properNounTotal, synonymsInDb);
            sysJob.setSize(Integer.valueOf(properNounTotal.size()));
            sysJob.setExecuteResult(Boolean.valueOf(properNounTotal.size() > 0));
        }
    }

    private void onPremDataSync(String totalSql, String selectSql, String token, JobEntity sysJob, Object user, OnPremAppData data, List<String> properNounTotal) throws IOException {
        JSONObject body = new JSONObject();
        body.put("totalSQL", (Object)totalSql.replace(";", ""));
        if (Objects.nonNull(data)) {
            body.put("chatBIDbName", (Object)data.getChatBIDbName());
            body.put("chatBIInstanceInfo", (Object)data.getChatBIInstanceInfo());
        }
        body.put("selectSQL", (Object)this.getTestSql(sysJob.getProductCode()));
        log.info("onPremDataSync.totalSqlBody:{},token:{}", (Object)body, (Object)token);
        JSONObject detail = this.dcdpinteractApiHelper.getDataBySql(body, token);
        String total1 = detail.getString("total");
        if (StringUtils.isEmpty((CharSequence)total1) || "0".equals(total1)) {
            log.info("\u8c03\u5730\u7aef\u6ca1\u67e5\u8be2\u5230\u6570\u636e");
        } else {
            List synonymsInDb = this.synonymRest.findList(sysJob.getTenantId(), new ArrayList());
            Long t = Long.parseLong(total1);
            long batchSize = 1000L;
            long batch = t / batchSize + 1L;
            String selSql = selectSql.replace(";", "");
            for (long i = 0L; i < batch; ++i) {
                String sql = (String)dbMap.get(sysJob.getProductCode());
                if (StringUtils.isEmpty((CharSequence)sql)) {
                    sql = (String)dbMap.get("DEFAULT");
                }
                String select = "";
                if (sql.startsWith("SELECT")) {
                    select = StrUtil.format((CharSequence)sql, (Object[])new Object[]{selSql, i * batchSize, i * batchSize + batchSize});
                } else if (sql.startsWith(" ORDER")) {
                    select = selSql + StrUtil.format((CharSequence)sql, (Object[])new Object[]{i * batchSize, batchSize});
                }
                JSONObject reqBody = new JSONObject();
                reqBody.put("selectSQL", (Object)select);
                reqBody.put("totalSQL", (Object)totalSql);
                if (Objects.nonNull(data)) {
                    reqBody.put("chatBIDbName", (Object)data.getChatBIDbName());
                    reqBody.put("chatBIInstanceInfo", (Object)data.getChatBIInstanceInfo());
                }
                log.info("onPremDataSync.selectSqlBody:{}", (Object)reqBody);
                JSONObject detail1 = this.dcdpinteractApiHelper.getDataBySql(reqBody, token);
                JSONArray list = detail1.getJSONArray("list");
                if (CollectionUtils.isEmpty((Collection)list)) {
                    log.info("\u8c03\u5730\u7aef\u6ca1\u67e5\u8be2\u5230\u6570\u636e1");
                    continue;
                }
                this.dataProcess(list, sysJob, user, properNounTotal, synonymsInDb);
            }
        }
    }

    private String getTestSql(String productCode) {
        String sql = (String)dbMap.get(productCode);
        if (StringUtils.isEmpty((CharSequence)sql)) {
            sql = (String)dbMap.get("DEFAULT");
        }
        String select = "";
        select = sql.startsWith("SELECT") ? "select 1 from dual" : "select 1 as test";
        return select;
    }

    private void dataProcess(JSONArray list, JobEntity sysJob, Object user, List<String> properNounTotal, List<Synonym> synonyms) throws IOException {
        JSONObject jsonObject;
        Boolean pushResult;
        HashMap<String, Synonym> synonymMap = new HashMap<String, Synonym>();
        ArrayList<String> local = new ArrayList<String>();
        for (int j = 0; j < list.size(); ++j) {
            JSONObject o = (JSONObject)JSONObject.parseObject((String)JSON.toJSONString((Object)list.get(j)), JSONObject.class);
            String properNoun = o.getString(sysJob.getProperNoun());
            if (synonymMap.containsKey(properNoun)) {
                Synonym syno = (Synonym)synonymMap.get(properNoun);
                if (StringUtils.isNotEmpty((CharSequence)sysJob.getSynonym())) {
                    String synoStr = o.getString(sysJob.getSynonym());
                    List zhCn = syno.getZh_CN();
                    if (!zhCn.contains(synoStr)) {
                        zhCn.add(synoStr);
                    }
                }
            } else {
                Synonym synonym = new Synonym();
                synonym.setEntityTypeName(sysJob.getEntityType());
                synonym.setTenantId(sysJob.getTenantId());
                synonym.setProperNoun(o.getString(sysJob.getProperNoun()));
                if (StringUtils.isNotEmpty((CharSequence)sysJob.getSynonym())) {
                    ArrayList<String> zhCns = new ArrayList<String>();
                    zhCns.add(o.getString(sysJob.getSynonym()));
                    synonym.setZh_CN(zhCns);
                }
                synonymMap.put(properNoun, synonym);
            }
            if (properNounTotal.contains(properNoun)) continue;
            properNounTotal.add(properNoun);
            local.add(properNoun);
        }
        ArrayList synonymList = new ArrayList();
        if (!CollectionUtils.isEmpty(synonymMap)) {
            synonymMap.forEach((key, value) -> {
                List zhCn = value.getZh_CN();
                String join = StringUtils.join((Iterable)zhCn, (String)"/");
                value.setZh_CN_Str(join);
                synonymList.add(value);
            });
        }
        if (Objects.nonNull(user)) {
            AthenaUserLocal.setUser((AthenaUser)((AthenaUser)user));
        }
        if (!Objects.nonNull(pushResult = (jsonObject = this.synonymService.batchSave(synonymList, sysJob.getTenantId(), synonyms)).getBoolean("pushResult")) || !pushResult.booleanValue()) {
            properNounTotal.removeAll(local);
        }
    }

    static {
        dbMap.put("TOPGP", "SELECT * FROM ({}) A WHERE rn >= {} AND rn < {}");
        dbMap.put("T100", "SELECT * FROM ({}) A WHERE rn >= {} AND rn < {}");
        dbMap.put("WF", " ORDER BY 1 OFFSET {} ROWS FETCH NEXT {} ROWS ONLY");
        dbMap.put("E10", " ORDER BY 1 OFFSET {} ROWS FETCH NEXT {} ROWS ONLY");
        dbMap.put("DEFAULT", " ORDER BY 1 OFFSET {} ROWS FETCH NEXT {} ROWS ONLY");
    }
}

