/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.agiledataquery.synonym.thread;

import com.digiwin.athena.agiledataquery.synonym.domain.EntityType;
import com.digiwin.athena.agiledataquery.synonym.domain.ErrorSynonym;
import com.digiwin.athena.agiledataquery.synonym.domain.Synonym;
import com.digiwin.athena.agiledataquery.synonym.domain.po.CallableReturn;
import com.digiwin.athena.agiledataquery.synonym.service.impl.SynonymUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.commons.collections.CollectionUtils;

public class SynonymGroupCallable
implements Callable<CallableReturn> {
    private List<Synonym> synonyms;
    private Map<String, Synonym> synonymMap;
    private String tid;
    private List<EntityType> entityTypes;

    public SynonymGroupCallable(List<Synonym> synonyms, Map<String, Synonym> synonymMap, String tid, List<EntityType> entityTypes) {
        this.synonyms = synonyms;
        this.synonymMap = synonymMap;
        this.tid = tid;
        this.entityTypes = entityTypes;
    }

    @Override
    public CallableReturn call() throws Exception {
        CallableReturn callableReturn = new CallableReturn();
        HashMap<String, List> synonymGroupMap = new HashMap<String, List>();
        if (CollectionUtils.isEmpty((Collection)this.synonyms)) {
            callableReturn.setMap(synonymGroupMap);
            return callableReturn;
        }
        ErrorSynonym errorSynonym = SynonymUtil.checkSynonyms((List)this.synonyms, (Map)this.synonymMap, (List)this.entityTypes);
        if (errorSynonym != null) {
            callableReturn.setErrorSynonym(errorSynonym);
            return callableReturn;
        }
        if (this.synonymMap == null || this.synonymMap.isEmpty()) {
            synonymGroupMap.put("1", this.synonyms);
            callableReturn.setMap(synonymGroupMap);
            return callableReturn;
        }
        synonymGroupMap.put("1", new ArrayList());
        synonymGroupMap.put("2", new ArrayList());
        for (Synonym synonym : this.synonyms) {
            String key = synonym.getEntityTypeName() + "_" + synonym.getProperNoun();
            Synonym old = (Synonym)this.synonymMap.get(key);
            if (old != null) {
                Synonym syncSynonym = SynonymUtil.syncSynonym((Synonym)old, (Synonym)synonym);
                ((List)synonymGroupMap.get("2")).add(syncSynonym);
                continue;
            }
            synonym.setTenantId(this.tid);
            synonym.setObjectId(this.tid + "_" + key);
            ((List)synonymGroupMap.get("1")).add(synonym);
        }
        callableReturn.setMap(synonymGroupMap);
        return callableReturn;
    }
}

