/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.agiledataquery.synonym.util;

import cn.hutool.core.date.DateUtil;
import com.digiwin.athena.agiledataquery.synonym.domain.ExecuteFrequency;
import com.digiwin.athena.agiledataquery.utils.DWBusinessException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Map;

/*
 * Exception performing whole class analysis ignored.
 */
public class DateTimeToCronUtils {
    private static final Map<String, String> dateFormatMap = new HashMap();

    public static String getCron(LocalDateTime date, String dateFormat) {
        return DateTimeToCronUtils.formatDateByPattern((LocalDateTime)date, (String)((String)dateFormatMap.get(dateFormat)));
    }

    public static String getMonthCron(String[] time, String day, String dateFormat) {
        String df = (String)dateFormatMap.get(dateFormat);
        String cron = df.replace("mm", time[1]);
        cron = cron.replace("HH", time[0]);
        cron = cron.replace("DD", day);
        return cron;
    }

    public static String formatDateByPattern(LocalDateTime date, String dateFormat) {
        return DateUtil.format((LocalDateTime)date, (String)dateFormat);
    }

    public static String getCron(ExecuteFrequency frequency) {
        String frequency1 = frequency.getFrequency();
        String[] time = frequency.getTime().split(":");
        LocalDate localDate = LocalDate.now();
        LocalDateTime dateTime = localDate.atTime(Integer.parseInt(time[0]), Integer.parseInt(time[1]));
        String cron = "";
        switch (frequency1) {
            case "dayly": {
                cron = DateTimeToCronUtils.getCron((LocalDateTime)dateTime, (String)"EVERYDAY");
                break;
            }
            case "weekly": {
                String week = frequency.getWeek();
                cron = DateTimeToCronUtils.getCron((LocalDateTime)dateTime, (String)week);
                break;
            }
            case "monthly": {
                cron = DateTimeToCronUtils.getMonthCron((String[])time, (String)frequency.getDay(), (String)"MONTH");
                break;
            }
            default: {
                throw new DWBusinessException("\u6267\u884c\u9891\u7387\u4f20\u503c\u4e0d\u6b63\u786e");
            }
        }
        return cron;
    }

    static {
        dateFormatMap.put("MONTH", "0 mm HH DD * ?");
        dateFormatMap.put("7", "ss mm HH ? * 1");
        dateFormatMap.put("1", "ss mm HH ? * 2");
        dateFormatMap.put("2", "ss mm HH ? * 3");
        dateFormatMap.put("3", "ss mm HH ? * 4");
        dateFormatMap.put("4", "ss mm HH ? * 5");
        dateFormatMap.put("5", "ss mm HH ? * 6");
        dateFormatMap.put("6", "ss mm HH ? * 7");
        dateFormatMap.put("EVERYDAY", "ss mm HH * * ?");
        dateFormatMap.put("YEAR", "ss mm HH dd MM ? yyyy");
    }
}

