/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.agiledataquery.utils;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class ServiceUtils {
    private static final Logger log = LoggerFactory.getLogger(ServiceUtils.class);

    public static List<Field> getFields(Class<?> clazz) {
        ArrayList<Field> fieldList = new ArrayList<Field>();
        while (clazz != null && clazz != Object.class) {
            Field[] fields = clazz.getDeclaredFields();
            fieldList.addAll(Arrays.asList(fields));
            clazz = clazz.getSuperclass();
        }
        return fieldList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String loadResourceAsString(String resourcePath) {
        try (InputStream inputStream = ServiceUtils.class.getResourceAsStream(resourcePath);){
            if (inputStream == null) return null;
            String string = IOUtils.toString((InputStream)inputStream, (String)"UTF-8");
            return string;
        }
        catch (IOException e) {
            log.error("Failed to load resource: " + resourcePath, (Throwable)e);
        }
        return null;
    }

    public static boolean isStaticField(Field field) {
        return Modifier.isStatic(field.getModifiers());
    }

    public static boolean isFinalField(Field field) {
        return Modifier.isFinal(field.getModifiers());
    }

    public static void makeAccessible(Field field) {
        if (!field.isAccessible()) {
            field.setAccessible(true);
        }
    }

    public static Object getFieldValue(Field field, Object target) {
        try {
            ServiceUtils.makeAccessible((Field)field);
            return field.get(target);
        }
        catch (IllegalAccessException e) {
            log.error("Failed to get field value: " + field.getName(), (Throwable)e);
            return null;
        }
    }

    public static void setFieldValue(Field field, Object target, Object value) {
        try {
            ServiceUtils.makeAccessible((Field)field);
            field.set(target, value);
        }
        catch (IllegalAccessException e) {
            log.error("Failed to set field value: " + field.getName(), (Throwable)e);
        }
    }
}

