/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.agiledataquery.utils;

import com.digiwin.athena.agiledataquery.context.DWServiceContext;
import com.digiwin.athena.agiledataquery.service.inner.KgInnerService;
import com.digiwin.athena.agiledataquery.synonym.domain.AthenaUserLocal;
import com.digiwin.athena.agiledataquery.utils.DataMapFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadLocalCleanupUtil {
    private static final Logger logger = LoggerFactory.getLogger(ThreadLocalCleanupUtil.class);

    public static void cleanupAllThreadLocals() {
        try {
            DWServiceContext.clear();
            DataMapFilter.clear();
            KgInnerService.cleanThreads();
            AthenaUserLocal.removeUser();
            logger.debug("Successfully cleaned all ThreadLocal variables");
        }
        catch (Exception e) {
            logger.warn("Failed to clean some ThreadLocal variables", (Throwable)e);
        }
    }

    public static void cleanupThreadLocal(String threadLocalName, Runnable cleanupAction) {
        try {
            cleanupAction.run();
            logger.debug("Successfully cleaned ThreadLocal: {}", (Object)threadLocalName);
        }
        catch (Exception e) {
            logger.warn("Failed to clean ThreadLocal: {}", (Object)threadLocalName, (Object)e);
        }
    }
}

