/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.agiledataquery.utils;

import com.alibaba.fastjson.JSON;
import com.digiwin.athena.agiledataquery.context.DWServiceContext;
import com.digiwin.athena.agiledataquery.utils.Utils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.HttpClientUtils;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicHeader;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class Utils {
    private static final Logger log = LoggerFactory.getLogger(Utils.class);
    private static Logger logger = LoggerFactory.getLogger(Utils.class);
    private static HttpClient httpClient;
    private static RequestConfig requestConfig;

    public static HttpClient getHttpClient() {
        if (httpClient == null) {
            try {
                SSLContext sslContext = SSLContext.getInstance("TLS");
                1 tm = new /* Unavailable Anonymous Inner Class!! */;
                sslContext.init(null, new TrustManager[]{tm}, null);
                httpClient = HttpClients.custom().setMaxConnPerRoute(1000).setMaxConnTotal(1000).setSSLContext(sslContext).build();
            }
            catch (Exception e) {
                log.error("Failed to create HTTP client", (Throwable)e);
                httpClient = HttpClients.createDefault();
            }
        }
        return httpClient;
    }

    public static String postJson(String url, Header[] headers, String jsonBody) {
        HttpPost httpPost = new HttpPost(url);
        httpPost.setConfig(requestConfig);
        if (headers != null) {
            httpPost.setHeaders(headers);
        }
        if (jsonBody != null) {
            StringEntity entity = new StringEntity(jsonBody, ContentType.APPLICATION_JSON);
            httpPost.setEntity((HttpEntity)entity);
        }
        try {
            HttpResponse response = Utils.getHttpClient().execute((HttpUriRequest)httpPost);
            HttpEntity entity = response.getEntity();
            return EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
        }
        catch (IOException e) {
            log.error("POST request failed: " + url, (Throwable)e);
            return null;
        }
    }

    public static String get(String url, Header[] headers, Map<String, String> params) {
        StringBuilder urlBuilder = new StringBuilder(url);
        if (params != null && !params.isEmpty()) {
            urlBuilder.append("?");
            params.forEach((key, value) -> urlBuilder.append((String)key).append("=").append((String)value).append("&"));
            urlBuilder.setLength(urlBuilder.length() - 1);
        }
        HttpGet httpGet = new HttpGet(urlBuilder.toString());
        httpGet.setConfig(requestConfig);
        if (headers != null) {
            httpGet.setHeaders(headers);
        }
        try {
            HttpResponse response = Utils.getHttpClient().execute((HttpUriRequest)httpGet);
            HttpEntity entity = response.getEntity();
            return EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
        }
        catch (IOException e) {
            log.error("GET request failed: " + url, (Throwable)e);
            return null;
        }
    }

    public static Header[] requiredHeaders() {
        return new Header[]{new BasicHeader("Content-Type", "application/json"), new BasicHeader("Accept", "application/json")};
    }

    public static String toJsonString(Object obj) {
        try {
            return JSON.toJSONString((Object)obj);
        }
        catch (Exception e) {
            log.error("Failed to convert object to JSON", (Throwable)e);
            return null;
        }
    }

    public static <T> T fromJsonString(String jsonString, Class<T> clazz) {
        try {
            return (T)JSON.parseObject((String)jsonString, clazz);
        }
        catch (Exception e) {
            log.error("Failed to parse JSON string", (Throwable)e);
            return null;
        }
    }

    public static Map<String, String> requiredMapHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        try {
            HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
            String routerKey = request.getHeader("routerKey");
            String token = request.getHeader("token");
            if (StringUtils.isEmpty((CharSequence)token) && StringUtils.isEmpty((CharSequence)(token = request.getHeader("Digi-Middleware-Auth-User")))) {
                token = request.getHeader("digi-middleware-auth-user");
            }
            String locale = request.getHeader("locale");
            if (null == token) {
                token = (String)DWServiceContext.getContext().getRequestHeader().get("token");
                routerKey = (String)DWServiceContext.getContext().getRequestHeader().get("routerKey");
                locale = (String)DWServiceContext.getContext().getRequestHeader().get("locale");
            }
            if (null == token) {
                token = DWServiceContext.getContext().getToken();
            }
            if (null != routerKey) {
                headers.put("routerKey", routerKey);
            }
            if (null != token) {
                headers.put("token", token);
            }
            if (null != locale) {
                headers.put("locale", locale);
            }
        }
        catch (Exception e) {
            log.error("requiredHeaders error,{}", (Object)e.toString());
        }
        return headers;
    }

    public static <T> T postJson(String url, Map<String, String> headers, Map<String, Object> params, Class<T> c) throws IOException {
        Object result = null;
        result = JSON.parseObject((String)Utils.postJson((String)url, headers, params), c);
        return (T)result;
    }

    public static String postJson(String url, Map<String, String> headers, Map<String, Object> params) throws IOException {
        String result = null;
        HttpPost httppost = new HttpPost(url);
        httppost.setConfig(requestConfig);
        httppost.setHeaders(Utils.toHeader(headers));
        String jsonbody = JSON.toJSONString(params);
        StringEntity myEntity = new StringEntity(jsonbody, ContentType.APPLICATION_JSON);
        httppost.setEntity((HttpEntity)myEntity);
        HttpResponse response = null;
        if (logger.isInfoEnabled()) {
            logger.info("post to:" + url + ",and request body=" + jsonbody);
        }
        try {
            response = Utils.getHttpClient().execute((HttpUriRequest)httppost);
            HttpEntity entity = response.getEntity();
            result = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        finally {
            HttpClientUtils.closeQuietly((HttpResponse)response);
        }
        if (logger.isInfoEnabled()) {
            logger.info("response from :" + url + ",response body=" + result);
        }
        return result;
    }

    private static Header[] toHeader(Map<String, String> headers) {
        if (null != headers) {
            ArrayList hs = new ArrayList();
            headers.forEach((k, v) -> hs.add(new BasicHeader(k, v)));
            return hs.toArray(new Header[0]);
        }
        return null;
    }

    public static void requiredHeaders(HttpHeaders headers) {
        try {
            HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
            String routerKey = request.getHeader("routerKey");
            String token = request.getHeader("token");
            if (StringUtils.isEmpty((CharSequence)token) && StringUtils.isEmpty((CharSequence)(token = request.getHeader("Digi-Middleware-Auth-User")))) {
                token = request.getHeader("digi-middleware-auth-user");
            }
            String locale = request.getHeader("locale");
            String securityToken = request.getHeader("security-token");
            if (null == token) {
                token = (String)DWServiceContext.getContext().getRequestHeader().get("token");
                routerKey = (String)DWServiceContext.getContext().getRequestHeader().get("routerKey");
                locale = (String)DWServiceContext.getContext().getRequestHeader().get("locale");
            }
            if (null == token) {
                token = DWServiceContext.getContext().getToken();
            }
            if (null == securityToken) {
                securityToken = (String)DWServiceContext.getContext().getRequestHeader().get("security-token");
            }
            if (null != routerKey) {
                headers.set("routerKey", routerKey);
            }
            if (null != token) {
                headers.set("token", token);
                headers.set("digi-middleware-auth-user", token);
            }
            if (null != locale) {
                headers.set("locale", locale);
            }
            if (null != securityToken) {
                headers.set("security-token", securityToken);
            }
        }
        catch (Exception e) {
            log.error("requiredHeaders error,{}", (Object)e.toString());
        }
    }

    static {
        requestConfig = RequestConfig.custom().setConnectTimeout(60000).setConnectionRequestTimeout(60000).setSocketTimeout(60000).setMaxRedirects(50).build();
    }
}

