/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athenai.dashscope.component;

import com.alibaba.cloud.ai.dashscope.chat.DashScopeChatOptions;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import javax.imageio.ImageIO;
import org.bytedeco.javacv.FFmpegFrameGrabber;
import org.bytedeco.javacv.Frame;
import org.bytedeco.javacv.Java2DFrameConverter;
import org.springframework.ai.chat.client.ChatClient;
import org.springframework.ai.chat.messages.Message;
import org.springframework.ai.chat.messages.UserMessage;
import org.springframework.ai.chat.model.ChatModel;
import org.springframework.ai.chat.model.ChatResponse;
import org.springframework.ai.chat.prompt.ChatOptions;
import org.springframework.ai.chat.prompt.Prompt;
import org.springframework.ai.content.Media;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Service;
import org.springframework.util.MimeTypeUtils;
import org.springframework.web.multipart.MultipartFile;

@Service
public class AiVideoService {
    private static final String DEFAULT_MODEL = "qwen-vl-max-latest";
    private static final String TEMP_IMAGE_DIR = "temp-frames";
    private final ChatClient daschScopeChatClient;

    public AiVideoService(@Qualifier(value="dashscopeChatModel") ChatModel chatModel) {
        this.daschScopeChatClient = ChatClient.builder((ChatModel)chatModel).build();
    }

    public String analyzeVideo(String prompt, MultipartFile videoFile) throws Exception {
        if (!this.isSupportedFormat(videoFile)) {
            throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684\u89c6\u9891\u683c\u5f0f");
        }
        Path tempVideoPath = Paths.get(System.getProperty("java.io.tmpdir"), videoFile.getOriginalFilename());
        videoFile.transferTo(tempVideoPath.toFile());
        List<File> frames = this.extractFrames(tempVideoPath.toFile(), 10);
        ArrayList<Media> mediaList = new ArrayList<Media>();
        for (File frame : frames) {
            mediaList.add(new Media(MimeTypeUtils.IMAGE_PNG, (Resource)new FileSystemResource(frame)));
        }
        UserMessage message = UserMessage.builder().text(prompt).media(mediaList).metadata(new HashMap()).build();
        List response = (List)this.daschScopeChatClient.prompt(new Prompt((Message)message, (ChatOptions)DashScopeChatOptions.builder().withModel(DEFAULT_MODEL).withMultiModel(Boolean.valueOf(true)).build())).stream().chatResponse().collectList().block();
        StringBuilder result = new StringBuilder();
        if (response != null) {
            for (ChatResponse chatResponse : response) {
                String outputContent = chatResponse.getResult().getOutput().getText();
                result.append(outputContent).append("\n");
            }
        }
        this.cleanUpFiles(frames);
        Files.deleteIfExists(tempVideoPath);
        return result.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<File> extractFrames(File videoFile, int frameCount) throws IOException {
        ArrayList<File> frames = new ArrayList<File>();
        FFmpegFrameGrabber grabber = new FFmpegFrameGrabber(videoFile);
        grabber.start();
        try {
            Path tempDir = Paths.get(System.getProperty("java.io.tmpdir"), TEMP_IMAGE_DIR);
            if (!Files.exists(tempDir, new LinkOption[0])) {
                Files.createDirectories(tempDir, new FileAttribute[0]);
            }
            int totalFrames = grabber.getLengthInFrames();
            int step = totalFrames / frameCount;
            Java2DFrameConverter converter = new Java2DFrameConverter();
            for (int i = 0; i < frameCount; ++i) {
                int frameNumber = i * step;
                grabber.setFrameNumber(frameNumber);
                Frame frame = grabber.grabImage();
                BufferedImage image = converter.convert(frame);
                File outputFile = tempDir.resolve(String.valueOf(UUID.randomUUID()) + ".png").toFile();
                ImageIO.write((RenderedImage)image, "png", outputFile);
                frames.add(outputFile);
            }
        }
        finally {
            grabber.stop();
        }
        return frames;
    }

    private void cleanUpFiles(List<File> files) {
        for (File file : files) {
            file.delete();
        }
    }

    private boolean isSupportedFormat(MultipartFile file) {
        String contentType = file.getContentType();
        return contentType != null && (contentType.startsWith("video/mp4") || contentType.startsWith("video/quicktime"));
    }
}

