/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athenai.dashscope.component;

import com.alibaba.cloud.ai.dashscope.chat.DashScopeChatOptions;
import com.alibaba.cloud.ai.dashscope.chat.MessageFormat;
import com.alibaba.cloud.ai.dashscope.image.DashScopeImageOptions;
import com.digiwin.athenai.utils.FilesUtils;
import com.google.common.collect.Lists;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.springframework.ai.chat.client.ChatClient;
import org.springframework.ai.chat.messages.Message;
import org.springframework.ai.chat.messages.UserMessage;
import org.springframework.ai.chat.model.ChatModel;
import org.springframework.ai.chat.model.ChatResponse;
import org.springframework.ai.chat.prompt.ChatOptions;
import org.springframework.ai.chat.prompt.Prompt;
import org.springframework.ai.content.Media;
import org.springframework.ai.image.ImageGeneration;
import org.springframework.ai.image.ImageModel;
import org.springframework.ai.image.ImageOptions;
import org.springframework.ai.image.ImagePrompt;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpHeaders;
import org.springframework.stereotype.Service;
import org.springframework.util.MimeTypeUtils;
import org.springframework.web.multipart.MultipartFile;

@Service
public class AimageService {
    private static final String DEFAULT_TEXT2IMAGE_MODEL = "qwen-vl-max-latest";
    private static final String DEFAULT_IMAGE_MODEL = "wanx2.1-t2i-turbo";
    private final ImageModel imageModel;
    private final ChatClient daschScopeChatClient;

    public AimageService(@Qualifier(value="dashscopeChatModel") ChatModel chatModel, @Qualifier(value="dashScopeImageModel") ImageModel imageModel) {
        this.imageModel = imageModel;
        this.daschScopeChatClient = ChatClient.builder((ChatModel)chatModel).build();
    }

    public String image2Text(String prompt, MultipartFile file) throws IOException {
        String filePath = FilesUtils.saveTempFile((MultipartFile)file, (String)"/tmp/image/");
        ArrayList mediaList = Lists.newArrayList((Object[])new Media[]{new Media(MimeTypeUtils.IMAGE_PNG, (Resource)new FileSystemResource(filePath))});
        UserMessage message = UserMessage.builder().text(prompt).media((List)mediaList).metadata(new HashMap()).build();
        message.getMetadata().put("messageFormat", MessageFormat.IMAGE);
        List response = (List)this.daschScopeChatClient.prompt(new Prompt((Message)message, (ChatOptions)DashScopeChatOptions.builder().withModel(DEFAULT_TEXT2IMAGE_MODEL).withMultiModel(Boolean.valueOf(true)).build())).stream().chatResponse().collectList().block();
        StringBuilder result = new StringBuilder();
        if (response != null) {
            for (ChatResponse chatResponse : response) {
                String outputContent = chatResponse.getResult().getOutput().getText();
                result.append(outputContent);
            }
        }
        return result.toString();
    }

    public void text2Image(String prompt, String resolution, String style, HttpServletResponse response) {
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Security-Policy", "img-src 'self' data:;");
        ImageGeneration result = this.imageModel.call(new ImagePrompt(prompt, (ImageOptions)DashScopeImageOptions.builder().withHeight(Integer.valueOf(resolution.split("\\*")[0])).withWidth(Integer.valueOf(resolution.split("\\*")[1])).withStyle(style).withModel(DEFAULT_IMAGE_MODEL).build())).getResult();
        String imageUrl = result.getOutput().getUrl();
        try {
            URL url = URI.create(imageUrl).toURL();
            InputStream in = url.openStream();
            response.setHeader("Content-Security-Policy", "img-src 'self' data:;");
            response.setHeader("Content-Type", "image/png");
            response.getOutputStream().write(in.readAllBytes());
            response.getOutputStream().flush();
        }
        catch (IOException e) {
            response.setStatus(500);
        }
    }
}

