/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athenai.dashscope.component;

import com.alibaba.cloud.ai.dashscope.api.DashScopeAudioSpeechApi;
import com.alibaba.cloud.ai.dashscope.api.DashScopeAudioTranscriptionApi;
import com.alibaba.cloud.ai.dashscope.audio.DashScopeAudioSpeechOptions;
import com.alibaba.cloud.ai.dashscope.audio.DashScopeAudioTranscriptionOptions;
import com.alibaba.cloud.ai.dashscope.audio.synthesis.SpeechSynthesisModel;
import com.alibaba.cloud.ai.dashscope.audio.synthesis.SpeechSynthesisOptions;
import com.alibaba.cloud.ai.dashscope.audio.synthesis.SpeechSynthesisPrompt;
import com.alibaba.cloud.ai.dashscope.audio.synthesis.SpeechSynthesisResponse;
import com.alibaba.cloud.ai.dashscope.audio.transcription.AudioTranscriptionModel;
import com.alibaba.fastjson2.JSONPath;
import com.digiwin.athenai.prop.AiComponentProperties;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import org.springframework.ai.audio.transcription.AudioTranscriptionOptions;
import org.springframework.ai.audio.transcription.AudioTranscriptionPrompt;
import org.springframework.ai.audio.transcription.AudioTranscriptionResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestClient;
import reactor.core.publisher.Flux;

@Service
public class AiAudioService {
    @Autowired
    private SpeechSynthesisModel speechSynthesisModel;
    @Autowired
    private AudioTranscriptionModel transcriptionModel;
    @Autowired
    AiComponentProperties aiComponentProperties;
    @Autowired
    RestClient aiRestClient;

    public String text2VoiceUrl_ali(String text) {
        HashMap<String, Object> body = new HashMap<String, Object>();
        HashMap<String, String> input = new HashMap<String, String>();
        body.put("model", "qwen3-tts-flash");
        body.put("input", input);
        input.put("text", text);
        input.put("voice", "Cherry");
        input.put("language_type", "Chinese");
        Map resp = (Map)((RestClient.RequestBodySpec)this.aiRestClient.post().uri("/api/v1/services/aigc/multimodal-generation/generation", new Object[0])).body(body).retrieve().body((ParameterizedTypeReference)new ParameterizedTypeReference<Map<String, Object>>(this){});
        String url = (String)JSONPath.eval((Object)resp, (String)"$.output.audio.url");
        System.out.println(resp);
        System.out.println(url);
        return url;
    }

    public void text2Audio(String text) throws IOException {
        SpeechSynthesisResponse response = this.speechSynthesisModel.call(new SpeechSynthesisPrompt(text, (SpeechSynthesisOptions)DashScopeAudioSpeechOptions.builder().model(DashScopeAudioSpeechApi.AudioSpeechModel.SAM_BERT_ZHICHU_V1.getValue()).build()));
        File file = new File(this.aiComponentProperties.getTmpDir() + "/output.mp3");
        try (FileOutputStream fos = new FileOutputStream(file);){
            ByteBuffer byteBuffer = response.getResult().getOutput().getAudio();
            fos.write(byteBuffer.array());
        }
        catch (IOException e) {
            throw new IOException(e.getMessage());
        }
    }

    public void text2AudioStream(String text) throws IOException {
        Flux response = this.speechSynthesisModel.stream(new SpeechSynthesisPrompt(text, (SpeechSynthesisOptions)DashScopeAudioSpeechOptions.builder().model(DashScopeAudioSpeechApi.AudioSpeechModel.SAM_BERT_ZHITING_V1.getValue()).build()));
        CountDownLatch latch = new CountDownLatch(1);
        File file = new File(this.aiComponentProperties.getTmpDir() + "/output-stream.mp3");
        try (FileOutputStream fos = new FileOutputStream(file);){
            response.doFinally(signal -> latch.countDown()).subscribe(synthesisResponse -> {
                ByteBuffer byteBuffer = synthesisResponse.getResult().getOutput().getAudio();
                byte[] bytes = new byte[byteBuffer.remaining()];
                byteBuffer.get(bytes);
                try {
                    fos.write(bytes);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
            latch.await();
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public String audio2Text() {
        String currentDir = this.aiComponentProperties.getTmpDir();
        Path filePath = Paths.get(currentDir, "/output.mp3");
        AudioTranscriptionResponse response = this.transcriptionModel.call(new AudioTranscriptionPrompt((Resource)new FileSystemResource(filePath), (AudioTranscriptionOptions)DashScopeAudioTranscriptionOptions.builder().withModel(DashScopeAudioTranscriptionApi.AudioTranscriptionModel.PARAFORMER_REALTIME_V2.getValue()).build()));
        return response.getResult().getOutput();
    }

    public String audio2Text2() {
        String currentDir = this.aiComponentProperties.getTmpDir();
        Path filePath = Paths.get(currentDir, "/output.mp3");
        CountDownLatch latch = new CountDownLatch(1);
        StringBuilder stringBuilder = new StringBuilder();
        Flux response = this.transcriptionModel.stream(new AudioTranscriptionPrompt((Resource)new FileSystemResource(filePath), (AudioTranscriptionOptions)DashScopeAudioTranscriptionOptions.builder().withModel(DashScopeAudioTranscriptionApi.AudioTranscriptionModel.PARAFORMER_REALTIME_V2.getValue()).withSampleRate(Integer.valueOf(16000)).withFormat(DashScopeAudioTranscriptionOptions.AudioFormat.PCM).withDisfluencyRemovalEnabled(Boolean.valueOf(false)).build()));
        response.doFinally(signal -> latch.countDown()).subscribe(resp -> stringBuilder.append(resp.getResult().getOutput()));
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        return stringBuilder.toString();
    }
}

