/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athenai.dashscope.component;

import com.alibaba.cloud.ai.dashscope.chat.DashScopeChatOptions;
import com.digiwin.athenai.constant.Prompts;
import com.digiwin.athenai.exception.SAAAIException;
import com.digiwin.athenai.utils.DocumentReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.chat.client.ChatClient;
import org.springframework.ai.chat.client.advisor.MessageChatMemoryAdvisor;
import org.springframework.ai.chat.client.advisor.SimpleLoggerAdvisor;
import org.springframework.ai.chat.client.advisor.api.Advisor;
import org.springframework.ai.chat.model.ChatModel;
import org.springframework.ai.chat.prompt.ChatOptions;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;
import reactor.core.publisher.Flux;

@Service
public class AiSummarizerService {
    private static final Logger logger = LoggerFactory.getLogger(AiSummarizerService.class);
    private final ChatClient chatClient;

    public AiSummarizerService(SimpleLoggerAdvisor simpleLoggerAdvisor, MessageChatMemoryAdvisor messageChatMemoryAdvisor, @Qualifier(value="dashscopeChatModel") ChatModel chatModel) {
        this.chatClient = ChatClient.builder((ChatModel)chatModel).defaultOptions((ChatOptions)DashScopeChatOptions.builder().withModel("deepseek-r1").build()).defaultSystem(Prompts.summarizerPromptTemplate.getTemplate()).defaultAdvisors(new Advisor[]{messageChatMemoryAdvisor, simpleLoggerAdvisor}).build();
    }

    public Flux<String> summary(MultipartFile file, String url) {
        String text = DocumentReader.readMultiFile((String)url, (MultipartFile)file);
        if (!StringUtils.hasText((String)text)) {
            return Flux.error((Throwable)new SAAAIException("Invalid file content"));
        }
        return this.chatClient.prompt().user("Summarize the document").user(text).stream().content();
    }

    public String summarySync(MultipartFile file, String url) {
        String text = DocumentReader.readMultiFile((String)url, (MultipartFile)file);
        if (!StringUtils.hasText((String)text)) {
            throw new SAAAIException("Invalid file content");
        }
        return this.chatClient.prompt().user("Summarize the document").user(text).call().content();
    }
}

