/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athenai.nl2sql.code;

import com.digiwin.athenai.nl2sql.code.CodeExecutorProperties;
import com.digiwin.athenai.nl2sql.code.CodePoolExecutorEnum;
import com.digiwin.athenai.nl2sql.code.CodePoolExecutorService;
import com.digiwin.athenai.nl2sql.code.impl.AiSimulationCodeExecutorService;
import com.digiwin.athenai.nl2sql.code.impl.DockerCodePoolExecutorService;
import com.digiwin.athenai.nl2sql.code.impl.LocalCodePoolExecutorService;
import org.springframework.ai.chat.client.ChatClient;

public final class CodePoolExecutorServiceFactory {
    private CodePoolExecutorServiceFactory() {
    }

    public static CodePoolExecutorService newInstance(CodeExecutorProperties properties, ChatClient.Builder chatClientBuilder) {
        return switch (properties.getCodePoolExecutor()) {
            case CodePoolExecutorEnum.DOCKER -> new DockerCodePoolExecutorService(properties);
            case CodePoolExecutorEnum.LOCAL -> new LocalCodePoolExecutorService(properties);
            case CodePoolExecutorEnum.AI_SIMULATION -> new AiSimulationCodeExecutorService(chatClientBuilder);
            default -> throw new UnsupportedOperationException("This option does not have a corresponding implementation class yet.");
        };
    }
}

