/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athenai.nl2sql.connector.mysql;

import com.digiwin.athenai.constant.ErrorCodeEnum;
import com.digiwin.athenai.nl2sql.connector.AbstractDBConnectionPool;
import com.digiwin.athenai.nl2sql.constant.DatabaseDialectEnum;
import org.springframework.stereotype.Service;

@Service(value="mysqlJdbcConnectionPool")
public class MysqlJdbcConnectionPool
extends AbstractDBConnectionPool {
    private static final String DRIVER = "com.mysql.cj.jdbc.Driver";

    @Override
    public DatabaseDialectEnum getDialect() {
        return DatabaseDialectEnum.MYSQL;
    }

    @Override
    public String getDriver() {
        return DRIVER;
    }

    @Override
    public ErrorCodeEnum errorMapping(String sqlState) {
        ErrorCodeEnum ret = ErrorCodeEnum.fromCode((String)sqlState);
        if (ret != null) {
            return ret;
        }
        return switch (sqlState) {
            case "08S01" -> ErrorCodeEnum.DATASOURCE_CONNECTION_FAILURE_08S01;
            case "28000" -> ErrorCodeEnum.PASSWORD_ERROR_28000;
            case "42000" -> ErrorCodeEnum.DATABASE_NOT_EXIST_42000;
            default -> ErrorCodeEnum.OTHERS;
        };
    }
}

