/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athenai.nl2sql.connector.mysql;

import com.digiwin.athenai.nl2sql.connector.AbstractJdbcDdl;
import com.digiwin.athenai.nl2sql.connector.ColumnTypeParser;
import com.digiwin.athenai.nl2sql.connector.SqlExecutor;
import com.digiwin.athenai.nl2sql.connector.bo.ColumnInfoBO;
import com.digiwin.athenai.nl2sql.connector.bo.DatabaseInfoBO;
import com.digiwin.athenai.nl2sql.connector.bo.ForeignKeyInfoBO;
import com.digiwin.athenai.nl2sql.connector.bo.ResultSetBO;
import com.digiwin.athenai.nl2sql.connector.bo.SchemaInfoBO;
import com.digiwin.athenai.nl2sql.connector.bo.TableInfoBO;
import com.digiwin.athenai.nl2sql.constant.BizDataSourceTypeEnum;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class MysqlJdbcDdl
extends AbstractJdbcDdl {
    @Override
    public List<DatabaseInfoBO> showDatabases(Connection connection) {
        String sql = "show databases;";
        ArrayList databaseInfoList = Lists.newArrayList();
        try {
            String[][] resultArr = SqlExecutor.executeSqlAndReturnArr(connection, sql);
            if (resultArr.length <= 1) {
                return Lists.newArrayList();
            }
            for (int i = 1; i < resultArr.length; ++i) {
                if (resultArr[i].length == 0) continue;
                String database = resultArr[i][0];
                databaseInfoList.add(DatabaseInfoBO.builder().name(database).build());
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return databaseInfoList;
    }

    @Override
    public List<SchemaInfoBO> showSchemas(Connection connection) {
        return Collections.emptyList();
    }

    @Override
    public List<TableInfoBO> showTables(Connection connection, String schema, String tablePattern) {
        Object sql = "SELECT TABLE_NAME, TABLE_COMMENT \nFROM INFORMATION_SCHEMA.TABLES \nWHERE TABLE_SCHEMA = '%s' \n";
        if (StringUtils.isNotBlank((CharSequence)tablePattern)) {
            sql = (String)sql + "AND TABLE_NAME LIKE CONCAT('%%','%s','%%') \n";
        }
        sql = (String)sql + "limit 2000;";
        ArrayList tableInfoList = Lists.newArrayList();
        try {
            String[][] resultArr = SqlExecutor.executeSqlAndReturnArr(connection, String.format((String)sql, connection.getCatalog(), tablePattern));
            if (resultArr.length <= 1) {
                return Lists.newArrayList();
            }
            for (int i = 1; i < resultArr.length; ++i) {
                if (resultArr[i].length == 0) continue;
                String tableName = resultArr[i][0];
                String tableDesc = resultArr[i][1];
                tableInfoList.add(TableInfoBO.builder().name(tableName).description(tableDesc).build());
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return tableInfoList;
    }

    @Override
    public List<TableInfoBO> fetchTables(Connection connection, String schema, List<String> tables) {
        String sql = "SELECT TABLE_NAME, TABLE_COMMENT \nFROM INFORMATION_SCHEMA.TABLES \nWHERE TABLE_SCHEMA = '%s' \nAND TABLE_NAME in(%s) \nlimit 200;";
        ArrayList tableInfoList = Lists.newArrayList();
        String tableListStr = String.join((CharSequence)", ", tables.stream().map(x -> "'" + x + "'").collect(Collectors.toList()));
        try {
            String[][] resultArr = SqlExecutor.executeSqlAndReturnArr(connection, String.format(sql, connection.getCatalog(), tableListStr));
            if (resultArr.length <= 1) {
                return Lists.newArrayList();
            }
            for (int i = 1; i < resultArr.length; ++i) {
                if (resultArr[i].length == 0) continue;
                String tableName = resultArr[i][0];
                String tableDesc = resultArr[i][1];
                tableInfoList.add(TableInfoBO.builder().name(tableName).description(tableDesc).build());
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return tableInfoList;
    }

    @Override
    public List<ColumnInfoBO> showColumns(Connection connection, String schema, String table) {
        String sql = "SELECT column_name, column_comment, data_type, IF(column_key='PRI','true','false') AS '\u4e3b\u952e\u552f\u4e00', \nIF(IS_NULLABLE='NO','true','false') AS '\u975e\u7a7a' \nFROM information_schema.COLUMNS WHERE table_schema='%s' and table_name='%s';";
        ArrayList columnInfoList = Lists.newArrayList();
        try {
            String[][] resultArr = SqlExecutor.executeSqlAndReturnArr(connection, "INFORMATION_SCHEMA", String.format(sql, connection.getCatalog(), table));
            if (resultArr.length <= 1) {
                return Lists.newArrayList();
            }
            for (int i = 1; i < resultArr.length; ++i) {
                if (resultArr[i].length == 0) continue;
                columnInfoList.add(ColumnInfoBO.builder().name(resultArr[i][0]).description(resultArr[i][1]).type(ColumnTypeParser.wrapType(resultArr[i][2])).primary(BooleanUtils.toBoolean((String)resultArr[i][3])).notnull(BooleanUtils.toBoolean((String)resultArr[i][4])).build());
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return columnInfoList;
    }

    @Override
    public List<ForeignKeyInfoBO> showForeignKeys(Connection connection, String schema, List<String> tables) {
        String sql = "SELECT \n    TABLE_NAME AS '\u8868\u540d',\n    COLUMN_NAME AS '\u5217\u540d',\n    CONSTRAINT_NAME AS '\u7ea6\u675f\u540d',\n    REFERENCED_TABLE_NAME AS '\u5f15\u7528\u8868\u540d',\n    REFERENCED_COLUMN_NAME AS '\u5f15\u7528\u5217\u540d'\nFROM \n    INFORMATION_SCHEMA.KEY_COLUMN_USAGE\nWHERE \n    CONSTRAINT_SCHEMA = '%s'     AND CONSTRAINT_NAME != 'PRIMARY'    AND TABLE_NAME in(%s)\n    AND REFERENCED_TABLE_NAME in (%s);";
        ArrayList foreignKeyInfoList = Lists.newArrayList();
        String tableListStr = String.join((CharSequence)", ", tables.stream().map(x -> "'" + x + "'").collect(Collectors.toList()));
        try {
            sql = String.format(sql, connection.getCatalog(), tableListStr, tableListStr);
            String[][] resultArr = SqlExecutor.executeSqlAndReturnArr(connection, "INFORMATION_SCHEMA", sql);
            if (resultArr.length <= 1) {
                return Lists.newArrayList();
            }
            for (int i = 1; i < resultArr.length; ++i) {
                if (resultArr[i].length == 0) continue;
                foreignKeyInfoList.add(ForeignKeyInfoBO.builder().table(resultArr[i][0]).column(resultArr[i][1]).referencedTable(resultArr[i][3]).referencedColumn(resultArr[i][4]).build());
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return foreignKeyInfoList;
    }

    @Override
    public List<String> sampleColumn(Connection connection, String schema, String table, String column) {
        String sql = "SELECT \n    `%s`\nFROM \n    `%s`\nLIMIT 99;";
        List<Object> sampleInfo = Lists.newArrayList();
        try {
            sql = String.format(sql, column, table);
            String[][] resultArr = SqlExecutor.executeSqlAndReturnArr(connection, null, sql);
            if (resultArr.length <= 1) {
                return Lists.newArrayList();
            }
            for (int i = 1; i < resultArr.length; ++i) {
                if (resultArr[i].length == 0 || column.equalsIgnoreCase(resultArr[i][0])) continue;
                sampleInfo.add(resultArr[i][0]);
            }
        }
        catch (SQLException resultArr) {
            // empty catch block
        }
        Set siSet = sampleInfo.stream().collect(Collectors.toSet());
        sampleInfo = siSet.stream().collect(Collectors.toList());
        return sampleInfo;
    }

    @Override
    public ResultSetBO scanTable(Connection connection, String schema, String table) {
        String sql = "SELECT *\nFROM \n    `%s`\nLIMIT 20;";
        ResultSetBO resultSet = ResultSetBO.builder().build();
        try {
            resultSet = SqlExecutor.executeSqlAndReturnObject(connection, schema, String.format(sql, table));
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return resultSet;
    }

    @Override
    public BizDataSourceTypeEnum getType() {
        return BizDataSourceTypeEnum.MYSQL;
    }
}

