/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athenai.nl2sql.connector.postgre;

import com.digiwin.athenai.nl2sql.connector.AbstractJdbcDdl;
import com.digiwin.athenai.nl2sql.connector.ColumnTypeParser;
import com.digiwin.athenai.nl2sql.connector.SqlExecutor;
import com.digiwin.athenai.nl2sql.connector.bo.ColumnInfoBO;
import com.digiwin.athenai.nl2sql.connector.bo.DatabaseInfoBO;
import com.digiwin.athenai.nl2sql.connector.bo.ForeignKeyInfoBO;
import com.digiwin.athenai.nl2sql.connector.bo.ResultSetBO;
import com.digiwin.athenai.nl2sql.connector.bo.SchemaInfoBO;
import com.digiwin.athenai.nl2sql.connector.bo.TableInfoBO;
import com.digiwin.athenai.nl2sql.constant.BizDataSourceTypeEnum;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class PostgreJdbcDdl
extends AbstractJdbcDdl {
    private static final Logger log = LoggerFactory.getLogger(PostgreJdbcDdl.class);

    @Override
    public List<DatabaseInfoBO> showDatabases(Connection connection) {
        String sql = "select datname from pg_database;";
        ArrayList databaseInfoList = Lists.newArrayList();
        try {
            String[][] resultArr = SqlExecutor.executeSqlAndReturnArr(connection, sql);
            if (resultArr.length <= 1) {
                return Lists.newArrayList();
            }
            for (int i = 1; i < resultArr.length; ++i) {
                if (resultArr[i].length == 0) continue;
                String database = resultArr[i][0];
                databaseInfoList.add(DatabaseInfoBO.builder().name(database).build());
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return databaseInfoList;
    }

    @Override
    public List<SchemaInfoBO> showSchemas(Connection connection) {
        String sql = "SELECT schema_name \nFROM information_schema.schemata;";
        ArrayList schemaInfoList = Lists.newArrayList();
        try {
            String[][] resultArr = SqlExecutor.executeSqlAndReturnArr(connection, sql);
            if (resultArr.length <= 1) {
                return Lists.newArrayList();
            }
            for (int i = 1; i < resultArr.length; ++i) {
                if (resultArr[i].length == 0) continue;
                String database = resultArr[i][0];
                schemaInfoList.add(SchemaInfoBO.builder().name(database).build());
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return schemaInfoList;
    }

    @Override
    public List<TableInfoBO> showTables(Connection connection, String schema, String tablePattern) {
        Object sql = "SELECT tb.table_name, d.description \nFROM information_schema.tables tb \nJOIN pg_class c ON c.relname = tb.table_name \nJOIN pg_namespace n ON c.relnamespace = n.oid and tb.table_schema = n.nspname \nLEFT JOIN pg_description d ON d.objoid = c.oid AND d.objsubid = '0' \nWHERE tb.table_schema = '%s' \n";
        if (StringUtils.isNotBlank((CharSequence)tablePattern)) {
            sql = (String)sql + "AND tb.table_name LIKE CONCAT('%%','%s','%%') \n";
        }
        sql = (String)sql + "limit 2000;";
        ArrayList tableInfoList = Lists.newArrayList();
        try {
            String[][] resultArr = SqlExecutor.executeSqlAndReturnArr(connection, String.format((String)sql, schema, tablePattern));
            if (resultArr.length <= 1) {
                return Lists.newArrayList();
            }
            for (int i = 1; i < resultArr.length; ++i) {
                if (resultArr[i].length == 0) continue;
                String tableName = resultArr[i][0];
                String tableDesc = resultArr[i][1];
                tableInfoList.add(TableInfoBO.builder().name(tableName).description(tableDesc).build());
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return tableInfoList;
    }

    @Override
    public List<TableInfoBO> fetchTables(Connection connection, String schema, List<String> tables) {
        String sql = "SELECT tb.table_name, d.description \nFROM information_schema.tables tb \nJOIN pg_class c ON c.relname = tb.table_name \nJOIN pg_namespace n ON c.relnamespace = n.oid and tb.table_schema = n.nspname \nLEFT JOIN pg_description d ON d.objoid = c.oid AND d.objsubid = '0' \nWHERE tb.table_schema = '%s' \nAND tb.table_name IN (%s) \n limit 2000;";
        ArrayList tableInfoList = Lists.newArrayList();
        String tableListStr = String.join((CharSequence)", ", tables.stream().map(x -> "'" + x + "'").collect(Collectors.toList()));
        try {
            String[][] resultArr = SqlExecutor.executeSqlAndReturnArr(connection, String.format(sql, schema, tableListStr));
            if (resultArr.length <= 1) {
                return Lists.newArrayList();
            }
            for (int i = 1; i < resultArr.length; ++i) {
                if (resultArr[i].length == 0) continue;
                String tableName = resultArr[i][0];
                String tableDesc = resultArr[i][1];
                tableInfoList.add(TableInfoBO.builder().name(tableName).description(tableDesc).build());
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return tableInfoList;
    }

    @Override
    public List<ColumnInfoBO> showColumns(Connection connection, String schema, String table) {
        String sql = "\nSELECT\n    a.attname as column_name,\n    col_description(a.attrelid, a.attnum) as column_description,\n    pg_catalog.format_type(a.atttypid, a.atttypmod) as data_type,\n    CASE\n        WHEN a.attnum = ANY (ind.indkey) THEN true\n        ELSE false\n    END as \u4e3b\u952e\u552f\u4e00,\n     a.attnotnull as \u975e\u7a7a\nFROM\n    pg_catalog.pg_attribute a\nLEFT JOIN\n    pg_catalog.pg_index ind ON ind.indrelid = a.attrelid AND ind.indisprimary\nLEFT JOIN\n    pg_catalog.pg_class c ON a.attrelid = c.oid\nLEFT JOIN\n    pg_catalog.pg_namespace n ON n.oid = c.relnamespace\nWHERE\n    c.relname = '%s'\n    AND a.attnum > 0\n    AND NOT a.attisdropped\n    AND n.nspname = '%s'\nORDER BY\n    a.attnum;";
        ArrayList columnInfoList = Lists.newArrayList();
        try {
            String[][] resultArr = SqlExecutor.executeSqlAndReturnArr(connection, null, String.format(sql, table, schema));
            if (resultArr.length <= 1) {
                return Lists.newArrayList();
            }
            for (int i = 1; i < resultArr.length; ++i) {
                if (resultArr[i].length == 0) continue;
                columnInfoList.add(ColumnInfoBO.builder().name(resultArr[i][0]).description(resultArr[i][1]).type(ColumnTypeParser.wrapType(resultArr[i][2])).primary(BooleanUtils.toBoolean((String)resultArr[i][3])).notnull(BooleanUtils.toBoolean((String)resultArr[i][4])).build());
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return columnInfoList;
    }

    @Override
    public List<ForeignKeyInfoBO> showForeignKeys(Connection connection, String schema, List<String> tables) {
        String sql = "SELECT\n    tc.table_name,\n    kcu.column_name,\n    tc.constraint_name,\n    ccu.table_name AS foreign_table_name,\n    ccu.column_name AS foreign_column_name\nFROM\n    information_schema.table_constraints AS tc\nJOIN\n    information_schema.key_column_usage AS kcu\n    ON tc.constraint_name = kcu.constraint_name\n    AND tc.table_schema = kcu.table_schema\nJOIN\n    information_schema.constraint_column_usage AS ccu\n    ON ccu.constraint_name = tc.constraint_name\n    AND ccu.table_schema = tc.table_schema\nWHERE\n    tc.constraint_type = 'FOREIGN KEY'\n    AND tc.table_schema='public'\n    AND tc.table_name in (%s)";
        ArrayList foreignKeyInfoList = Lists.newArrayList();
        String tableListStr = String.join((CharSequence)", ", tables.stream().map(x -> "'" + x + "'").collect(Collectors.toList()));
        try {
            sql = String.format(sql, tableListStr);
            String[][] resultArr = SqlExecutor.executeSqlAndReturnArr(connection, null, sql);
            if (resultArr.length <= 1) {
                return Lists.newArrayList();
            }
            for (int i = 1; i < resultArr.length; ++i) {
                if (resultArr[i].length == 0) continue;
                foreignKeyInfoList.add(ForeignKeyInfoBO.builder().table(resultArr[i][0]).column(resultArr[i][1]).referencedTable(resultArr[i][3]).referencedColumn(resultArr[i][4]).build());
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return foreignKeyInfoList;
    }

    @Override
    public List<String> sampleColumn(Connection connection, String schema, String table, String column) {
        String sql = "SELECT \n    \"%s\"\nFROM \n    \"%s\"\nLIMIT 99;";
        List<Object> sampleInfo = Lists.newArrayList();
        try {
            sql = String.format(sql, column, table);
            String[][] resultArr = SqlExecutor.executeSqlAndReturnArr(connection, schema, sql);
            if (resultArr.length <= 1) {
                return Lists.newArrayList();
            }
            for (int i = 1; i < resultArr.length; ++i) {
                if (resultArr[i].length == 0 || column.equalsIgnoreCase(resultArr[i][0])) continue;
                sampleInfo.add(resultArr[i][0]);
            }
        }
        catch (SQLException e) {
            log.error("sampleColumn error, sql:{}", (Object)sql);
            log.error("sampleColumn error", (Throwable)e);
        }
        Set siSet = sampleInfo.stream().collect(Collectors.toSet());
        sampleInfo = siSet.stream().collect(Collectors.toList());
        return sampleInfo;
    }

    @Override
    public ResultSetBO scanTable(Connection connection, String schema, String table) {
        String sql = "SELECT *\nFROM \n    %s\nLIMIT 20;";
        ResultSetBO resultSet = ResultSetBO.builder().build();
        try {
            resultSet = SqlExecutor.executeSqlAndReturnObject(connection, schema, String.format(sql, table));
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return resultSet;
    }

    @Override
    public BizDataSourceTypeEnum getType() {
        return BizDataSourceTypeEnum.POSTGRESQL;
    }
}

