/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athenai.nl2sql.constant;

import com.digiwin.athenai.nl2sql.constant.DatabaseDialectEnum;
import com.digiwin.athenai.nl2sql.constant.DbAccessTypeEnum;

public enum BizDataSourceTypeEnum {
    MYSQL(1, "mysql", DatabaseDialectEnum.MYSQL.getCode(), DbAccessTypeEnum.JDBC.getCode()),
    POSTGRESQL(2, "postgresql", DatabaseDialectEnum.POSTGRESQL.getCode(), DbAccessTypeEnum.JDBC.getCode()),
    SQLITE(3, "sqlite", DatabaseDialectEnum.MYSQL.getCode(), DbAccessTypeEnum.JDBC.getCode()),
    HOLOGRESS(10, "hologress", DatabaseDialectEnum.POSTGRESQL.getCode(), DbAccessTypeEnum.JDBC.getCode()),
    MYSQL_VPC(11, "mysql-vpc", DatabaseDialectEnum.MYSQL.getCode(), DbAccessTypeEnum.JDBC.getCode()),
    POSTGRESQL_VPC(12, "postgresql-vpc", DatabaseDialectEnum.POSTGRESQL.getCode(), DbAccessTypeEnum.JDBC.getCode()),
    ADB_PG(21, "adg_pg", DatabaseDialectEnum.POSTGRESQL.getCode(), DbAccessTypeEnum.DATA_API.getCode()),
    MAX_COMPUTE(31, "max_compute", DatabaseDialectEnum.MYSQL.getCode(), DbAccessTypeEnum.JDBC.getCode()),
    FC_MEMORY_DB(41, "fc_memory_db", DatabaseDialectEnum.SQLite.getCode(), DbAccessTypeEnum.FC_HTTP.getCode()),
    MYSQL_VIRTUAL(51, "mysql-virtual", DatabaseDialectEnum.MYSQL.getCode(), DbAccessTypeEnum.MEMORY.getCode()),
    POSTGRESQL_VIRTUAL(52, "postgresql-virtual", DatabaseDialectEnum.POSTGRESQL.getCode(), DbAccessTypeEnum.MEMORY.getCode());

    public Integer code;
    public String typeName;
    public String dialect;
    public String protocol;

    private BizDataSourceTypeEnum(Integer code, String typeName, String dialect, String protocol) {
        this.code = code;
        this.typeName = typeName;
        this.dialect = dialect;
        this.protocol = protocol;
    }

    public Integer getCode() {
        return this.code;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getDialect() {
        return this.dialect;
    }

    public static String getTypeNameByCode(Integer code) {
        for (BizDataSourceTypeEnum type : BizDataSourceTypeEnum.values()) {
            if (!type.getCode().equals(code)) continue;
            return type.getTypeName();
        }
        return null;
    }

    public static String getDialectByCode(Integer code) {
        for (BizDataSourceTypeEnum type : BizDataSourceTypeEnum.values()) {
            if (!type.getCode().equals(code)) continue;
            return type.getDialect();
        }
        return null;
    }

    public static String getProtocolByCode(Integer code) {
        for (BizDataSourceTypeEnum type : BizDataSourceTypeEnum.values()) {
            if (!type.getCode().equals(code)) continue;
            return type.getProtocol();
        }
        return null;
    }

    public static BizDataSourceTypeEnum fromCode(Integer code) {
        for (BizDataSourceTypeEnum type : BizDataSourceTypeEnum.values()) {
            if (type.getCode() != code) continue;
            return type;
        }
        return null;
    }

    public static BizDataSourceTypeEnum fromTypeName(String typeName) {
        for (BizDataSourceTypeEnum type : BizDataSourceTypeEnum.values()) {
            if (!type.getTypeName().equalsIgnoreCase(typeName)) continue;
            return type;
        }
        return null;
    }

    public static boolean isMysqlDialect(String typeName) {
        return BizDataSourceTypeEnum.isDialect(typeName, DatabaseDialectEnum.MYSQL.getCode());
    }

    public static boolean isPgDialect(String typeName) {
        return BizDataSourceTypeEnum.isDialect(typeName, DatabaseDialectEnum.POSTGRESQL.getCode());
    }

    public static boolean isAdbPg(String typeName) {
        BizDataSourceTypeEnum te = BizDataSourceTypeEnum.fromTypeName(typeName);
        if (te == null) {
            return false;
        }
        return DatabaseDialectEnum.POSTGRESQL.getCode().equalsIgnoreCase(te.getDialect()) && DbAccessTypeEnum.DATA_API.getCode().equalsIgnoreCase(te.getProtocol());
    }

    public static boolean isDialect(String typeName, String dialect) {
        BizDataSourceTypeEnum te = BizDataSourceTypeEnum.fromTypeName(typeName);
        if (te == null) {
            return false;
        }
        return dialect.equalsIgnoreCase(te.getDialect());
    }
}

