/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athenai.nl2sql.controller;

import com.alibaba.cloud.ai.graph.async.AsyncGenerator;
import com.alibaba.cloud.ai.graph.exception.GraphRunnerException;
import com.alibaba.cloud.ai.graph.streaming.StreamingOutput;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athenai.component.AiChatService;
import com.digiwin.athenai.domain.AiRequest;
import com.digiwin.athenai.nl2sql.component.SqlMcpComponent;
import com.digiwin.athenai.nl2sql.entity.SchemaInfo;
import com.digiwin.athenai.nl2sql.service.Nl2SqlService;
import com.digiwin.athenai.nl2sql.service.SchemaInfoService;
import com.digiwin.athenai.nl2sql.service.impl.DbSqlExecutor;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.chat.client.advisor.MessageChatMemoryAdvisor;
import org.springframework.ai.chat.client.advisor.SimpleLoggerAdvisor;
import org.springframework.ai.chat.model.ToolContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Sinks;

@RestController
@RequestMapping(value={"nl2sql"})
public class Nl2SqlController {
    private static final Logger logger = LoggerFactory.getLogger(Nl2SqlController.class);
    String agent = "agent01";
    @Autowired
    DbSqlExecutor agentSqlExecutor;
    @Autowired
    SchemaInfoService schemaInfoService;
    @Autowired
    SqlMcpComponent sqlMcpComponent;
    @Autowired
    Nl2SqlService nl2SqlService;
    @Autowired
    AiChatService aiChatService;
    @Autowired
    MessageChatMemoryAdvisor messageChatMemoryAdvisor;
    @Autowired
    SimpleLoggerAdvisor simpleLoggerAdvisor;

    @RequestMapping(value={"test01"})
    public Object test01(@RequestParam String query) throws Exception {
        String obj = null;
        obj = this.sqlMcpComponent.simpleNl2Sql(query, new ToolContext(Map.of("agent", this.agent)));
        return obj;
    }

    @RequestMapping(value={"addSchemaInfo"})
    public Object addSchemaInfo(@RequestBody SchemaInfo schemaInfo) {
        this.schemaInfoService.save(schemaInfo);
        return schemaInfo;
    }

    @RequestMapping(value={"invokeMcp"})
    public Object invokeMcp(@RequestParam String query) throws Exception {
        String obj = this.sqlMcpComponent.simpleNl2Sql(query, new ToolContext(Map.of("agent", this.agent)));
        return obj;
    }

    @RequestMapping(value={"invokeGraph1"})
    public Object invokeGraph1(@RequestBody Map<String, Object> params) throws Exception {
        Map<String, Object> obj = this.nl2SqlService.invoke(params);
        return obj;
    }

    @PostMapping(value={"/chat"})
    @Operation(summary="DashScope Flux Chat")
    public Flux<String> chat(HttpServletResponse response, @Validated @RequestBody String prompt, @RequestHeader(value="model", required=false) String model, @RequestHeader(value="chatId", required=false, defaultValue="spring-ai-alibaba-playground-chat") String chatId) throws GraphRunnerException {
        response.setCharacterEncoding("UTF-8");
        response.setContentType("text/event-stream");
        response.setHeader("Cache-Control", "no-cache");
        response.setHeader("Connection", "keep-alive");
        response.setHeader("Access-Control-Allow-Origin", "*");
        response.setHeader("Access-Control-Allow-Headers", "Cache-Control");
        String query = prompt;
        logger.info("Starting stream search for query: {} with agentId: {}", (Object)query, (Object)this.agent);
        Sinks.Many sink = Sinks.many().unicast().onBackpressureBuffer();
        AsyncGenerator generator = this.nl2SqlService.getNl2sqlGraph().stream(Map.of("query", query, "agent", this.agent));
        CompletableFuture.runAsync(() -> {
            try {
                ((CompletableFuture)generator.forEachAsync(output -> {
                    block6: {
                        try {
                            logger.debug("Received output: {}", (Object)output.getClass().getSimpleName());
                            if (output instanceof StreamingOutput) {
                                StreamingOutput streamingOutput = (StreamingOutput)output;
                                String chunk = streamingOutput.chunk();
                                if (chunk != null && !chunk.trim().isEmpty()) {
                                    logger.debug("Emitting chunk: {}", (Object)chunk);
                                    String content = "";
                                    try {
                                        JSONObject obj = JSON.parseObject((String)chunk);
                                        content = obj.getString("data");
                                    }
                                    catch (Exception e) {
                                        e.printStackTrace();
                                    }
                                    sink.tryEmitNext((Object)content);
                                    break block6;
                                }
                                logger.warn("ReceFenerator: mapResult called, finalResultived null or empty chunk from streaming output");
                                break block6;
                            }
                            logger.debug("Non-streaming output received: {}", output);
                        }
                        catch (Exception e) {
                            logger.error("Error processing streaming output: ", (Throwable)e);
                        }
                    }
                }).thenAccept(v -> {
                    logger.info("Stream processing completed successfully");
                    sink.tryEmitComplete();
                })).exceptionally(e -> {
                    logger.error("Error in stream processing: ", e);
                    sink.tryEmitComplete();
                    return null;
                });
            }
            catch (Exception e2) {
                logger.error("Error starting stream processing: ", (Throwable)e2);
                sink.tryEmitError((Throwable)e2);
            }
        });
        return sink.asFlux().doOnSubscribe(subscription -> logger.info("Client subscribed to stream")).doOnCancel(() -> logger.info("Client disconnected from stream")).doOnError(e -> logger.error("Error occurred during streaming: ", e)).doOnComplete(() -> logger.info("Stream completed successfully"));
    }

    @PostMapping(value={"/chat2"})
    @Operation(summary="DashScope Flux Chat")
    public Flux<String> chat2(HttpServletResponse response, @Validated @RequestBody String prompt, @RequestHeader(value="model", required=false) String model, @RequestHeader(value="chatId", required=false, defaultValue="spring-ai-alibaba-playground-chat") String chatId) throws GraphRunnerException {
        response.setCharacterEncoding("UTF-8");
        response.setContentType("text/event-stream");
        response.setHeader("Cache-Control", "no-cache");
        response.setHeader("Connection", "keep-alive");
        response.setHeader("Access-Control-Allow-Origin", "*");
        response.setHeader("Access-Control-Allow-Headers", "Cache-Control");
        String query = prompt;
        logger.info("Starting stream search for query: {} with agentId: {} with chatId {}", new Object[]{query, this.agent, chatId});
        String system = "\u4f60\u662f\u4e00\u4e2aERP\u4e13\u5bb6,\u53ef\u4ee5\u901a\u8fc7\u5de5\u5177\u7ed9\u7528\u6237\u63d0\u4f9b\u6570\u636e\u67e5\u8be2,\u63d0\u4f9b\u67e5\u8be2\u65f6\u8bf7\u63d0\u4f9b\u5b8c\u6574\u7684\u4e1a\u52a1\u8bed\u4e49\n";
        AiRequest aiRequest = new AiRequest();
        aiRequest.setAgent(this.agent);
        aiRequest.setSystem(system);
        aiRequest.setUseChatMemory(true);
        Flux stringFlux = this.aiChatService.createChatClient(aiRequest).prompt().user(prompt).tools(new Object[]{new SqlMcpComponent(this.nl2SqlService)}).toolContext(Map.of("agent", this.agent)).advisors(a -> a.param("chat_memory_conversation_id", (Object)aiRequest.getConversationId())).stream().content();
        return stringFlux;
    }
}

