/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athenai.nl2sql.node;

import com.alibaba.cloud.ai.graph.OverAllState;
import com.alibaba.cloud.ai.graph.action.NodeAction;
import com.alibaba.cloud.ai.graph.async.AsyncGenerator;
import com.digiwin.athenai.constant.StreamResponseType;
import com.digiwin.athenai.dashscope.util.StateUtils;
import com.digiwin.athenai.dashscope.util.StreamingChatGeneratorUtil;
import com.digiwin.athenai.nl2sql.constant.SqlPrompts;
import com.digiwin.athenai.nl2sql.node.AbstractPlanBasedNode;
import com.digiwin.athenai.utils.StepResultUtils;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.chat.client.ChatClient;
import reactor.core.publisher.Flux;

public class PythonAnalyzeNode
extends AbstractPlanBasedNode
implements NodeAction {
    private static final Logger log = LoggerFactory.getLogger(PythonAnalyzeNode.class);
    private final ChatClient chatClient;

    public PythonAnalyzeNode(ChatClient.Builder chatClientBuilder) {
        this.chatClient = chatClientBuilder.build();
    }

    public Map<String, Object> apply(OverAllState state) throws Exception {
        this.logNodeEntry();
        String userQuery = StateUtils.getStringValue((OverAllState)state, (String)"query");
        String pythonOutput = StateUtils.getStringValue((OverAllState)state, (String)"PYTHON_EXECUTE_NODE_OUTPUT");
        int currentStep = this.getCurrentStepNumber(state);
        Map sqlExecuteResult = (Map)StateUtils.getObjectValue((OverAllState)state, (String)"SQL_EXECUTE_NODE_OUTPUT", Map.class, new HashMap());
        String systemPrompt = SqlPrompts.getPythonAnalyzePromptTemplate().render(Map.of("python_output", pythonOutput, "user_query", userQuery));
        Flux pythonAnalyzeFlux = this.chatClient.prompt().system(systemPrompt).stream().chatResponse();
        AsyncGenerator generator = StreamingChatGeneratorUtil.createStreamingGeneratorWithMessages(this.getClass(), (OverAllState)state, (String)"\u6b63\u5728\u5206\u6790\u4ee3\u7801\u8fd0\u884c\u7ed3\u679c...\n", (String)"\n\u7ed3\u679c\u5206\u6790\u5b8c\u6210\u3002", aiResponse -> {
            Map updatedSqlResult = StepResultUtils.addStepResult((Map)sqlExecuteResult, (Integer)currentStep, (String)aiResponse);
            this.logNodeOutput("python_analysis_result", aiResponse);
            return Map.of("SQL_EXECUTE_NODE_OUTPUT", updatedSqlResult, "PLAN_CURRENT_STEP", currentStep + 1);
        }, (Flux)pythonAnalyzeFlux, (StreamResponseType)StreamResponseType.PYTHON_ANALYSIS);
        return Map.of("PYTHON_ANALYSIS_NODE_OUTPUT", generator);
    }
}

