/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athenai.nl2sql.service;

import com.digiwin.athenai.component.AiChatService;
import com.digiwin.athenai.component.AiEmbeddingService;
import com.digiwin.athenai.nl2sql.connector.config.DbConfig;
import com.digiwin.athenai.nl2sql.constant.SqlPrompts;
import com.digiwin.athenai.nl2sql.service.SqlAsistantService;
import com.digiwin.athenai.utils.MarkdownParser;
import com.digiwin.athenai.utils.PromptUtil;
import java.util.HashMap;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.document.Document;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class SqlGeneratorService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SqlGeneratorService.class);
    @Autowired
    AiEmbeddingService aiEmbeddingService;
    @Autowired
    SqlAsistantService sqlAsistantService;
    @Autowired
    AiChatService aiChatService;

    public String generateSql(String agent, String query) throws Exception {
        Assert.notNull((Object)agent, (String)"agent is null");
        Assert.notNull((Object)query, (String)"query is null");
        DbConfig dbConfig = this.sqlAsistantService.getDbConfig(agent);
        Assert.notNull((Object)dbConfig, (String)"dbConfig is null");
        List<Document> evidences = this.sqlAsistantService.evidences(agent, query);
        String evidencesStr = PromptUtil.formatDocuments(evidences);
        List<Document> schemas = this.sqlAsistantService.tables(agent, query, evidences);
        Assert.notEmpty(schemas, (String)("no table info found by query: " + query));
        String schemaStr = PromptUtil.formatDocuments(schemas);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("dialect", dbConfig.getDialectType());
        params.put("question", query);
        params.put("schema_info", schemaStr);
        params.put("evidence", evidencesStr);
        String system = SqlPrompts.sql_generator_system().render(params);
        String user = SqlPrompts.sql_generator_user().render(params);
        String sql = this.aiChatService.simpleCall(system, user);
        sql = MarkdownParser.extractRawText((String)sql);
        log.info("nl2sql: {} =>{} ", (Object)query, (Object)sql);
        return sql;
    }
}

