/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athenai.nl2sql.code.impl;

import com.digiwin.athenai.nl2sql.code.CodeExecutorProperties;
import com.digiwin.athenai.nl2sql.code.CodePoolExecutorService;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCodePoolExecutorService
implements CodePoolExecutorService {
    private static final Logger log = LoggerFactory.getLogger(AbstractCodePoolExecutorService.class);
    protected final ConcurrentHashMap<String, CodePoolExecutorService.State> coreContainerState;
    protected final ConcurrentHashMap<String, CodePoolExecutorService.State> tempContainerState;
    protected final ConcurrentHashMap<String, Future<?>> tempContainerRemoveFuture;
    protected final ArrayBlockingQueue<FutureTask<CodePoolExecutorService.TaskResponse>> taskQueue;
    protected final ArrayBlockingQueue<String> readyCoreContainer;
    protected final ArrayBlockingQueue<String> readyTempContainer;
    protected final AtomicInteger currentCoreContainerSize;
    protected final AtomicInteger currentTempContainerSize;
    protected final ExecutorService consumerThreadPool;
    protected final CodeExecutorProperties properties;

    public AbstractCodePoolExecutorService(CodeExecutorProperties properties) {
        this.properties = properties;
        this.coreContainerState = new ConcurrentHashMap();
        this.tempContainerState = new ConcurrentHashMap();
        this.tempContainerRemoveFuture = new ConcurrentHashMap();
        this.taskQueue = new ArrayBlockingQueue(properties.getTaskQueueSize());
        this.readyCoreContainer = new ArrayBlockingQueue(properties.getCoreContainerNum());
        this.readyTempContainer = new ArrayBlockingQueue(properties.getTempContainerNum());
        this.consumerThreadPool = new ThreadPoolExecutor(properties.getCoreThreadSize(), properties.getMaxThreadSize(), properties.getKeepThreadAliveTime(), TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(properties.getThreadQueueSize()));
        this.currentCoreContainerSize = new AtomicInteger(0);
        this.currentTempContainerSize = new AtomicInteger(0);
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            log.info("Shutting down container pool executor...");
            try {
                this.shutdownPool();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }));
    }

    protected abstract String createNewContainer() throws Exception;

    protected abstract CodePoolExecutorService.TaskResponse execTaskInContainer(CodePoolExecutorService.TaskRequest var1, String var2);

    protected abstract void stopContainer(String var1) throws Exception;

    protected abstract void removeContainer(String var1) throws Exception;

    protected void shutdownPool() throws Exception {
        this.consumerThreadPool.shutdownNow();
        ((ConcurrentHashMap.KeySetView)this.tempContainerState.keySet()).forEach(id -> this.removeContainerAndState((String)id, false, true));
        ((ConcurrentHashMap.KeySetView)this.coreContainerState.keySet()).forEach(id -> this.removeContainerAndState((String)id, true, true));
        this.tempContainerState.clear();
        this.coreContainerState.clear();
        this.tempContainerRemoveFuture.clear();
        this.readyCoreContainer.clear();
        this.readyTempContainer.clear();
        this.taskQueue.clear();
    }

    private void removeContainerAndState(String containerId, boolean isCore, boolean isForce) {
        try {
            if (isCore) {
                CodePoolExecutorService.State state = this.coreContainerState.replace(containerId, CodePoolExecutorService.State.REMOVING);
                if (state == CodePoolExecutorService.State.RUNNING) {
                    if (isForce) {
                        this.stopContainer(containerId);
                    } else {
                        throw new RuntimeException("Container is still Running!");
                    }
                }
                this.removeContainer(containerId);
                this.coreContainerState.remove(containerId);
                this.currentCoreContainerSize.decrementAndGet();
                log.info("Core Container {} has been removed successfully", (Object)containerId);
            } else {
                CodePoolExecutorService.State state = this.tempContainerState.replace(containerId, CodePoolExecutorService.State.REMOVING);
                if (state == CodePoolExecutorService.State.RUNNING) {
                    if (isForce) {
                        this.stopContainer(containerId);
                    } else {
                        throw new RuntimeException("Container is still Running!");
                    }
                }
                this.removeContainer(containerId);
                this.tempContainerState.remove(containerId);
                this.tempContainerRemoveFuture.remove(containerId);
                this.currentTempContainerSize.decrementAndGet();
                log.info("Temp Container {} has been removed successfully", (Object)containerId);
            }
        }
        catch (Exception e) {
            log.error("Error when trying to remove a container, containerId: {}, info: {}", new Object[]{containerId, e.getMessage(), e});
        }
    }

    private Future<?> registerRemoveTempContainer(String containerId) {
        return this.consumerThreadPool.submit(() -> {
            try {
                Thread.sleep(this.properties.getKeepThreadAliveTime() * 1000L * 60L);
                if (this.tempContainerState.get(containerId) == CodePoolExecutorService.State.RUNNING) {
                    throw new InterruptedException("Container " + containerId + " is already running");
                }
            }
            catch (InterruptedException e) {
                log.debug("Interrupted while waiting for temp container to be removed, info: {}", (Object)e.getMessage());
                return;
            }
            this.removeContainerAndState(containerId, false, false);
        });
    }

    private CodePoolExecutorService.TaskResponse useCoreContainer(String containerId, CodePoolExecutorService.TaskRequest request) {
        try {
            this.coreContainerState.replace(containerId, CodePoolExecutorService.State.RUNNING);
            CodePoolExecutorService.TaskResponse resp = this.execTaskInContainer(request, containerId);
            if (!resp.isSuccess() && !resp.executionSuccessButResultFailed()) {
                log.error("use core container failed, {}", (Object)resp.exceptionMsg());
                this.coreContainerState.replace(containerId, CodePoolExecutorService.State.REMOVING);
                this.removeContainerAndState(containerId, true, true);
                return this.pushTaskQueue(request);
            }
            this.coreContainerState.replace(containerId, CodePoolExecutorService.State.READY);
            this.readyCoreContainer.add(containerId);
            this.popTaskQueue();
            return resp;
        }
        catch (Exception e) {
            log.error("use core container failed, {}", (Object)e.getMessage(), (Object)e);
            return CodePoolExecutorService.TaskResponse.exception(e.getMessage());
        }
    }

    private CodePoolExecutorService.TaskResponse useTempContainer(String containerId, CodePoolExecutorService.TaskRequest request) {
        try {
            Future<?> future = this.tempContainerRemoveFuture.remove(containerId);
            if (future != null) {
                if (future.isDone()) {
                    log.debug("reselect strategy: {} ...", (Object)request.toString());
                    return this.runTask(request);
                }
                future.cancel(true);
            }
            this.tempContainerState.replace(containerId, CodePoolExecutorService.State.RUNNING);
            CodePoolExecutorService.TaskResponse resp = this.execTaskInContainer(request, containerId);
            if (!resp.isSuccess() && !resp.executionSuccessButResultFailed()) {
                log.error("use temp container failed, {}", (Object)resp.exceptionMsg());
                this.tempContainerState.replace(containerId, CodePoolExecutorService.State.REMOVING);
                this.removeContainerAndState(containerId, false, true);
                return this.pushTaskQueue(request);
            }
            this.tempContainerState.replace(containerId, CodePoolExecutorService.State.READY);
            this.readyTempContainer.add(containerId);
            this.tempContainerRemoveFuture.put(containerId, this.registerRemoveTempContainer(containerId));
            this.popTaskQueue();
            return resp;
        }
        catch (Exception e) {
            log.error("use temp container failed, {}", (Object)e.getMessage(), (Object)e);
            return CodePoolExecutorService.TaskResponse.exception(e.getMessage());
        }
    }

    private CodePoolExecutorService.TaskResponse createAndUseCoreContainer(CodePoolExecutorService.TaskRequest request) {
        String containerId;
        try {
            containerId = this.createNewContainer();
        }
        catch (Exception e) {
            log.error("create new container failed, {}", (Object)e.getMessage(), (Object)e);
            return CodePoolExecutorService.TaskResponse.exception(e.getMessage());
        }
        this.coreContainerState.put(containerId, CodePoolExecutorService.State.READY);
        return this.useCoreContainer(containerId, request);
    }

    private CodePoolExecutorService.TaskResponse createAndUseTempContainer(CodePoolExecutorService.TaskRequest request) {
        String containerId;
        try {
            containerId = this.createNewContainer();
        }
        catch (Exception e) {
            log.error("create new container failed, {}", (Object)e.getMessage(), (Object)e);
            return CodePoolExecutorService.TaskResponse.exception(e.getMessage());
        }
        this.tempContainerState.put(containerId, CodePoolExecutorService.State.READY);
        return this.useTempContainer(containerId, request);
    }

    private CodePoolExecutorService.TaskResponse pushTaskQueue(CodePoolExecutorService.TaskRequest request) throws ExecutionException, InterruptedException {
        FutureTask<CodePoolExecutorService.TaskResponse> ft = new FutureTask<CodePoolExecutorService.TaskResponse>(() -> {
            log.info("Execute tasks in the BlockingQueue {} ...", (Object)request.toString());
            return this.runTask(request);
        });
        this.taskQueue.put(ft);
        return ft.get();
    }

    private void popTaskQueue() {
        FutureTask<CodePoolExecutorService.TaskResponse> future = this.taskQueue.poll();
        if (future == null) {
            return;
        }
        log.info("Get task from the BlockingQueue ...");
        this.consumerThreadPool.submit(future);
    }

    @Override
    public CodePoolExecutorService.TaskResponse runTask(CodePoolExecutorService.TaskRequest request) {
        int currentTemp;
        int currentCore;
        String freeCoreId = this.readyCoreContainer.poll();
        if (freeCoreId != null) {
            log.debug("Use free core container to run task {} ...", (Object)request.toString());
            return this.useCoreContainer(freeCoreId, request);
        }
        String freeTempId = this.readyTempContainer.poll();
        if (freeTempId != null) {
            log.debug("Use free temp container to run task {} ...", (Object)request.toString());
            return this.useTempContainer(freeTempId, request);
        }
        boolean useCoreContainer = true;
        do {
            if ((currentCore = this.currentCoreContainerSize.get()) < this.properties.getCoreContainerNum()) continue;
            useCoreContainer = false;
            break;
        } while (!this.currentCoreContainerSize.compareAndSet(currentCore, currentCore + 1));
        if (useCoreContainer) {
            log.debug("Create new core container to run task {} ...", (Object)request.toString());
            return this.createAndUseCoreContainer(request);
        }
        boolean useTempContainer = true;
        do {
            if ((currentTemp = this.currentTempContainerSize.get()) < this.properties.getTempContainerNum()) continue;
            useTempContainer = false;
            break;
        } while (!this.currentTempContainerSize.compareAndSet(currentTemp, currentTemp + 1));
        if (useTempContainer) {
            log.debug("Create new temp container to run task {} ...", (Object)request.toString());
            return this.createAndUseTempContainer(request);
        }
        try {
            log.debug("push task into BlockingQueue: {} ...", (Object)request.toString());
            return this.pushTaskQueue(request);
        }
        catch (Exception e) {
            log.error("An exception occurred while executing the task: {}", (Object)e.getMessage(), (Object)e);
            return CodePoolExecutorService.TaskResponse.exception(e.getMessage());
        }
    }

    protected void clearTempDir(Path tempDir) {
        try {
            Files.walkFileTree(tempDir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(this){

                @Override
                @NotNull
                public FileVisitResult visitFile(@NotNull Path file, @NotNull BasicFileAttributes attrs) throws IOException {
                    Files.delete(file);
                    return super.visitFile(file, attrs);
                }

                @Override
                @NotNull
                public FileVisitResult postVisitDirectory(@NotNull Path dir, @Nullable IOException exc) throws IOException {
                    if (exc != null) {
                        throw exc;
                    }
                    Files.delete(dir);
                    return super.postVisitDirectory(dir, exc);
                }
            });
            log.info("Temp directory has been deleted.");
        }
        catch (Exception e) {
            log.warn("Exception in clean temp directory: {}", (Object)e.getMessage());
        }
    }

    protected void createWritableFile(Path tempDir, String fileName) throws IOException {
        File file = new File(tempDir.resolve(fileName).toUri());
        if (file.exists()) {
            if (!file.setWritable(true, false)) {
                throw new IOException("Cannot write to existing file: " + file.getAbsolutePath());
            }
            return;
        }
        if (!file.createNewFile()) {
            throw new IOException("Failed to create file: " + file.getAbsolutePath());
        }
        if (!file.setWritable(true, false)) {
            throw new IOException("Cannot write to existing file: " + file.getAbsolutePath());
        }
    }

    protected String generateContainerName() {
        return this.properties.getContainerNamePrefix() + "_" + System.currentTimeMillis() + "_" + Thread.currentThread().getName();
    }
}

