/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athenai.nl2sql.connector.support;

import com.digiwin.athenai.nl2sql.connector.AbstractDdl;
import com.digiwin.athenai.nl2sql.connector.config.DbConfig;
import com.digiwin.athenai.nl2sql.constant.BizDataSourceTypeEnum;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.stereotype.Service;

@Service
public class DdlFactory {
    private static Map<String, AbstractDdl> ddlExecutorSet = new ConcurrentHashMap<String, AbstractDdl>();

    public static void registry(AbstractDdl ddlExecutor) {
        ddlExecutorSet.put(DdlFactory.getConstraint(ddlExecutor.getType()), ddlExecutor);
    }

    public AbstractDdl getDdlExecutor(DbConfig dbConfig) {
        BizDataSourceTypeEnum type = BizDataSourceTypeEnum.fromTypeName(dbConfig.getDialectType());
        if (type == null) {
            throw new RuntimeException("unknown db type");
        }
        return this.getDdlExecutor(type);
    }

    public AbstractDdl getDdlExecutor(BizDataSourceTypeEnum type) {
        return ddlExecutorSet.get(DdlFactory.getConstraint(type));
    }

    private static String getConstraint(BizDataSourceTypeEnum type) {
        return type.getProtocol() + "@" + type.getDialect();
    }
}

