/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athenai.nl2sql.constant;

import java.util.Arrays;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public enum DbAccessTypeEnum {
    JDBC("jdbc"),
    SDK("sdk"),
    DATA_API("data-api"),
    FC_HTTP("fc-http"),
    MEMORY("in-memory");

    private String code;

    private DbAccessTypeEnum(String code) {
        this.code = code;
    }

    public static DbAccessTypeEnum of(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return null;
        }
        Optional<DbAccessTypeEnum> any = Arrays.stream(DbAccessTypeEnum.values()).filter(typeEnum -> code.equals(typeEnum.getCode())).findAny();
        return any.orElse(null);
    }

    public String getCode() {
        return this.code;
    }
}

