/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athenai.nl2sql.controller;

import com.alibaba.cloud.ai.graph.async.AsyncGenerator;
import com.alibaba.cloud.ai.graph.exception.GraphRunnerException;
import com.alibaba.cloud.ai.graph.streaming.StreamingOutput;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athenai.component.AiChatService;
import com.digiwin.athenai.domain.AiRequest;
import com.digiwin.athenai.nl2sql.component.SqlMcpComponent;
import com.digiwin.athenai.nl2sql.connector.config.DbConfig;
import com.digiwin.athenai.nl2sql.dto.SchemaInitRequest;
import com.digiwin.athenai.nl2sql.entity.SchemaInfo;
import com.digiwin.athenai.nl2sql.povo.InitSchemaDto;
import com.digiwin.athenai.nl2sql.service.Nl2SqlService;
import com.digiwin.athenai.nl2sql.service.SchemaInfoService;
import com.digiwin.athenai.nl2sql.service.SqlAsistantService;
import com.digiwin.athenai.nl2sql.service.ali.AliNl2sqlService;
import com.digiwin.athenai.nl2sql.service.ali.SimpleVectorStoreService;
import com.digiwin.athenai.nl2sql.service.impl.DbSqlExecutor;
import com.digiwin.athenai.tool.TimeTool;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.chat.client.advisor.MessageChatMemoryAdvisor;
import org.springframework.ai.chat.client.advisor.SimpleLoggerAdvisor;
import org.springframework.ai.chat.model.ToolContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Sinks;

@RestController
@RequestMapping(value={"/api/nl2sql/"})
public class Nl2SqlController {
    private static final Logger logger = LoggerFactory.getLogger(Nl2SqlController.class);
    String agent = "e10_80_1";
    @Autowired
    DbSqlExecutor agentSqlExecutor;
    @Autowired
    SchemaInfoService schemaInfoService;
    @Autowired
    SqlMcpComponent sqlMcpComponent;
    @Autowired
    Nl2SqlService nl2SqlService;
    @Autowired
    AiChatService aiChatService;
    @Autowired
    MessageChatMemoryAdvisor messageChatMemoryAdvisor;
    @Autowired
    SimpleLoggerAdvisor simpleLoggerAdvisor;
    @Autowired
    AliNl2sqlService aliNl2sqlService;
    @Autowired
    SimpleVectorStoreService simpleVectorStoreService;
    @Autowired
    SqlAsistantService sqlAsistantService;

    @RequestMapping(value={"test01"})
    public Object test01(@RequestParam String query, @RequestParam String agent) throws Exception {
        Object obj = null;
        return obj;
    }

    @RequestMapping(value={"test02"})
    public Object test02(@RequestParam String query, @RequestParam String agent) throws Exception {
        Object obj = null;
        return obj;
    }

    @RequestMapping(value={"addSchemaInfo"})
    public Object addSchemaInfo(@RequestBody SchemaInfo schemaInfo) {
        this.schemaInfoService.save(schemaInfo);
        return schemaInfo;
    }

    @RequestMapping(value={"invokeMcp"})
    public Object invokeMcp(@RequestParam String query) throws Exception {
        String obj = this.sqlMcpComponent.simpleNl2Sql(query, new ToolContext(Map.of("agent", this.agent)));
        return obj;
    }

    @RequestMapping(value={"invokeGraph1"})
    public Object invokeGraph1(@RequestBody Map<String, Object> params) throws Exception {
        Map<String, Object> obj = this.nl2SqlService.invoke(params);
        return obj;
    }

    @PostMapping(value={"/chat1"})
    @Operation(summary="DashScope Flux Chat")
    public Flux<String> chat1(HttpServletResponse response, @Validated @RequestBody String prompt, @RequestHeader(value="model", required=false) String model, @RequestHeader(value="chatId", required=false, defaultValue="spring-ai-alibaba-playground-chat") String chatId) throws GraphRunnerException {
        response.setCharacterEncoding("UTF-8");
        response.setContentType("text/event-stream");
        response.setHeader("Cache-Control", "no-cache");
        response.setHeader("Connection", "keep-alive");
        response.setHeader("Access-Control-Allow-Origin", "*");
        response.setHeader("Access-Control-Allow-Headers", "Cache-Control");
        String query = prompt;
        logger.info("Starting stream search for query: {} with agentId: {}", (Object)query, (Object)this.agent);
        Sinks.Many sink = Sinks.many().unicast().onBackpressureBuffer();
        AsyncGenerator generator = this.nl2SqlService.getNl2sqlGraph().stream(Map.of("query", query, "agent", this.agent));
        CompletableFuture.runAsync(() -> {
            try {
                ((CompletableFuture)generator.forEachAsync(output -> {
                    block6: {
                        try {
                            logger.debug("Received output: {}", (Object)output.getClass().getSimpleName());
                            if (output instanceof StreamingOutput) {
                                StreamingOutput streamingOutput = (StreamingOutput)output;
                                String chunk = streamingOutput.chunk();
                                if (chunk != null && !chunk.trim().isEmpty()) {
                                    logger.debug("Emitting chunk: {}", (Object)chunk);
                                    String content = "";
                                    try {
                                        JSONObject obj = JSON.parseObject((String)chunk);
                                        content = obj.getString("data");
                                    }
                                    catch (Exception e) {
                                        e.printStackTrace();
                                    }
                                    sink.tryEmitNext((Object)content);
                                    break block6;
                                }
                                logger.warn("ReceFenerator: mapResult called, finalResultived null or empty chunk from streaming output");
                                break block6;
                            }
                            logger.debug("Non-streaming output received: {}", output);
                        }
                        catch (Exception e) {
                            logger.error("Error processing streaming output: ", (Throwable)e);
                        }
                    }
                }).thenAccept(v -> {
                    logger.info("Stream processing completed successfully");
                    sink.tryEmitComplete();
                })).exceptionally(e -> {
                    logger.error("Error in stream processing: ", e);
                    sink.tryEmitComplete();
                    return null;
                });
            }
            catch (Exception e2) {
                logger.error("Error starting stream processing: ", (Throwable)e2);
                sink.tryEmitError((Throwable)e2);
            }
        });
        return sink.asFlux().doOnSubscribe(subscription -> logger.info("Client subscribed to stream")).doOnCancel(() -> logger.info("Client disconnected from stream")).doOnError(e -> logger.error("Error occurred during streaming: ", e)).doOnComplete(() -> logger.info("Stream completed successfully"));
    }

    @PostMapping(value={"/chat2"})
    @Operation(summary="DashScope Flux Chat")
    public Flux<String> chat2(HttpServletResponse response, @Validated @RequestBody String prompt, @RequestHeader(value="model", required=false) String model, @RequestHeader(value="chatId", required=false, defaultValue="spring-ai-alibaba-playground-chat") String chatId) throws GraphRunnerException {
        response.setCharacterEncoding("UTF-8");
        String query = prompt;
        logger.info("Starting stream search for query: {} with agentId: {} with chatId {}", new Object[]{query, this.agent, chatId});
        String system = "\u4f60\u662f\u4e00\u4e2aERP\u4e13\u5bb6,\u53ef\u4ee5\u901a\u8fc7\u5de5\u5177\u7ed9\u7528\u6237\u63d0\u4f9b\u6570\u636e\u67e5\u8be2,\u63d0\u4f9b\u67e5\u8be2\u65f6\u8bf7\u63d0\u4f9b\u5b8c\u6574\u7684\u4e1a\u52a1\u8bed\u4e49\n";
        AiRequest aiRequest = new AiRequest();
        aiRequest.setAgent(this.agent);
        aiRequest.setSystem(system);
        aiRequest.setUseChatMemory(true);
        Flux stringFlux = this.aiChatService.createChatClient(aiRequest).prompt().user(prompt).tools(new Object[]{new TimeTool()}).tools(new Object[]{new SqlMcpComponent(this.nl2SqlService)}).toolContext(Map.of("agent", this.agent)).advisors(a -> a.param("chat_memory_conversation_id", (Object)chatId)).stream().content();
        return stringFlux;
    }

    @PostMapping(value={"/chat"})
    @Operation(summary="DashScope Flux Chat")
    public String chat3(HttpServletResponse response, @Validated @RequestBody String prompt, @RequestHeader(value="model", required=false) String model, @RequestHeader(value="chatId", required=false, defaultValue="spring-ai-alibaba-playground-chat") String chatId) throws GraphRunnerException {
        logger.info("Starting stream search for query: {} with agentId: {} with chatId {}", new Object[]{prompt, this.agent, chatId});
        String system = "\u4f60\u662f\u4e00\u4e2a\u4e13\u4e1aERP\u52a9\u624b\uff1a\u7cbe\u901aERP\u7cfb\u7edf\uff0c\u7cbe\u51c6\u7406\u89e3\u7528\u6237\u4e1a\u52a1\u610f\u56fe\u5e76\u81ea\u52a8\u5b8c\u6210\u4efb\u52a1.\n## \u6838\u5fc3\u80fd\u529b\n   - \u901a\u8fc7\u5de5\u5177\u67e5\u8be2\u4e1a\u52a1\u6570\u636e\u5e76\u5206\u6790,\u590d\u6742\u4efb\u52a1\u53ef\u4ee5\u62c6\u5206\u4e3a\u591a\u4e2a\u67e5\u8be2\u5e76\u6c47\u603b\u5206\u6790\n## \u5c55\u793a\u89c4\u8303\n   - \u591a\u6761\u7ed3\u679c\uff1a\u4f7f\u7528Markdown\u8868\u683c\u5f62\u5f0f\u5c55\u793a\n## \u4e1a\u52a1\u77e5\u8bc6\ngraph TB\nE10(E10ERP\u7cfb\u7edf)-->e101[\u516c\u5171\u7ba1\u7406\u7cfb\u7edf]\nE10-->e102[\u4f9b\u5e94\u94fe\u7ba1\u7406\u7cfb\u7edf]\nE10-->e103[\u751f\u4ea7\u5236\u9020\u7ba1\u7406\u7cfb\u7edf]\nE10-->e104[\u8d22\u52a1\u7ba1\u7406\u7cfb\u7edf]\n\ne101-->e10101[\u57fa\u7840\u6570\u636e]\ne101-->e10102[\u7cfb\u7edf\u53c2\u6570]\ne101-->e10103[\u7cfb\u7edf\u8bbe\u5b9a]\ne101-->e10104[\u7ba1\u7406\u5de5\u5177]\ne101-->e10105[\u76d1\u63a7\u9884\u8b66]\n\ne102-->e10201[\u5b58\u8d27\u7ba1\u7406]\ne102-->e10202[\u91c7\u8d2d\u7ba1\u7406]\ne102-->e10203[\u9500\u552e\u5206\u9500]\ne102-->e10204[\u6761\u7801\u7ba1\u7406]\ne102-->e10205[\u5e8f\u5217\u53f7\u7ba1\u7406]\ne102-->e10206[\u51fa\u53e3\u7ba1\u7406]\ne102-->e10207[\u552e\u80a1\u7ba1\u7406]\ne102-->e10208[\u7269\u6d41\u76f4\u8fde]\n\ne103-->e10301[BOM\u7ba1\u7406]\ne103-->e10302[\u5de5\u5355\u7ba1\u7406]\ne103-->e10303[\u5de5\u827a\u7ba1\u7406]\ne103-->e10304[\u8ba1\u5212\u7ba1\u7406]\ne103-->e10305[\u751f\u4ea7\u6392\u7a0b]\ne103-->e10306[\u4ea4\u6599\u6392\u7a0b]\ne103-->e10307[\u8d28\u91cf\u7ba1\u7406]\ne103-->e10308[\u8bbe\u5907\u7ba1\u7406]\n\ne104-->e10401[\u603b\u8d26]\ne104-->e10402[\u5e94\u6536\u7ba1\u7406]\ne104-->e10403[\u5e94\u4ed8\u7ba1\u7406]\ne104-->e10404[\u51fa\u7eb3\u7ba1\u7406]\ne104-->e10405[\u8d44\u4ea7\u7ba1\u7406]\ne104-->e10406[\u751f\u4ea7\u6210\u672c]\ne104-->e10407[\u81ea\u52a8\u5206\u5f55]\ne104-->e10408[\u5408\u5e76\u62a5\u8868]\ne104-->e10409[\u5229\u6da6\u4e2d\u5fc3]\ne104-->e10410[\u94f6\u4f01\u76f4\u8fde]\ne104-->e10411[\u7a0e\u52a1\u53d1\u7968\u7ba1\u7406]\ne104-->e10412[\u8d8a\u5357\u8d22\u52a1\u89e3\u51b3\u65b9\u6848]\ne104-->e10413[\u7a0e\u52a1\u53d1\u7968\u7ba1\u7406]\ne104-->e10414[\u7968\u636e\u7ba1\u7406]\n";
        AiRequest aiRequest = new AiRequest();
        aiRequest.setAgent(this.agent);
        aiRequest.setSystem(system);
        aiRequest.setUseChatMemory(true);
        aiRequest.setUseVectorStore(true);
        String stringFlux = this.aiChatService.createChatClient(aiRequest).prompt().user(prompt).tools(new Object[]{new TimeTool()}).tools(new Object[]{new SqlMcpComponent(this.nl2SqlService)}).toolContext(Map.of("agent", this.agent)).advisors(a -> a.param("chat_memory_conversation_id", (Object)chatId)).call().content();
        return stringFlux;
    }

    @RequestMapping(value={"initSchema1"})
    public Object initSchema1(@RequestBody InitSchemaDto schemaInfo) throws Exception {
        SchemaInitRequest request = new SchemaInitRequest();
        request.setAgent(schemaInfo.getAgent());
        request.setTables(schemaInfo.getTables());
        DbConfig dbConfig = this.sqlAsistantService.getDbConfig(schemaInfo.getAgent());
        request.setDbConfig(dbConfig);
        this.simpleVectorStoreService.schema(request);
        return schemaInfo;
    }
}

