/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athenai.nl2sql.node;

import com.alibaba.cloud.ai.graph.OverAllState;
import com.alibaba.cloud.ai.graph.action.NodeAction;
import com.digiwin.athenai.model.ExecutionStep;
import com.digiwin.athenai.model.Plan;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.converter.BeanOutputConverter;
import org.springframework.core.ParameterizedTypeReference;

public abstract class AbstractPlanBasedNode
implements NodeAction {
    private static final Logger logger = LoggerFactory.getLogger(AbstractPlanBasedNode.class);
    private final BeanOutputConverter<Plan> converter = new BeanOutputConverter((ParameterizedTypeReference)new ParameterizedTypeReference<Plan>(this){});

    protected AbstractPlanBasedNode() {
    }

    protected ExecutionStep getCurrentExecutionStep(OverAllState state) {
        String plannerNodeOutput = (String)state.value("PLANNER_NODE_OUTPUT").orElseThrow(() -> new IllegalStateException("\u8ba1\u5212\u8282\u70b9\u8f93\u51fa\u4e3a\u7a7a"));
        Plan plan = (Plan)this.converter.convert(plannerNodeOutput);
        if (plan == null) {
            throw new IllegalStateException("\u8ba1\u5212\u89e3\u6790\u5931\u8d25");
        }
        Integer currentStep = (Integer)state.value("PLAN_CURRENT_STEP", (Object)1);
        List executionPlan = plan.getExecutionPlan();
        if (executionPlan == null || executionPlan.isEmpty()) {
            throw new IllegalStateException("\u6267\u884c\u8ba1\u5212\u4e3a\u7a7a");
        }
        int stepIndex = currentStep - 1;
        if (stepIndex < 0 || stepIndex >= executionPlan.size()) {
            throw new IllegalStateException("\u5f53\u524d\u6b65\u9aa4\u7d22\u5f15\u8d85\u51fa\u8303\u56f4: " + stepIndex);
        }
        return (ExecutionStep)executionPlan.get(stepIndex);
    }

    protected Plan getPlan(OverAllState state) {
        String plannerNodeOutput = (String)state.value("PLANNER_NODE_OUTPUT").orElseThrow(() -> new IllegalStateException("\u8ba1\u5212\u8282\u70b9\u8f93\u51fa\u4e3a\u7a7a"));
        Plan plan = (Plan)this.converter.convert(plannerNodeOutput);
        if (plan == null) {
            throw new IllegalStateException("\u8ba1\u5212\u89e3\u6790\u5931\u8d25");
        }
        return plan;
    }

    protected Integer getCurrentStepNumber(OverAllState state) {
        return (Integer)state.value("PLAN_CURRENT_STEP", (Object)1);
    }

    protected void logNodeEntry() {
        logger.info("Entering {} node", (Object)this.getClass().getSimpleName());
    }

    protected void logNodeOutput(String outputKey, Object output) {
        logger.info("{} node output {}: {}", new Object[]{this.getClass().getSimpleName(), outputKey, output});
    }
}

