/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athenai.nl2sql.node;

import com.alibaba.cloud.ai.graph.OverAllState;
import com.alibaba.cloud.ai.graph.action.NodeAction;
import com.alibaba.cloud.ai.graph.async.AsyncGenerator;
import com.alibaba.fastjson.JSON;
import com.digiwin.athenai.component.AiChatService;
import com.digiwin.athenai.constant.StreamResponseType;
import com.digiwin.athenai.dashscope.util.StateUtils;
import com.digiwin.athenai.dashscope.util.StreamingChatGeneratorUtil;
import com.digiwin.athenai.model.ExecutionStep;
import com.digiwin.athenai.nl2sql.constant.PromptConstant;
import com.digiwin.athenai.nl2sql.utils.NodeUtil;
import com.digiwin.athenai.utils.MarkdownParser;
import com.digiwin.athenai.utils.StepResultUtils;
import java.util.HashMap;
import java.util.Map;
import reactor.core.publisher.Flux;

public class CalculateNode
implements NodeAction {
    AiChatService aiChatService;

    public CalculateNode(AiChatService aiChatService) {
        this.aiChatService = aiChatService;
    }

    public Map<String, Object> apply(OverAllState state) throws Exception {
        System.out.println("CalculateNode");
        String query = NodeUtil.queryFromState(state);
        String tablesStr = (String)state.value("tables", (Object)"");
        String plannerNodeOutput = StateUtils.getStringValue((OverAllState)state, (String)"PLANNER_NODE_OUTPUT");
        ExecutionStep executionStep = NodeUtil.getCurrentExecutionStep(state);
        Integer currentStep = NodeUtil.getCurrentStepNumber(state);
        ExecutionStep.ToolParameters toolParameters = executionStep.getToolParameters();
        Map sqlExecuteResult = (Map)StateUtils.getObjectValue((OverAllState)state, (String)"SQL_EXECUTE_NODE_OUTPUT", Map.class, new HashMap());
        String systemPrompt = PromptConstant.nl2sql_calculate().render(Map.of("user_query", query, "schema", tablesStr, "plan", plannerNodeOutput, "step", currentStep, "tool_parameters", JSON.toJSONString((Object)toolParameters)));
        Flux pythonAnalyzeFlux = this.aiChatService.chatClient().prompt().system(systemPrompt).stream().chatResponse();
        AsyncGenerator generator = StreamingChatGeneratorUtil.createStreamingGeneratorWithMessages(this.getClass(), (OverAllState)state, (String)"\u6b63\u5728\u8ba1\u7b97\u6570\u636e...\n", (String)"\n\u6570\u636e\u8ba1\u7b97\u5b8c\u6210\u5b8c\u6210\u3002", aiResponse -> {
            Map updatedSqlResult = StepResultUtils.addStepResult((Map)sqlExecuteResult, (Integer)currentStep, (String)MarkdownParser.extractRawText((String)aiResponse));
            return Map.of("SQL_EXECUTE_NODE_OUTPUT", updatedSqlResult, "PLAN_CURRENT_STEP", currentStep + 1);
        }, (Flux)pythonAnalyzeFlux, (StreamResponseType)StreamResponseType.PYTHON_ANALYSIS);
        return Map.of("PYTHON_ANALYSIS_NODE_OUTPUT", generator);
    }
}

