/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athenai.nl2sql.service.impl;

import com.digiwin.athenai.nl2sql.connector.MdTableGenerator;
import com.digiwin.athenai.nl2sql.connector.accessor.Accessor;
import com.digiwin.athenai.nl2sql.connector.bo.DbQueryParameter;
import com.digiwin.athenai.nl2sql.connector.bo.ResultSetBO;
import com.digiwin.athenai.nl2sql.connector.config.DbConfig;
import com.digiwin.athenai.nl2sql.service.SqlAsistantService;
import com.digiwin.athenai.nl2sql.service.SqlExecutorService;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
public class DbSqlExecutor
implements SqlExecutorService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DbSqlExecutor.class);
    @Autowired
    SqlAsistantService sqlAsistantService;
    @Autowired
    private List<Accessor> accessors;

    @Override
    public ResultSetBO executeSqlAndReturnObject(String agent, String sql) throws Exception {
        DbConfig dbConfig = this.sqlAsistantService.getDbConfig(agent);
        Assert.notNull((Object)dbConfig, (String)"dbConfig is null");
        Accessor accessor = this.getAccessor(dbConfig.getDialectType());
        Assert.notNull((Object)accessor, (String)"accessor is null");
        DbQueryParameter parameter = new DbQueryParameter();
        parameter.setSql(sql);
        return accessor.executeSqlAndReturnObject(dbConfig, parameter);
    }

    @Override
    public String executeSql(String agent, String sql) throws Exception {
        log.info("\u5f00\u59cb\u6267\u884csql: {} ", (Object)sql);
        long t1 = System.currentTimeMillis();
        ResultSetBO resultSetBO = this.executeSqlAndReturnObject(agent, sql);
        log.info("\u6267\u884csql\u5b8c\u6210,spend: {} ", (Object)(System.currentTimeMillis() - t1));
        return MdTableGenerator.generateTable(resultSetBO);
    }

    public Accessor getAccessor(String dialectType) {
        Accessor accessor = null;
        for (Accessor accessor1 : this.accessors) {
            if (!accessor1.getDbAccessorType().equalsIgnoreCase(dialectType)) continue;
            accessor = accessor1;
        }
        return accessor;
    }
}

