/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athenai.nl2sql.utils;

import com.digiwin.athenai.nl2sql.connector.config.DbConfig;
import com.digiwin.athenai.nl2sql.constant.BizDataSourceTypeEnum;
import com.digiwin.athenai.nl2sql.constant.PromptConstant;
import com.digiwin.athenai.nl2sql.dto.BusinessKnowledgeDTO;
import com.digiwin.athenai.nl2sql.dto.SemanticModelDTO;
import com.digiwin.athenai.nl2sql.dto.schema.ColumnDTO;
import com.digiwin.athenai.nl2sql.dto.schema.SchemaDTO;
import com.digiwin.athenai.nl2sql.dto.schema.TableDTO;
import com.digiwin.athenai.nl2sql.entity.UserPromptConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.ai.chat.prompt.PromptTemplate;
import org.springframework.util.CollectionUtils;

public class PromptHelper {
    private static final List<String> DATE_TIME_TYPES = Arrays.asList("DATE", "TIME", "DATETIME", "TIMESTAMP");

    public static String buildRewritePrompt(String query, SchemaDTO schemaDTO, List<String> evidenceList) {
        StringBuilder dbContent = new StringBuilder();
        dbContent.append("\u5e93\u540d: \u9ed8\u8ba4\u6570\u636e\u5e93, \u5305\u542b\u4ee5\u4e0b\u8868:\n");
        for (TableDTO tableDTO : schemaDTO.getTable()) {
            dbContent.append(PromptHelper.buildMacSqlTablePrompt(tableDTO)).append("\n");
        }
        StringBuilder multiTurn = new StringBuilder();
        multiTurn.append("<\u6700\u65b0>").append("\u7528\u6237: ").append(query);
        String evidence = CollectionUtils.isEmpty(evidenceList) ? "" : StringUtils.join(evidenceList, (String)";\n");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("db_content", dbContent.toString());
        params.put("evidence", evidence);
        params.put("multi_turn", multiTurn.toString());
        return PromptConstant.getInitRewritePromptTemplate().render(params);
    }

    public static String buildMacSqlTablePrompt(TableDTO tableDTO) {
        StringBuilder sb = new StringBuilder();
        sb.append("# \u8868\u540d: ").append(tableDTO.getName()).append(", \u5305\u542b\u5b57\u6bb5:\n");
        sb.append("[\n");
        ArrayList<String> columnLines = new ArrayList<String>();
        for (ColumnDTO columnDTO : tableDTO.getColumn()) {
            StringBuilder line = new StringBuilder();
            line.append("  (").append(StringUtils.defaultString((String)columnDTO.getDescription(), (String)columnDTO.getName()));
            if (!CollectionUtils.isEmpty(columnDTO.getData())) {
                line.append(", \u793a\u4f8b\u503c:[");
                List data = columnDTO.getData().subList(0, Math.min(3, columnDTO.getData().size())).stream().map(d -> "'" + d + "'").collect(Collectors.toList());
                line.append(StringUtils.join(data, (String)",")).append("])");
            } else {
                line.append(")");
            }
            columnLines.add(line.toString());
        }
        sb.append(StringUtils.join(columnLines, (String)",\n"));
        sb.append("\n]");
        return sb.toString();
    }

    public static String buildQueryToKeywordsPrompt(String question) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("question", question);
        return PromptConstant.getQuestionToKeywordsPromptTemplate().render(params);
    }

    public static String buildMixSelectorPrompt(List<String> evidences, String question, SchemaDTO schemaDTO) {
        String schemaInfo = PromptHelper.buildMixMacSqlDbPrompt(schemaDTO, true);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("schema_info", schemaInfo);
        params.put("question", question);
        String evidence = CollectionUtils.isEmpty(evidences) ? "" : StringUtils.join(evidences, (String)";\n");
        params.put("evidence", evidence);
        return PromptConstant.getMixSelectorPromptTemplate().render(params);
    }

    public static String buildDateTimeExtractPrompt(String question) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("question", question);
        return PromptConstant.getExtractDatetimePromptTemplate().render(params);
    }

    public static String buildMixMacSqlDbPrompt(SchemaDTO schemaDTO, Boolean withColumnType) {
        StringBuilder sb = new StringBuilder();
        sb.append("\u3010DB_ID\u3011 ").append(schemaDTO.getName() == null ? "" : schemaDTO.getName()).append("\n");
        for (TableDTO tableDTO : schemaDTO.getTable()) {
            sb.append(PromptHelper.buildMixMacSqlTablePrompt(tableDTO, withColumnType)).append("\n");
        }
        if (!CollectionUtils.isEmpty(schemaDTO.getForeignKeys()) && !CollectionUtils.isEmpty((Collection)schemaDTO.getForeignKeys().get(0))) {
            sb.append("\u3010Foreign keys\u3011\n").append(StringUtils.join((Iterable)schemaDTO.getForeignKeys().get(0), (String)"\n"));
        }
        return sb.toString();
    }

    public static String buildMixMacSqlTablePrompt(TableDTO tableDTO, Boolean withColumnType) {
        StringBuilder sb = new StringBuilder();
        sb.append("# Table: ").append(tableDTO.getName());
        if (!StringUtils.equals((CharSequence)tableDTO.getName(), (CharSequence)tableDTO.getDescription())) {
            sb.append((String)(StringUtils.isBlank((CharSequence)tableDTO.getDescription()) ? "" : ", " + tableDTO.getDescription())).append("\n");
        } else {
            sb.append("\n");
        }
        sb.append("[\n");
        ArrayList<String> columnLines = new ArrayList<String>();
        for (ColumnDTO columnDTO : tableDTO.getColumn()) {
            List enumData;
            StringBuilder line = new StringBuilder();
            line.append("(").append(columnDTO.getName()).append((String)(BooleanUtils.isTrue((Boolean)withColumnType) ? ":" + StringUtils.defaultString((String)columnDTO.getType(), (String)"").toUpperCase(Locale.ROOT) : ""));
            if (!StringUtils.equals((CharSequence)columnDTO.getDescription(), (CharSequence)columnDTO.getName())) {
                line.append(", ").append(StringUtils.defaultString((String)columnDTO.getDescription(), (String)""));
            }
            if (!CollectionUtils.isEmpty(tableDTO.getPrimaryKeys()) && tableDTO.getPrimaryKeys().contains(columnDTO.getName())) {
                line.append(", Primary Key");
            }
            if (!CollectionUtils.isEmpty(enumData = ((List)Optional.ofNullable(columnDTO.getData()).orElse(new ArrayList())).stream().filter(d -> !StringUtils.isEmpty((CharSequence)d)).collect(Collectors.toList())) && !"id".equals(columnDTO.getName())) {
                line.append(", Examples: [");
                data = new ArrayList(enumData.subList(0, Math.min(3, enumData.size())));
                line.append(StringUtils.join(data, (String)",")).append("]");
            } else if (!CollectionUtils.isEmpty(columnDTO.getSamples())) {
                data = columnDTO.getSamples().subList(0, Math.min(3, columnDTO.getSamples().size()));
                if (!CollectionUtils.isEmpty(data = data.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item)).collect(Collectors.toList()))) {
                    line.append(", Examples: [");
                    data = PromptHelper.processSamples(data, columnDTO);
                    line.append(StringUtils.join(data, (String)",")).append("]");
                }
            }
            line.append(")");
            columnLines.add(line.toString());
        }
        sb.append(StringUtils.join(columnLines, (String)",\n"));
        sb.append("\n]");
        return sb.toString();
    }

    private static List<String> processSamples(List<String> samples, ColumnDTO columnDTO) {
        ArrayList<String> data = new ArrayList<String>(samples);
        if (data.stream().anyMatch(item -> item.length() > 50)) {
            return new ArrayList<String>();
        }
        String type = columnDTO.getType();
        if (type != null && DATE_TIME_TYPES.contains(type.toUpperCase(Locale.ROOT))) {
            return data.isEmpty() ? Collections.emptyList() : Collections.singletonList((String)data.get(0));
        }
        if (type != null && type.equalsIgnoreCase("NUMBER")) {
            return data.isEmpty() ? Collections.emptyList() : Collections.singletonList((String)data.get(0));
        }
        String columnName = columnDTO.getName();
        if (columnName != null && columnName.trim().toLowerCase(Locale.ROOT).endsWith("id")) {
            return data.isEmpty() ? Collections.emptyList() : Collections.singletonList((String)data.get(0));
        }
        List longSamples = data.stream().filter(item -> item.length() > 20).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(longSamples)) {
            return Collections.singletonList((String)longSamples.get(0));
        }
        return data;
    }

    public static List<String> buildMixSqlGeneratorPrompt(String question, DbConfig dbConfig, SchemaDTO schemaDTO, List<String> evidenceList) {
        String evidence = StringUtils.join(evidenceList, (String)";\n");
        String schemaInfo = PromptHelper.buildMixMacSqlDbPrompt(schemaDTO, true);
        String dialect = BizDataSourceTypeEnum.fromTypeName(dbConfig.getDialectType()).getDialect();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("dialect", dialect);
        params.put("question", question);
        params.put("schema_info", schemaInfo);
        params.put("evidence", evidence);
        ArrayList<String> prompts = new ArrayList<String>();
        prompts.add(PromptConstant.getMixSqlGeneratorSystemPromptTemplate().render(params));
        prompts.add(PromptConstant.getMixSqlGeneratorPromptTemplate().render(params));
        return prompts;
    }

    public static String mixSqlGeneratorSystemCheckPrompt(String question, DbConfig dbConfig, SchemaDTO schemaDTO, List<String> evidenceList) {
        String evidence = StringUtils.join(evidenceList, (String)";\n");
        String schemaInfo = PromptHelper.buildMixMacSqlDbPrompt(schemaDTO, true);
        String dialect = BizDataSourceTypeEnum.fromTypeName(dbConfig.getDialectType()).getDialect();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("dialect", dialect);
        params.put("question", question);
        params.put("schema_info", schemaInfo);
        params.put("evidence", evidence);
        return PromptConstant.getMixSqlGeneratorSystemCheckPromptTemplate().render(params);
    }

    public static String buildSemanticConsistenPrompt(String nlReq, String sql) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("nl_req", nlReq);
        params.put("sql", sql);
        return PromptConstant.getSemanticConsistencyPromptTemplate().render(params);
    }

    public static String buildReportGeneratorPromptWithOptimization(String userRequirementsAndPlan, String analysisStepsAndData, String summaryAndRecommendations, List<UserPromptConfig> optimizationConfigs) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("user_requirements_and_plan", userRequirementsAndPlan);
        params.put("analysis_steps_and_data", analysisStepsAndData);
        params.put("summary_and_recommendations", summaryAndRecommendations);
        String optimizationSection = PromptHelper.buildOptimizationSection(optimizationConfigs, params);
        params.put("optimization_section", optimizationSection);
        return PromptConstant.getReportGeneratorPromptTemplate().render(params);
    }

    public static String buildSqlErrorFixerPrompt(String question, DbConfig dbConfig, SchemaDTO schemaDTO, List<String> evidenceList, String errorSql, String errorMessage) {
        String evidence = StringUtils.join(evidenceList, (String)";\n");
        String schemaInfo = PromptHelper.buildMixMacSqlDbPrompt(schemaDTO, true);
        String dialect = BizDataSourceTypeEnum.fromTypeName(dbConfig.getDialectType()).getDialect();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("dialect", dialect);
        params.put("question", question);
        params.put("schema_info", schemaInfo);
        params.put("evidence", evidence);
        params.put("error_sql", errorSql);
        params.put("error_message", errorMessage);
        return PromptConstant.getSqlErrorFixerPromptTemplate().render(params);
    }

    public static String buildBusinessKnowledgePrompt(List<BusinessKnowledgeDTO> businessKnowledgeDTOS) {
        HashMap<String, String> params = new HashMap<String, String>();
        String businessKnowledge = CollectionUtils.isEmpty(businessKnowledgeDTOS) ? "" : StringUtils.join(businessKnowledgeDTOS, (String)";\n");
        params.put("businessKnowledge", businessKnowledge);
        return PromptConstant.getBusinessKnowledgePromptTemplate().render(params);
    }

    public static String buildSemanticModelPrompt(List<SemanticModelDTO> semanticModelDTOS) {
        HashMap<String, String> params = new HashMap<String, String>();
        String semanticModel = CollectionUtils.isEmpty(semanticModelDTOS) ? "" : StringUtils.join(semanticModelDTOS, (String)";\n");
        params.put("semanticModel", semanticModel);
        return PromptConstant.getSemanticModelPromptTemplate().render(params);
    }

    private static String buildOptimizationSection(List<UserPromptConfig> optimizationConfigs, Map<String, Object> params) {
        if (optimizationConfigs == null || optimizationConfigs.isEmpty()) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        result.append("## \u4f18\u5316\u8981\u6c42\n");
        for (UserPromptConfig config : optimizationConfigs) {
            String optimizationContent = PromptHelper.renderOptimizationPrompt(config.getSystemPrompt(), params);
            if (optimizationContent.trim().isEmpty()) continue;
            result.append("- ").append(optimizationContent).append("\n");
        }
        return result.toString().trim();
    }

    private static String renderOptimizationPrompt(String optimizationPrompt, Map<String, Object> params) {
        if (optimizationPrompt == null || optimizationPrompt.trim().isEmpty()) {
            return "";
        }
        try {
            return new PromptTemplate(optimizationPrompt).render(params);
        }
        catch (Exception e) {
            return optimizationPrompt;
        }
    }
}

