/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athenai.nl2sql.code.impl;

import com.digiwin.athenai.nl2sql.code.CodeExecutorProperties;
import com.digiwin.athenai.nl2sql.code.CodePoolExecutorService;
import com.digiwin.athenai.nl2sql.code.impl.AbstractCodePoolExecutorService;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class LocalCodePoolExecutorService
extends AbstractCodePoolExecutorService
implements CodePoolExecutorService {
    private static final Logger logger = LoggerFactory.getLogger(LocalCodePoolExecutorService.class);
    private final ConcurrentHashMap<String, Path> containers = new ConcurrentHashMap();
    private static final String[] pythonNames = new String[]{"python3", "pypy3", "py3", "python", "pypy", "py"};
    private static final String[] pipNames = new String[]{"pip3", "pip"};

    public LocalCodePoolExecutorService(CodeExecutorProperties properties) {
        super(properties);
        if (this.checkProgramExists(pythonNames) == null) {
            throw new IllegalStateException("No valid Python interpreter was found for the current system environment variables. Please install Python3 into the system environment variables first.");
        }
    }

    @Override
    protected String createNewContainer() throws Exception {
        Path container = Files.createTempDirectory(this.properties.getContainerNamePrefix(), new FileAttribute[0]);
        String containerId = container.toString();
        this.containers.put(containerId, container);
        return containerId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected CodePoolExecutorService.TaskResponse execTaskInContainer(CodePoolExecutorService.TaskRequest request, String containerId) {
        Path container = this.containers.get(containerId);
        Path scriptFile = container.resolve("script.py");
        Path stdinFile = container.resolve("stdin.txt");
        Path requirementFile = container.resolve("requirements.txt");
        try {
            Files.write(scriptFile, Optional.ofNullable(request.code()).orElse("").getBytes(), new OpenOption[0]);
            Files.write(stdinFile, Optional.ofNullable(request.input()).orElse("").getBytes(), new OpenOption[0]);
            Files.write(requirementFile, Optional.ofNullable(request.requirement()).orElse("").getBytes(), new OpenOption[0]);
        }
        catch (Exception e) {
            logger.error("Create temp file failed: {}", (Object)e.getMessage(), (Object)e);
            return CodePoolExecutorService.TaskResponse.exception(e.getMessage());
        }
        if (this.checkProgramExists(pipNames) != null && StringUtils.hasText((String)request.requirement())) {
            ProcessBuilder pip = new ProcessBuilder(this.checkProgramExists(pipNames), "install", "--no-cache-dir", "-r", requirementFile.toAbsolutePath().toString(), ">", "/dev/null");
            Process process = null;
            try {
                process = pip.start();
                boolean completed = process.waitFor(this.properties.getContainerTimeout(), TimeUnit.MINUTES);
                if (!completed) {
                    process.destroy();
                    if (process.isAlive()) {
                        process.destroyForcibly();
                    }
                    throw new RuntimeException("Pip command timed out.");
                }
            }
            catch (Exception e) {
                logger.warn("Pip install failed: {}", (Object)e.getMessage(), (Object)e);
            }
            finally {
                if (process != null && process.isAlive()) {
                    process.destroyForcibly();
                }
            }
        }
        Process process = null;
        try {
            CodePoolExecutorService.TaskResponse taskResponse;
            ProcessBuilder pb = new ProcessBuilder(this.checkProgramExists(pythonNames), scriptFile.toAbsolutePath().toString());
            pb.directory(container.toFile());
            pb.redirectInput(stdinFile.toFile());
            process = pb.start();
            StringWriter stdoutWriter = new StringWriter();
            StringWriter stderrWriter = new StringWriter();
            try (BufferedReader stdoutReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                 BufferedReader stderrReader = new BufferedReader(new InputStreamReader(process.getErrorStream()));){
                CompletableFuture<Void> stdoutFuture = CompletableFuture.runAsync(() -> {
                    try {
                        stdoutReader.transferTo(stdoutWriter);
                    }
                    catch (IOException e) {
                        stderrWriter.write("Error reading stdout: " + e.getMessage());
                    }
                });
                CompletableFuture<Void> stderrFuture = CompletableFuture.runAsync(() -> {
                    try {
                        stderrReader.transferTo(stderrWriter);
                    }
                    catch (IOException e) {
                        stderrWriter.write("Error reading stderr: " + e.getMessage());
                    }
                });
                boolean completed = process.waitFor(this.parseToMilliseconds(this.properties.getCodeTimeout()), TimeUnit.MILLISECONDS);
                if (!completed) {
                    process.destroy();
                    if (process.isAlive()) {
                        process.destroyForcibly();
                    }
                    CodePoolExecutorService.TaskResponse taskResponse2 = CodePoolExecutorService.TaskResponse.failure("", "python code timeout, Killed.");
                    return taskResponse2;
                }
                CompletableFuture.allOf(stdoutFuture, stderrFuture).get(2L, TimeUnit.SECONDS);
            }
            int exitCode = process.exitValue();
            String stdout = stdoutWriter.toString();
            String stderr = stderrWriter.toString();
            if (exitCode != 0) {
                taskResponse = CodePoolExecutorService.TaskResponse.failure(stdout, stderr);
                return taskResponse;
            }
            taskResponse = CodePoolExecutorService.TaskResponse.success(stdout);
            return taskResponse;
        }
        catch (Exception e) {
            logger.error("Python execution failed: {}", (Object)e.getMessage(), (Object)e);
            CodePoolExecutorService.TaskResponse taskResponse = CodePoolExecutorService.TaskResponse.exception(e.getMessage());
            return taskResponse;
        }
        finally {
            if (process != null && process.isAlive()) {
                process.destroyForcibly();
            }
        }
    }

    @Override
    protected void stopContainer(String containerId) throws Exception {
    }

    @Override
    protected void removeContainer(String containerId) throws Exception {
        Path container = this.containers.remove(containerId);
        this.clearTempDir(container);
    }

    private String checkProgramExists(String ... programNames) {
        if (programNames == null) {
            return null;
        }
        String pathEnv = System.getenv("PATH");
        if (pathEnv == null) {
            return null;
        }
        String[] pathDirs = pathEnv.split(File.pathSeparator);
        boolean isWindows = System.getProperty("os.name").toLowerCase().contains("win");
        for (String program : programNames) {
            for (String dir : pathDirs) {
                Path exePath;
                if (dir == null || dir.trim().isEmpty()) continue;
                Path path = Paths.get(dir, program);
                if (Files.exists(path, new LinkOption[0]) && Files.isExecutable(path)) {
                    return program;
                }
                if (!isWindows || !Files.exists(exePath = Paths.get(dir, program + ".exe"), new LinkOption[0]) || !Files.isExecutable(exePath)) continue;
                return program;
            }
        }
        return null;
    }

    private long parseToMilliseconds(String timeString) {
        Pattern pattern = Pattern.compile("(\\d+)(ms|[smhd])");
        Matcher matcher = pattern.matcher(timeString.toLowerCase());
        if (matcher.find()) {
            String unit;
            long value = Long.parseLong(matcher.group(1));
            return switch (unit = matcher.group(2)) {
                case "ms" -> value;
                case "s" -> value * 1000L;
                case "m" -> value * 60L * 1000L;
                case "h" -> value * 60L * 60L * 1000L;
                case "d" -> value * 24L * 60L * 60L * 1000L;
                default -> {
                    logger.warn("Unknown time unit: {}", (Object)unit);
                    yield 60000L;
                }
            };
        }
        logger.warn("Invalid time format: {}", (Object)timeString);
        return 60000L;
    }
}

